/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.advancedmedieval.client.renderer;

import net.mcreator.advancedmedieval.client.model.ModelBrume;
import net.mcreator.advancedmedieval.client.model.animations.BrumeAnimation;
import net.mcreator.advancedmedieval.entity.BrumeEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BrumeRenderer
extends MobRenderer<BrumeEntity, ModelBrume<BrumeEntity>> {
    public BrumeRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelBrume.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(BrumeEntity entity) {
        return ResourceLocation.parse((String)"advanced_medieval:textures/entities/brumetexture.png");
    }

    private static final class AnimatedModel
    extends ModelBrume<BrumeEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BrumeEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BrumeEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, BrumeAnimation.Idle, ageInTicks, 1.0f);
                this.animateWalk(BrumeAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.1f);
                this.animate(entity.animationState2, BrumeAnimation.attack, ageInTicks, 1.4f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BrumeEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

