/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.advancedmedieval.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.advancedmedieval.client.model.Modelcrocodillo;
import net.mcreator.advancedmedieval.client.model.animations.crocodilloAnimation;
import net.mcreator.advancedmedieval.entity.CrocodilloEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class CrocodilloRenderer
extends MobRenderer<CrocodilloEntity, Modelcrocodillo<CrocodilloEntity>> {
    public CrocodilloRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelcrocodillo.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(CrocodilloEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(CrocodilloEntity entity) {
        return ResourceLocation.parse((String)"advanced_medieval:textures/entities/crocodillo.png");
    }

    private static final class AnimatedModel
    extends Modelcrocodillo<CrocodilloEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<CrocodilloEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(CrocodilloEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(crocodilloAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.1f);
                this.animate(entity.animationState1, crocodilloAnimation.attack, ageInTicks, 1.3f);
                this.animate(entity.animationState2, crocodilloAnimation.idle, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(CrocodilloEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

