/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.advancedmedieval.client.renderer;

import net.mcreator.advancedmedieval.client.model.ModelFoloM;
import net.mcreator.advancedmedieval.client.model.animations.FoloMAnimation;
import net.mcreator.advancedmedieval.entity.FoloEntity;
import net.mcreator.advancedmedieval.procedures.FoloPlaybackCondition2Procedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class FoloRenderer
extends MobRenderer<FoloEntity, ModelFoloM<FoloEntity>> {
    public FoloRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelFoloM.LAYER_LOCATION)), 0.8f);
    }

    public ResourceLocation getTextureLocation(FoloEntity entity) {
        return ResourceLocation.parse((String)"advanced_medieval:textures/entities/folomonstertexture.png");
    }

    private static final class AnimatedModel
    extends ModelFoloM<FoloEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<FoloEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(FoloEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, FoloMAnimation.idle, ageInTicks, 1.0f);
                if (FoloPlaybackCondition2Procedure.execute((Entity)entity)) {
                    this.animateWalk(FoloMAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                }
                this.animate(entity.animationState2, FoloMAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(FoloEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

