/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.advancedmedieval.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.advancedmedieval.client.model.ModelReanimatedKnight;
import net.mcreator.advancedmedieval.client.model.animations.ReanimatedKnightAnimation;
import net.mcreator.advancedmedieval.entity.FreindlyReanimatedKnightEntity;
import net.mcreator.advancedmedieval.procedures.ReanimatedKnightPlaybackCondition2Procedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class FreindlyReanimatedKnightRenderer
extends MobRenderer<FreindlyReanimatedKnightEntity, ModelReanimatedKnight<FreindlyReanimatedKnightEntity>> {
    public FreindlyReanimatedKnightRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelReanimatedKnight.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(FreindlyReanimatedKnightEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(FreindlyReanimatedKnightEntity entity) {
        return ResourceLocation.parse((String)"advanced_medieval:textures/entities/freindly_reanimated_knight.png");
    }

    private static final class AnimatedModel
    extends ModelReanimatedKnight<FreindlyReanimatedKnightEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<FreindlyReanimatedKnightEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(FreindlyReanimatedKnightEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, ReanimatedKnightAnimation.idle, ageInTicks, 1.0f);
                if (ReanimatedKnightPlaybackCondition2Procedure.execute((Entity)entity)) {
                    this.animateWalk(ReanimatedKnightAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                }
                this.animate(entity.animationState2, ReanimatedKnightAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(FreindlyReanimatedKnightEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

