/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.advancedmedieval.client.renderer;

import net.mcreator.advancedmedieval.client.model.ModelWisp;
import net.mcreator.advancedmedieval.client.model.animations.WispAnimation;
import net.mcreator.advancedmedieval.entity.WispEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class WispRenderer
extends MobRenderer<WispEntity, ModelWisp<WispEntity>> {
    public WispRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelWisp.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(WispEntity entity) {
        return ResourceLocation.parse((String)"advanced_medieval:textures/entities/wisptexture.png");
    }

    private static final class AnimatedModel
    extends ModelWisp<WispEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<WispEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(WispEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, WispAnimation.idle, ageInTicks, 1.0f);
                this.animateWalk(WispAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.5f);
                this.animate(entity.animationState2, WispAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(WispEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

