/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.advancedmedieval.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.advancedmedieval.block.ObitusBlock;
import net.mcreator.advancedmedieval.block.entity.ObitusBlockEntity;
import net.mcreator.advancedmedieval.client.model.ModelObitus_Converted;
import net.mcreator.advancedmedieval.client.model.animations.Obitus_ConvertedAnimation;
import net.mcreator.advancedmedieval.init.AdvancedMedievalModBlockEntities;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ObitusRenderer
implements BlockEntityRenderer<ObitusBlockEntity> {
    private final CustomHierarchicalModel model;
    private final ResourceLocation texture;

    ObitusRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(ModelObitus_Converted.LAYER_LOCATION));
        this.texture = ResourceLocation.parse((String)"advanced_medieval:textures/block/obitustexture.png");
    }

    private void updateRenderState(ObitusBlockEntity blockEntity) {
        int tickCount = (int)blockEntity.getLevel().getGameTime();
        blockEntity.animationState0.animateWhen(true, tickCount);
    }

    public void render(ObitusBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource renderer, int light, int overlayLight) {
        this.updateRenderState(blockEntity);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)ObitusBlock.FACING);
        switch (facing) {
            case NORTH: {
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.model.setupBlockEntityAnim(blockEntity, (float)blockEntity.getLevel().getGameTime() + partialTick);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)AdvancedMedievalModBlockEntities.OBITUS.get(), ObitusRenderer::new);
    }

    private static final class CustomHierarchicalModel
    extends ModelObitus_Converted {
        private final ModelPart root;
        private final BlockEntityHierarchicalModel animator = new BlockEntityHierarchicalModel();

        public CustomHierarchicalModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        public void setupBlockEntityAnim(ObitusBlockEntity blockEntity, float ageInTicks) {
            this.animator.setupBlockEntityAnim(blockEntity, ageInTicks);
            super.setupAnim(null, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        }

        private class BlockEntityHierarchicalModel
        extends HierarchicalModel<Entity> {
            private BlockEntityHierarchicalModel() {
            }

            public ModelPart root() {
                return CustomHierarchicalModel.this.root;
            }

            public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            }

            public void setupBlockEntityAnim(ObitusBlockEntity blockEntity, float ageInTicks) {
                CustomHierarchicalModel.this.animator.root().getAllParts().forEach(ModelPart::resetPose);
                CustomHierarchicalModel.this.animator.animate(blockEntity.animationState0, Obitus_ConvertedAnimation.spin, ageInTicks, 1.2f);
            }
        }
    }
}

