/*
 * Decompiled with CFR 0.152.
 */
package pw.rxj.bukkit.pingwheel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import pw.rxj.bukkit.pingwheel.api.FriendlyByteBuf;
import pw.rxj.bukkit.pingwheel.api.PingWheel;
import pw.rxj.bukkit.pingwheel.api.ReceivePing;
import pw.rxj.bukkit.pingwheel.command.config.ConfigCommand;
import pw.rxj.bukkit.pingwheel.config.ConfigHandler;
import pw.rxj.bukkit.pingwheel.records.ChannelUpdate;
import pw.rxj.bukkit.pingwheel.util.PrefixedLogger;

public final class Main
extends JavaPlugin
implements Listener {
    public static final String PLUGIN_ID = "pingwheel-plugin";
    public static final PrefixedLogger LOGGER = new PrefixedLogger("pingwheel-plugin");
    public final PluginManager pluginManager = this.getServer().getPluginManager();
    public final Messenger messenger = this.getServer().getMessenger();
    public final PingWheel pingWheel = new PingWheel();
    public static ConfigHandler CONFIG = null;

    public void onEnable() {
        CONFIG = ConfigHandler.bake(this);
        CONFIG.read();
        this.messenger.registerIncomingPluginChannel((Plugin)this, "ping-wheel-c2s:ping-location", (channel, player, data) -> {
            ByteBuf buf = Unpooled.buffer((int)0);
            buf.writeBytes(data);
            ReceivePing receivePing = ReceivePing.from(new FriendlyByteBuf(buf));
            if (receivePing == null || receivePing.getChannel() == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "[Ping-Wheel] Ping couldn't be sent. (incompatible version?)");
            } else {
                this.pingWheel.onPingLocation(player, receivePing, (Plugin)this);
            }
        });
        this.messenger.registerIncomingPluginChannel((Plugin)this, "ping-wheel-c2s:update-channel", (channel, player, data) -> {
            ByteBuf buf = Unpooled.buffer((int)0);
            buf.writeBytes(data);
            ChannelUpdate channelUpdate = ChannelUpdate.from(new FriendlyByteBuf(buf));
            if (channelUpdate == null || channelUpdate.channel() == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "[Ping-Wheel] Channel couldn't be updated. (incompatible version?)");
            } else {
                this.pingWheel.onChannelUpdate(player, channelUpdate);
            }
        });
        this.messenger.registerOutgoingPluginChannel((Plugin)this, "ping-wheel-s2c:ping-location");
        this.pluginManager.registerEvents((Listener)this, (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PingWheel(), (Plugin)this);
        PluginCommand ConfigCommand2 = this.getCommand("pw_config");
        if (ConfigCommand2 != null) {
            ConfigCommand command = new ConfigCommand();
            ConfigCommand2.setExecutor((CommandExecutor)command);
            ConfigCommand2.setTabCompleter((TabCompleter)command);
        }
    }

    public void onDisable() {
        this.messenger.unregisterIncomingPluginChannel((Plugin)this);
        this.messenger.unregisterOutgoingPluginChannel((Plugin)this);
    }
}

