/*
 * Decompiled with CFR 0.152.
 */
package pw.rxj.bukkit.pingwheel.api;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class FriendlyByteBuf {
    private final ByteBuf byteBuf;

    public FriendlyByteBuf(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    public byte[] toByteArray() {
        this.byteBuf.resetReaderIndex();
        byte[] byteArray = new byte[this.byteBuf.readableBytes()];
        this.byteBuf.readBytes(byteArray);
        return byteArray;
    }

    public String readString() {
        return this.readString(Short.MAX_VALUE);
    }

    public String readString(int max) {
        int length = this.readVarInt();
        if (length > max * 3) {
            return null;
        }
        if (length < 0) {
            return null;
        }
        String string = this.byteBuf.toString(this.byteBuf.readerIndex(), length, StandardCharsets.UTF_8);
        this.byteBuf.readerIndex(this.byteBuf.readerIndex() + length);
        if (string.length() > max) {
            return null;
        }
        return string;
    }

    public void writeString(String string) {
        this.writeString(string, Short.MAX_VALUE);
    }

    public void writeString(String string, int maxLength) {
        int encodedStringLength;
        if (string.length() > maxLength) {
            throw new EncoderException("String too big (was " + string.length() + " characters, max " + maxLength + ")");
        }
        byte[] stringBytes = string.getBytes(StandardCharsets.UTF_8);
        if (stringBytes.length > (encodedStringLength = maxLength * 3)) {
            throw new EncoderException("String too big (was " + stringBytes.length + " bytes encoded, max " + encodedStringLength + ")");
        }
        this.writeVarInt(stringBytes.length);
        this.byteBuf.writeBytes(stringBytes);
    }

    public int readInt() {
        return this.byteBuf.readInt();
    }

    public void writeInt(int value) {
        this.byteBuf.writeInt(value);
    }

    public void writeVarInt(int value) {
        while ((value & 0xFFFFFF80) != 0) {
            this.byteBuf.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.byteBuf.writeByte(value);
    }

    public double readDouble() {
        return this.byteBuf.readDouble();
    }

    public void writeDouble(double value) {
        this.byteBuf.writeDouble(value);
    }

    public boolean readBoolean() {
        return this.byteBuf.readBoolean();
    }

    public void writeBoolean(boolean value) {
        this.byteBuf.writeBoolean(value);
    }

    public UUID readUUID() {
        return new UUID(this.byteBuf.readLong(), this.byteBuf.readLong());
    }

    public void writeUUID(UUID uuid) {
        this.byteBuf.writeLong(uuid.getMostSignificantBits());
        this.byteBuf.writeLong(uuid.getLeastSignificantBits());
    }

    public int readVarInt() {
        byte b0;
        int i = 0;
        int j = 0;
        do {
            b0 = this.byteBuf.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }
}

