/*
 * Decompiled with CFR 0.152.
 */
package pw.rxj.bukkit.pingwheel.api;

import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import pw.rxj.bukkit.pingwheel.api.FriendlyByteBuf;

public class ReceivePing {
    private String channel;
    private double x;
    private double y;
    private double z;
    private boolean isEntity;
    private UUID entityId;
    private int sequence;
    private int dimension;

    private ReceivePing(String channel, double x, double y, double z, boolean isEntity, UUID entityId, int sequence, int dimension) {
        this.channel = channel;
        this.x = x;
        this.y = y;
        this.z = z;
        this.isEntity = isEntity;
        this.entityId = entityId;
        this.sequence = sequence;
        this.dimension = dimension;
    }

    @Nullable
    public static ReceivePing from(FriendlyByteBuf buf) {
        try {
            String channel = buf.readString(128);
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            boolean isEntity = buf.readBoolean();
            UUID entityId = isEntity ? buf.readUUID() : null;
            int sequence = buf.readInt();
            int dimension = buf.readInt();
            return new ReceivePing(channel, x, y, z, isEntity, entityId, sequence, dimension);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void stripPlayerEntity() {
        if (!this.isEntity || this.entityId == null) {
            return;
        }
        Optional<Player> player = Bukkit.getServer().getOnlinePlayers().stream().filter(p -> p.getUniqueId().equals(this.entityId)).findFirst();
        if (player.isEmpty()) {
            return;
        }
        this.isEntity = false;
        this.entityId = null;
    }

    public FriendlyByteBuf asFriendlyByteBuf() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer((int)0));
        buf.writeString(this.channel);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeBoolean(this.isEntity);
        if (this.isEntity) {
            buf.writeUUID(this.entityId);
        }
        buf.writeInt(this.sequence);
        buf.writeInt(this.dimension);
        return buf;
    }

    @Generated
    public String getChannel() {
        return this.channel;
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public boolean isEntity() {
        return this.isEntity;
    }

    @Generated
    public UUID getEntityId() {
        return this.entityId;
    }

    @Generated
    public int getSequence() {
        return this.sequence;
    }

    @Generated
    public int getDimension() {
        return this.dimension;
    }

    @Generated
    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Generated
    public void setX(double x) {
        this.x = x;
    }

    @Generated
    public void setY(double y) {
        this.y = y;
    }

    @Generated
    public void setZ(double z) {
        this.z = z;
    }

    @Generated
    public void setEntity(boolean isEntity) {
        this.isEntity = isEntity;
    }

    @Generated
    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    @Generated
    public void setDimension(int dimension) {
        this.dimension = dimension;
    }
}

