/*
 * Decompiled with CFR 0.152.
 */
package pw.rxj.bukkit.pingwheel.config;

import java.util.Objects;
import lombok.Generated;

public class Config {
    public final Server SERVER = new Server();

    private Config() {
    }

    protected static Config empty() {
        return new Config();
    }

    protected void override(Config newConfig) {
        this.overrideServer(newConfig.SERVER);
    }

    protected void overrideServer(Server newServerConfig) {
        this.SERVER.defaultChannel = newServerConfig.defaultChannel;
        this.SERVER.allowPlayerTracking = newServerConfig.allowPlayerTracking;
        this.SERVER.rateLimit = newServerConfig.rateLimit;
        this.SERVER.rateLimitRegen = newServerConfig.rateLimitRegen;
    }

    public int hashCode() {
        return Objects.hash(this.SERVER);
    }

    public static class Server {
        public DefaultChannel defaultChannel = DefaultChannel.AUTO;
        public boolean allowPlayerTracking = true;
        public int rateLimit = 5;
        public int rateLimitRegen = 1000;

        private Server() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Server)) {
                return false;
            }
            Server other = (Server)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.allowPlayerTracking != other.allowPlayerTracking) {
                return false;
            }
            if (this.rateLimit != other.rateLimit) {
                return false;
            }
            if (this.rateLimitRegen != other.rateLimitRegen) {
                return false;
            }
            DefaultChannel this$defaultChannel = this.defaultChannel;
            DefaultChannel other$defaultChannel = other.defaultChannel;
            return !(this$defaultChannel == null ? other$defaultChannel != null : !((Object)((Object)this$defaultChannel)).equals((Object)other$defaultChannel));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Server;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.allowPlayerTracking ? 79 : 97);
            result = result * 59 + this.rateLimit;
            result = result * 59 + this.rateLimitRegen;
            DefaultChannel $defaultChannel = this.defaultChannel;
            result = result * 59 + ($defaultChannel == null ? 43 : ((Object)((Object)$defaultChannel)).hashCode());
            return result;
        }
    }

    public static enum DefaultChannel {
        AUTO("auto"),
        DISABLED("disabled"),
        GLOBAL("global"),
        TEAM_ONLY("team_only");

        private final String mode;

        private DefaultChannel(String mode) {
            this.mode = mode;
        }

        public static DefaultChannel from(String name) {
            for (DefaultChannel defaultChannel : DefaultChannel.values()) {
                if (!defaultChannel.mode.equalsIgnoreCase(name)) continue;
                return defaultChannel;
            }
            return AUTO;
        }
    }
}

