package rs.onako2.metalized;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2399;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.onako2.metalized.block.RedstoneLaddersBlock;
import rs.onako2.metalized.block.RedstoneStairsBlock;
import rs.onako2.metalized.init.Identifiers;
import rs.onako2.metalized.init.ModItems;

import static rs.onako2.metalized.init.Identifiers.ironStairs;
import static rs.onako2.metalized.init.Identifiers.redstoneStairs;

public class Metalized implements ModInitializer {
    
    public static final Logger LOGGER = LoggerFactory.getLogger("metalized");
    
    public static final class_2510 IRON_STAIRS;
    public static final class_2510 GOLD_STAIRS;
    public static final class_2510 LAPIS_STAIRS;
    public static final class_2510 DIAMOND_STAIRS;
    public static final class_2510 EMERALD_STAIRS;
    public static final class_2510 COAL_STAIRS;
    public static final RedstoneStairsBlock REDSTONE_STAIRS;
    public static final class_2510 NETHERITE_STAIRS;
    
    public static final class_2399 IRON_LADDER;
    public static final class_2399 GOLD_LADDER;
    public static final class_2399 LAPIS_LADDER;
    public static final class_2399 DIAMOND_LADDER;
    public static final class_2399 EMERALD_LADDER;
    public static final class_2399 COAL_LADDER;
    public static final RedstoneLaddersBlock REDSTONE_LADDER;
    public static final class_2399 NETHERITE_LADDER;
    
    public static final class_1761 METALIZED_ITEM_GROUP;
    
    static {
        IRON_STAIRS = (class_2510) registerStairsBlock(ironStairs, class_2246.field_10085);
        GOLD_STAIRS = (class_2510) registerStairsBlock(Identifiers.goldStairs, class_2246.field_10205);
        LAPIS_STAIRS = (class_2510) registerStairsBlock(Identifiers.lapisStairs, class_2246.field_10441);
        DIAMOND_STAIRS = (class_2510) registerStairsBlock(Identifiers.diamondStairs, class_2246.field_10201);
        EMERALD_STAIRS = (class_2510) registerStairsBlock(Identifiers.emeraldStairs, class_2246.field_10234);
        COAL_STAIRS = (class_2510) registerStairsBlock(Identifiers.coalStairs, class_2246.field_10381);
        REDSTONE_STAIRS = (RedstoneStairsBlock) class_2246.method_63053(class_5321.method_29179(class_7924.field_41254, redstoneStairs), (settings) -> new RedstoneStairsBlock(class_2246.field_10002.method_9564(), settings), class_4970.class_2251.method_9630(class_2246.field_10002).method_51370().method_22488().method_50012(class_3619.field_15971));
        NETHERITE_STAIRS = (class_2510) registerStairsBlock(Identifiers.netheriteStairs, class_2246.field_22108);
        
        IRON_LADDER = (class_2399) registerLadderBlock(Identifiers.ironLadder, class_2246.field_10085);
        GOLD_LADDER = (class_2399) registerLadderBlock(Identifiers.goldLadder, class_2246.field_10205);
        LAPIS_LADDER = (class_2399) registerLadderBlock(Identifiers.lapisLadder, class_2246.field_10441);
        DIAMOND_LADDER = (class_2399) registerLadderBlock(Identifiers.diamondLadder, class_2246.field_10201);
        EMERALD_LADDER = (class_2399) registerLadderBlock(Identifiers.emeraldLadder, class_2246.field_10234);
        COAL_LADDER = (class_2399) registerLadderBlock(Identifiers.coalLadder, class_2246.field_10381);
        REDSTONE_LADDER = (RedstoneLaddersBlock) class_2246.method_63053(class_5321.method_29179(class_7924.field_41254, Identifiers.redstoneLadder), RedstoneLaddersBlock::new, class_4970.class_2251.method_9630(class_2246.field_10002).method_51370().method_22488().method_50012(class_3619.field_15971));
        NETHERITE_LADDER = (class_2399) registerLadderBlock(Identifiers.netheriteLadder, class_2246.field_22108);
        
        METALIZED_ITEM_GROUP = FabricItemGroup.builder()
                .method_47320(() -> new class_1799(IRON_STAIRS))
                .method_47321(class_2561.method_43471("itemGroup.metalized.main_group"))
                .method_47317((context, entries) -> {
                    entries.method_45421(IRON_STAIRS);
                    entries.method_45421(COAL_STAIRS);
                    entries.method_45421(REDSTONE_STAIRS);
                    entries.method_45421(EMERALD_STAIRS);
                    entries.method_45421(GOLD_STAIRS);
                    entries.method_45421(DIAMOND_STAIRS);
                    entries.method_45421(LAPIS_STAIRS);
                    entries.method_45421(NETHERITE_STAIRS);
                    entries.method_45421(IRON_LADDER);
                    entries.method_45421(COAL_LADDER);
                    entries.method_45421(REDSTONE_LADDER);
                    entries.method_45421(EMERALD_LADDER);
                    entries.method_45421(GOLD_LADDER);
                    entries.method_45421(DIAMOND_LADDER);
                    entries.method_45421(LAPIS_LADDER);
                    entries.method_45421(NETHERITE_LADDER);
                })
                .method_47324();
    }
    
    private static class_2248 registerStairsBlock(class_2960 id, class_2248 base) {
        return class_2246.method_63053(class_5321.method_29179(class_7924.field_41254, id), (settings) -> new class_2510(base.method_9564(), settings), class_4970.class_2251.method_9630(base));
    }
    
    private static class_2248 registerLadderBlock(class_2960 id, class_2248 base) {
        return class_2246.method_63053(class_5321.method_29179(class_7924.field_41254, id), class_2399::new, class_4970.class_2251.method_9630(base).method_51370().method_22488().method_50012(class_3619.field_15971));
    }
    
    @Override
    public void onInitialize() {
        LOGGER.info("Metalizing da blocks and converting them to breakfast!");
        ModItems.Init();
        class_2378.method_10230(class_7923.field_44687, class_2960.method_60655("metalized", "main_group"), Metalized.METALIZED_ITEM_GROUP);
    }
    
}
