/*
 * Decompiled with CFR 0.152.
 */
package eu.pablob.paper_telegram_bridge;

import eu.pablob.paper_telegram_bridge.MinecraftFontLoader;
import eu.pablob.paper_telegram_bridge.TextureUtilsKt;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Locale;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J \u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u001a\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Leu/pablob/paper_telegram_bridge/AdvancementRenderer;", "", "<init>", "()V", "width", "", "height", "borderColor", "Ljava/awt/Color;", "titleColor", "fontSize", "", "renderAdvancement", "", "advancementTitle", "", "frameType", "icon", "Lorg/bukkit/inventory/ItemStack;", "textColor", "drawBackground", "", "g", "Ljava/awt/Graphics2D;", "drawTitle", "title", "drawSubtitle", "drawIcon", "item", "paper-telegram-bridge"})
@SourceDebugExtension(value={"SMAP\nAdvancementRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancementRenderer.kt\neu/pablob/paper_telegram_bridge/AdvancementRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class AdvancementRenderer {
    private final int width;
    private final int height;
    @NotNull
    private final Color borderColor = new Color(78, 78, 78);
    @NotNull
    private final Color titleColor = new Color(234, 234, 2);
    private final float fontSize;

    public AdvancementRenderer() {
        this.width = 320;
        this.height = 64;
        this.fontSize = 16.0f;
    }

    @NotNull
    public final byte[] renderAdvancement(@NotNull String advancementTitle, @NotNull String frameType, @Nullable ItemStack icon, @NotNull Color textColor) {
        Intrinsics.checkNotNullParameter(advancementTitle, "advancementTitle");
        Intrinsics.checkNotNullParameter(frameType, "frameType");
        Intrinsics.checkNotNullParameter(textColor, "textColor");
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        Graphics2D g = image.createGraphics();
        Intrinsics.checkNotNull(g);
        this.drawBackground(g);
        this.drawTitle(g, advancementTitle);
        this.drawSubtitle(g, frameType, textColor);
        this.drawIcon(g, icon);
        g.dispose();
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", outputStream2);
        byte[] byArray = outputStream2.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }

    private final void drawBackground(Graphics2D g) {
        BufferedImage backgroundImage = TextureUtilsKt.loadImage("/advancement32.png", this.getClass());
        g.drawImage(backgroundImage, 0, 0, Color.BLACK, null);
    }

    private final void drawTitle(Graphics2D g, String title) {
        g.setFont(MinecraftFontLoader.INSTANCE.getFont(this.fontSize));
        g.setColor(Color.WHITE);
        g.drawString(title, 72, 60);
    }

    private final void drawSubtitle(Graphics2D g, String frameType, Color textColor) {
        String string = frameType;
        String subtitle = Intrinsics.areEqual(string, "goal") ? "Goal Reached!" : (Intrinsics.areEqual(string, "challenge") ? "Challenge Complete!" : "Advancement Made!");
        g.setFont(MinecraftFontLoader.INSTANCE.getFont(this.fontSize));
        g.setColor(Intrinsics.areEqual(textColor, new Color(85, 255, 85)) ? this.titleColor : textColor);
        g.drawString(subtitle, 72, 35);
    }

    private final void drawIcon(Graphics2D g, ItemStack item) {
        BufferedImage texture;
        ItemStack itemStack = item;
        if (itemStack != null && (itemStack = itemStack.getType()) != null) {
            ItemStack it = itemStack;
            boolean bl = false;
            String string = it.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            v2 = TextureUtilsKt.loadItemTexture(string, this.getClass());
        } else {
            v2 = texture = null;
        }
        if (texture != null) {
            g.drawImage(texture, 20, 15, 32, 32, null);
        } else {
            g.setColor(Color.GRAY);
            g.fillRect(20, 15, 32, 32);
        }
    }
}

