/*
 * Decompiled with CFR 0.152.
 */
package eu.pablob.paper_telegram_bridge;

import eu.pablob.paper_telegram_bridge.AsyncJavaPlugin;
import eu.pablob.paper_telegram_bridge.MinecraftFontLoader;
import eu.pablob.paper_telegram_bridge.TextureUtilsKt;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.lang.invoke.CallSite;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Leu/pablob/paper_telegram_bridge/BookRenderer;", "", "plugin", "Leu/pablob/paper_telegram_bridge/AsyncJavaPlugin;", "<init>", "(Leu/pablob/paper_telegram_bridge/AsyncJavaPlugin;)V", "marginLeft", "", "marginTop", "pageWidth", "pageHeight", "renderBookToFile", "Lkotlin/Pair;", "Ljava/io/File;", "", "book", "Lorg/bukkit/inventory/ItemStack;", "drawBookText", "", "g", "Ljava/awt/Graphics2D;", "page", "pageIndex", "totalPages", "renderBackground", "image", "Ljava/awt/image/BufferedImage;", "generateBookHash", "paper-telegram-bridge"})
@SourceDebugExtension(value={"SMAP\nBookRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookRenderer.kt\neu/pablob/paper_telegram_bridge/BookRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1557#2:127\n1628#2,3:128\n1557#2:131\n1628#2,3:132\n*S KotlinDebug\n*F\n+ 1 BookRenderer.kt\neu/pablob/paper_telegram_bridge/BookRenderer\n*L\n23#1:127\n23#1:128,3\n116#1:131\n116#1:132,3\n*E\n"})
public final class BookRenderer {
    @NotNull
    private final AsyncJavaPlugin plugin;
    private final int marginLeft;
    private final int marginTop;
    private final int pageWidth;
    private final int pageHeight;

    public BookRenderer(@NotNull AsyncJavaPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.marginLeft = 40;
        this.marginTop = 60;
        this.pageWidth = 350;
        this.pageHeight = 432;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<File, String> renderBookToFile(@NotNull ItemStack book) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(book, "book");
        ItemMeta itemMeta = book.getItemMeta();
        BookMeta bookMeta = itemMeta instanceof BookMeta ? (BookMeta)itemMeta : null;
        if (bookMeta == null) {
            return new Pair<Object, Object>(null, null);
        }
        BookMeta meta = bookMeta;
        PlainTextComponentSerializer plainTextComponentSerializer = PlainTextComponentSerializer.plainText();
        Intrinsics.checkNotNullExpressionValue(plainTextComponentSerializer, "plainText(...)");
        PlainTextComponentSerializer serializer = plainTextComponentSerializer;
        List list = meta.pages();
        Intrinsics.checkNotNullExpressionValue(list, "pages(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Component component = (Component)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(serializer.serialize((Component)it));
        }
        List pages = (List)destination$iv$iv;
        File outputFolder = new File(this.plugin.getDataFolder(), "inv/books/" + this.generateBookHash(book));
        outputFolder.mkdirs();
        List pageFiles = new ArrayList();
        String caption = null;
        if (meta.getTitle() != null) {
            caption = meta.getTitle() + " by " + meta.getAuthor();
        }
        Iterator iterator2 = ((Iterable)pages).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Object t = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(t, "next(...)");
            String page = (String)t;
            BufferedImage image = new BufferedImage(this.pageWidth, this.pageHeight, 2);
            Graphics2D g = image.createGraphics();
            Intrinsics.checkNotNull(g);
            this.renderBackground(g, image);
            this.drawBookText(g, page, index + 1, pages.size());
            g.dispose();
            File outputFile = new File(outputFolder, "page" + (index + 1) + ".png");
            ImageIO.write((RenderedImage)image, "png", outputFile);
            pageFiles.add(outputFile);
        }
        return new Pair<File, CallSite>(outputFolder, (CallSite)((Object)caption));
    }

    private final void drawBookText(Graphics2D g, String page, int pageIndex, int totalPages) {
        g.setColor(Color.BLACK);
        g.setFont(MinecraftFontLoader.INSTANCE.getFont(18.0f));
        FontMetrics fontMetrics = g.getFontMetrics();
        Intrinsics.checkNotNullExpressionValue(fontMetrics, "getFontMetrics(...)");
        FontMetrics fm = fontMetrics;
        int maxLineWidth = this.pageWidth - this.marginLeft * 2;
        int lineHeight = fm.getHeight();
        String pageNumberText = "Page " + pageIndex + " of " + totalPages;
        int textWidth = fm.stringWidth(pageNumberText);
        g.drawString(pageNumberText, this.pageWidth - textWidth - 30, this.marginTop);
        int y = this.marginTop + lineHeight + 10;
        String[] stringArray = new String[]{"\n"};
        for (Object e : StringsKt.split$default((CharSequence)page, stringArray, false, 0, 6, null)) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            String line = (String)e;
            String currentLine = "";
            String[] stringArray2 = new String[]{" "};
            for (Object e2 : StringsKt.split$default((CharSequence)line, stringArray2, false, 0, 6, null)) {
                Intrinsics.checkNotNullExpressionValue(e2, "next(...)");
                String word = (String)e2;
                List<String> words = fm.stringWidth(word) > maxLineWidth ? StringsKt.chunked(word, 19) : CollectionsKt.listOf(word);
                Iterator<String> iterator2 = words.iterator();
                while (iterator2.hasNext()) {
                    String chunk;
                    String testLine;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                    String string = testLine = ((CharSequence)currentLine).length() == 0 ? chunk : currentLine + " " + chunk;
                    if (fm.stringWidth(testLine) > maxLineWidth) {
                        g.drawString(((Object)StringsKt.trim((CharSequence)currentLine)).toString(), this.marginLeft, y);
                        y += lineHeight - 4;
                        currentLine = chunk;
                        continue;
                    }
                    currentLine = testLine;
                }
            }
            if (((CharSequence)currentLine).length() > 0) {
                g.drawString(((Object)StringsKt.trim((CharSequence)currentLine)).toString(), this.marginLeft, y);
            }
            if (!(((CharSequence)currentLine).length() > 0)) continue;
            g.drawString(((Object)StringsKt.trim((CharSequence)currentLine)).toString(), this.marginLeft, y);
            y += lineHeight;
        }
    }

    private final void renderBackground(Graphics2D g, BufferedImage image) {
        BufferedImage bookBackground = TextureUtilsKt.loadImage("/book.png", this.getClass());
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.drawImage((Image)bookBackground, 0, 0, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String generateBookHash(ItemStack book) {
        void $this$mapTo$iv$iv;
        String string;
        String title;
        ItemMeta itemMeta = book.getItemMeta();
        BookMeta bookMeta = itemMeta instanceof BookMeta ? (BookMeta)itemMeta : null;
        if (bookMeta == null) {
            throw new IllegalArgumentException("Item is not a book");
        }
        BookMeta meta = bookMeta;
        String string2 = meta.getTitle();
        if (string2 == null) {
            string2 = title = "Untitled";
        }
        if ((string = meta.getAuthor()) == null) {
            string = "Unknown";
        }
        String author = string;
        PlainTextComponentSerializer plainTextComponentSerializer = PlainTextComponentSerializer.plainText();
        Intrinsics.checkNotNullExpressionValue(plainTextComponentSerializer, "plainText(...)");
        PlainTextComponentSerializer serializer = plainTextComponentSerializer;
        List list = meta.pages();
        Intrinsics.checkNotNullExpressionValue(list, "pages(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Component component = (Component)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(serializer.serialize((Component)it));
        }
        List pages = (List)destination$iv$iv;
        String bookData = title + ":" + author + ":" + pages;
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String string3 = bookData;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] hashBytes = digest.digest(byArray);
        Intrinsics.checkNotNull(hashBytes);
        return ArraysKt.joinToString$default(hashBytes, (CharSequence)"", null, null, 0, null, BookRenderer::generateBookHash$lambda$2, 30, null);
    }

    private static final CharSequence generateBookHash$lambda$2(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }
}

