/*
 * Decompiled with CFR 0.152.
 */
package eu.pablob.paper_telegram_bridge;

import eu.pablob.paper_telegram_bridge.MinecraftFontLoader;
import eu.pablob.paper_telegram_bridge.TextureUtilsKt;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Leu/pablob/paper_telegram_bridge/EnderChestRenderer;", "", "<init>", "()V", "slotSize", "", "padding", "borderSize", "background", "Ljava/awt/image/BufferedImage;", "renderEnderChestToFile", "", "inventory", "Lorg/bukkit/inventory/Inventory;", "drawItem", "", "g", "Ljava/awt/Graphics2D;", "item", "Lorg/bukkit/inventory/ItemStack;", "x", "y", "paper-telegram-bridge"})
public final class EnderChestRenderer {
    private final int slotSize;
    private final int padding;
    private final int borderSize;
    @Nullable
    private final BufferedImage background = TextureUtilsKt.loadImage("/enderBackground.png", this.getClass());

    public EnderChestRenderer() {
        this.slotSize = 32;
        this.padding = 4;
        this.borderSize = 16;
    }

    @NotNull
    public final byte[] renderEnderChestToFile(@NotNull Inventory inventory) {
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        int columns = 9;
        int rows = 3;
        BufferedImage bufferedImage = this.background;
        Integer n = bufferedImage != null ? Integer.valueOf(bufferedImage.getWidth()) : null;
        Intrinsics.checkNotNull(n);
        BufferedImage image = new BufferedImage(n, this.background.getHeight(), 2);
        Graphics2D g = image.createGraphics();
        BufferedImage it = this.background;
        boolean bl = false;
        g.drawImage((Image)it, 0, 0, null);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                int index = row * columns + col;
                int x = col * (this.slotSize + this.padding) + this.borderSize + 1;
                int y = row * (this.slotSize + this.padding) + this.borderSize;
                ItemStack item = inventory.getItem(index);
                if (item == null || item.getType() == Material.AIR) continue;
                Intrinsics.checkNotNull(g);
                this.drawItem(g, item, x, y);
                Map map2 = item.getEnchantments();
                Intrinsics.checkNotNullExpressionValue(map2, "getEnchantments(...)");
                if (!(!map2.isEmpty())) continue;
                g.setColor(new Color(128, 0, 128, 48));
                g.fillRect(x, y, this.slotSize, this.slotSize);
            }
        }
        g.dispose();
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", outputStream2);
        byte[] imageBytes = outputStream2.toByteArray();
        outputStream2.close();
        Intrinsics.checkNotNull(imageBytes);
        return imageBytes;
    }

    private final void drawItem(Graphics2D g, ItemStack item, int x, int y) {
        String string = item.getType().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String itemName = string;
        if (Intrinsics.areEqual(itemName, "potion")) {
            BufferedImage potionTexture;
            BufferedImage bufferedImage = TextureUtilsKt.loadPotionTexture(item, this.getClass());
            if (bufferedImage == null) {
                bufferedImage = TextureUtilsKt.loadAwkwardPotionTexture(this.getClass());
            }
            if ((potionTexture = bufferedImage) != null) {
                g.drawImage(potionTexture, x + 8, y + 8, this.slotSize - 16, this.slotSize - 16, null);
            }
        } else if (StringsKt.contains$default((CharSequence)itemName, "map", false, 2, null)) {
            g.drawImage(TextureUtilsKt.loadMapTexture(this.getClass()), x + 8, y + 8, this.slotSize - 16, this.slotSize - 16, null);
        } else {
            BufferedImage texture = TextureUtilsKt.loadItemTexture(itemName, this.getClass());
            if (texture != null) {
                g.drawImage(texture, x + 1, y + 1, this.slotSize - 1, this.slotSize - 1, null);
            } else {
                g.setColor(Color.GRAY);
                g.fillRect(x + 8, y + 8, this.slotSize - 16, this.slotSize - 16);
            }
        }
        if (item.getAmount() > 1) {
            g.setColor(Color.WHITE);
            g.setFont(MinecraftFontLoader.INSTANCE.getFont(16.0f));
            String countText = String.valueOf(item.getAmount());
            int textWidth = g.getFontMetrics().stringWidth(countText);
            g.drawString(countText, x + this.slotSize - textWidth + 2, y + this.slotSize + 10);
        }
    }
}

