/*
 * Decompiled with CFR 0.152.
 */
package eu.pablob.paper_telegram_bridge;

import eu.pablob.paper_telegram_bridge.AdvancementRenderer;
import eu.pablob.paper_telegram_bridge.BookRenderer;
import eu.pablob.paper_telegram_bridge.Configuration;
import eu.pablob.paper_telegram_bridge.EnderChestRenderer;
import eu.pablob.paper_telegram_bridge.InventoryRenderer;
import eu.pablob.paper_telegram_bridge.ItemRenderer;
import eu.pablob.paper_telegram_bridge.Plugin;
import eu.pablob.paper_telegram_bridge.TgBot;
import eu.pablob.paper_telegram_bridge.UtilsKt;
import io.papermc.paper.advancement.AdvancementDisplay;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.awt.Color;
import java.io.File;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Job;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0017H\u0007J\u001c\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001eH\u0007J2\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0018\u0010'\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020+2\u0006\u0010 \u001a\u00020!J$\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0-2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Leu/pablob/paper_telegram_bridge/EventHandler;", "Lorg/bukkit/event/Listener;", "plugin", "Leu/pablob/paper_telegram_bridge/Plugin;", "config", "Leu/pablob/paper_telegram_bridge/Configuration;", "tgBot", "Leu/pablob/paper_telegram_bridge/TgBot;", "<init>", "(Leu/pablob/paper_telegram_bridge/Plugin;Leu/pablob/paper_telegram_bridge/Configuration;Leu/pablob/paper_telegram_bridge/TgBot;)V", "onPlayerChat", "", "event", "Lio/papermc/paper/event/player/AsyncChatEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerLeave", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onPlayerDied", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onPlayerAsleep", "Lorg/bukkit/event/player/PlayerBedEnterEvent;", "onPlayerLogin", "Lorg/bukkit/event/player/PlayerLoginEvent;", "sendMessage", "Lkotlinx/coroutines/Job;", "text", "", "username", "onPlayerAdvancementDone", "Lorg/bukkit/event/player/PlayerAdvancementDoneEvent;", "sendAdvancement", "item", "Lorg/bukkit/inventory/ItemStack;", "title", "frameType", "textColor", "Ljava/awt/Color;", "message", "getLogInventory", "player", "Lorg/bukkit/entity/Player;", "getShulkerBoxContents", "Lorg/bukkit/inventory/Inventory;", "userMessageBeforeAfter", "Lkotlin/Pair;", "tag", "paper-telegram-bridge"})
@SourceDebugExtension(value={"SMAP\nEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventHandler.kt\neu/pablob/paper_telegram_bridge/EventHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,230:1\n1#2:231\n12567#3,2:232\n*S KotlinDebug\n*F\n+ 1 EventHandler.kt\neu/pablob/paper_telegram_bridge/EventHandler\n*L\n194#1:232,2\n*E\n"})
public final class EventHandler
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Configuration config;
    @NotNull
    private final TgBot tgBot;

    public EventHandler(@NotNull Plugin plugin, @NotNull Configuration config, @NotNull TgBot tgBot) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter((Object)config, "config");
        Intrinsics.checkNotNullParameter(tgBot, "tgBot");
        this.plugin = plugin;
        this.config = config;
        this.tgBot = tgBot;
    }

    @org.bukkit.event.EventHandler
    public final void onPlayerChat(@NotNull AsyncChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.config.getLogFromMCtoTG() || event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = PlainTextComponentSerializer.plainText().serialize(event.message());
        Intrinsics.checkNotNullExpressionValue(string, "serialize(...)");
        String message = string;
        if (StringsKt.contains$default((CharSequence)message, "[", false, 2, null) && StringsKt.contains$default((CharSequence)message, "]", false, 2, null)) {
            this.getLogInventory(message, player2);
        } else {
            this.sendMessage(message, player2.getName());
        }
    }

    @org.bukkit.event.EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.config.getLogJoinLeave()) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        boolean hasPermission = player2.hasPermission("tg-bridge.silentjoinleave");
        if (hasPermission) {
            return;
        }
        String username = String.valueOf(player2.getPlayerProfile().getName());
        String text = StringsKt.replace$default(this.config.getJoinString(), "%username%", username, false, 4, null);
        EventHandler.sendMessage$default(this, text, null, 2, null);
    }

    @org.bukkit.event.EventHandler
    public final void onPlayerLeave(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.config.getLogJoinLeave()) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        boolean hasPermission = player2.hasPermission("tg-bridge.silentjoinleave");
        if (hasPermission) {
            return;
        }
        String username = UtilsKt.fullEscape(String.valueOf(player2.getPlayerProfile().getName()));
        String text = StringsKt.replace$default(this.config.getLeaveString(), "%username%", username, false, 4, null);
        EventHandler.sendMessage$default(this, text, null, 2, null);
    }

    @org.bukkit.event.EventHandler
    public final void onPlayerDied(@NotNull PlayerDeathEvent event) {
        String deathMessage;
        String string;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.config.getLogDeath()) {
            return;
        }
        boolean hasPermission = event.getEntity().hasPermission("tg-bridge.silentjoinleave");
        if (hasPermission) {
            return;
        }
        Component component = event.deathMessage();
        if (component != null) {
            Component it = component;
            boolean bl = false;
            string = PlainTextComponentSerializer.plainText().serialize(it);
        } else {
            string = null;
        }
        String it = deathMessage = string;
        boolean bl = false;
        String username = UtilsKt.fullEscape(String.valueOf(event.getEntity().getPlayerProfile().getName()));
        String string2 = it;
        Intrinsics.checkNotNull(string2);
        String text = StringsKt.replace$default(string2, username, "<i>" + username + "</i>", false, 4, null);
        EventHandler.sendMessage$default(this, text, null, 2, null);
    }

    @org.bukkit.event.EventHandler
    public final void onPlayerAsleep(@NotNull PlayerBedEnterEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.config.getLogPlayerAsleep()) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        boolean hasPermission = player2.hasPermission("tg-bridge.silentjoinleave");
        if (hasPermission) {
            return;
        }
        if (event.getBedEnterResult() != PlayerBedEnterEvent.BedEnterResult.OK) {
            return;
        }
        String text = "<i>" + player2.getPlayerProfile().getName() + "</i> fell asleep.";
        EventHandler.sendMessage$default(this, text, null, 2, null);
    }

    @org.bukkit.event.EventHandler
    public final void onPlayerLogin(@NotNull PlayerLoginEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.config.getLogWhitelistKick()) {
            return;
        }
        if (event.getResult() == PlayerLoginEvent.Result.KICK_WHITELIST) {
            String string = event.getPlayer().getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String username = UtilsKt.fullEscape(string);
            String string2 = PlainTextComponentSerializer.plainText().serialize(event.kickMessage());
            Intrinsics.checkNotNullExpressionValue(string2, "serialize(...)");
            String kickMessage = string2;
            String text = "\u26a0\ufe0f <i>" + username + "</i> tried to join but was kicked: " + kickMessage;
            this.plugin.getLogger().info("Sending whitelist kick message to Telegram for " + username);
            EventHandler.sendMessage$default(this, text, null, 2, null);
        }
    }

    private final Job sendMessage(String text, String username) {
        return this.plugin.launch((Function1)new Function1<Continuation<? super Unit>, Object>(this, text, username, null){
            int label;
            final /* synthetic */ EventHandler this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ String $username;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                this.$username = $username;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = EventHandler.access$getTgBot$p(this.this$0).sendMessageToTelegram(this.$text, this.$username, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    static /* synthetic */ Job sendMessage$default(EventHandler eventHandler, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return eventHandler.sendMessage(string, string2);
    }

    @org.bukkit.event.EventHandler
    public final void onPlayerAdvancementDone(@NotNull PlayerAdvancementDoneEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.config.getLogPlayerAdvancement()) {
            return;
        }
        AdvancementDisplay advancementDisplay = event.getAdvancement().getDisplay();
        if (advancementDisplay == null) {
            return;
        }
        AdvancementDisplay display = advancementDisplay;
        ItemStack itemStack = display.icon();
        Intrinsics.checkNotNullExpressionValue(itemStack, "icon(...)");
        ItemStack item = itemStack;
        if (!display.doesAnnounceToChat()) {
            return;
        }
        String string = PlainTextComponentSerializer.plainText().serialize(event.getAdvancement().displayName());
        Intrinsics.checkNotNullExpressionValue(string, "serialize(...)");
        String advancementName = StringsKt.replace$default(StringsKt.replace$default(string, "[", "", false, 4, null), "]", "", false, 4, null);
        String username = UtilsKt.fullEscape(String.valueOf(event.getPlayer().getPlayerProfile().getName()));
        String string2 = display.frame().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String frameType = string2;
        String string3 = PlainTextComponentSerializer.plainText().serialize(display.description());
        Intrinsics.checkNotNullExpressionValue(string3, "serialize(...)");
        String description = string3;
        String string4 = frameType;
        String message = StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(Intrinsics.areEqual(string4, "goal") ? this.config.getGoalString() : (Intrinsics.areEqual(string4, "challenge") ? this.config.getChallengeString() : this.config.getAdvancementString()), "%username%", username, false, 4, null), "%advancement%", advancementName, false, 4, null), "%description%", description, false, 4, null);
        Color textColor = Color.decode(display.frame().color().asHexString());
        Intrinsics.checkNotNull(textColor);
        this.sendAdvancement(item, advancementName, frameType, textColor, message);
    }

    private final void sendAdvancement(ItemStack item, String title, String frameType, Color textColor, String message) {
        this.plugin.launch((Function1)new Function1<Continuation<? super Unit>, Object>(title, frameType, item, textColor, this, message, null){
            int label;
            final /* synthetic */ String $title;
            final /* synthetic */ String $frameType;
            final /* synthetic */ ItemStack $item;
            final /* synthetic */ Color $textColor;
            final /* synthetic */ EventHandler this$0;
            final /* synthetic */ String $message;
            {
                this.$title = $title;
                this.$frameType = $frameType;
                this.$item = $item;
                this.$textColor = $textColor;
                this.this$0 = $receiver;
                this.$message = $message;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                void $result;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        byte[] imageBytes = new AdvancementRenderer().renderAdvancement(this.$title, this.$frameType, this.$item, this.$textColor);
                        if (!(!(imageBytes.length == 0))) break;
                        this.label = 1;
                        Object object3 = EventHandler.access$getTgBot$p(this.this$0).sendPhotoToTelegram(imageBytes, this.$message, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                this.label = 2;
                Object object4 = TgBot.sendMessageToTelegram$default(EventHandler.access$getTgBot$p(this.this$0), this.$message, null, this, 2, null);
                if (object4 != object2) return Unit.INSTANCE;
                return object2;
                {
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final void getLogInventory(String message, Player player) {
        if (!this.config.getLogInventory()) {
            return;
        }
        String string = message.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String lowerMessage = string;
        String playerName = player.getPlayerProfile().getName();
        if (StringsKt.contains$default((CharSequence)lowerMessage, "[inv]", false, 2, null)) {
            v1 = this.plugin.launch((Function1)new Function1<Continuation<? super Unit>, Object>(this, message, player, playerName, null){
                int label;
                final /* synthetic */ EventHandler this$0;
                final /* synthetic */ String $message;
                final /* synthetic */ Player $player;
                final /* synthetic */ String $playerName;
                {
                    this.this$0 = $receiver;
                    this.$message = $message;
                    this.$player = $player;
                    this.$playerName = $playerName;
                    super(1, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            Pair pair = EventHandler.access$userMessageBeforeAfter(this.this$0, this.$message, "[inv]");
                            String userMessageBefore = (String)pair.component1();
                            String userMessageAfter = (String)pair.component2();
                            InventoryRenderer inventoryRenderer = new InventoryRenderer();
                            PlayerInventory playerInventory = this.$player.getInventory();
                            Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
                            byte[] image = inventoryRenderer.renderInventoryToFile((Inventory)playerInventory);
                            this.label = 1;
                            Object object3 = EventHandler.access$getTgBot$p(this.this$0).sendPhotoToTelegram(image, EventHandler.getLogInventory$formatCaption$default(this.$playerName, "Inventory", userMessageBefore, userMessageAfter, false, 16, null), this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            });
        } else if (StringsKt.contains$default((CharSequence)lowerMessage, "[ender]", false, 2, null)) {
            v1 = this.plugin.launch((Function1)new Function1<Continuation<? super Unit>, Object>(this, message, player, playerName, null){
                int label;
                final /* synthetic */ EventHandler this$0;
                final /* synthetic */ String $message;
                final /* synthetic */ Player $player;
                final /* synthetic */ String $playerName;
                {
                    this.this$0 = $receiver;
                    this.$message = $message;
                    this.$player = $player;
                    this.$playerName = $playerName;
                    super(1, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            Pair pair = EventHandler.access$userMessageBeforeAfter(this.this$0, this.$message, "[inv]");
                            String userMessageBefore = (String)pair.component1();
                            String userMessageAfter = (String)pair.component2();
                            EnderChestRenderer enderChestRenderer = new EnderChestRenderer();
                            Inventory inventory = this.$player.getEnderChest();
                            Intrinsics.checkNotNullExpressionValue(inventory, "getEnderChest(...)");
                            byte[] image = enderChestRenderer.renderEnderChestToFile(inventory);
                            this.label = 1;
                            Object object3 = EventHandler.access$getTgBot$p(this.this$0).sendPhotoToTelegram(image, EventHandler.getLogInventory$formatCaption$default(this.$playerName, "Ender Chest", userMessageBefore, userMessageAfter, false, 16, null), this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            });
        } else if (StringsKt.contains$default((CharSequence)lowerMessage, "[item]", false, 2, null)) {
            v1 = this.plugin.launch((Function1)new Function1<Continuation<? super Unit>, Object>(player, this, message, playerName, null){
                int label;
                final /* synthetic */ Player $player;
                final /* synthetic */ EventHandler this$0;
                final /* synthetic */ String $message;
                final /* synthetic */ String $playerName;
                {
                    this.$player = $player;
                    this.this$0 = $receiver;
                    this.$message = $message;
                    this.$playerName = $playerName;
                    super(1, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    void $result;
                    ItemStack item;
                    Object object2;
                    block8: {
                        Object object3;
                        object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                ItemStack itemStack = this.$player.getInventory().getItemInMainHand();
                                Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
                                item = itemStack;
                                String string = item.getType().name().toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                                if (!Intrinsics.areEqual(string, "written_book")) {
                                    String string2 = item.getType().name().toLowerCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                                    if (!Intrinsics.areEqual(string2, "writable_book")) break;
                                }
                                Pair<File, String> pair = new BookRenderer(EventHandler.access$getPlugin$p(this.this$0)).renderBookToFile(item);
                                File bookDirectory = pair.component1();
                                String caption = pair.component2();
                                if (bookDirectory == null) return Unit.INSTANCE;
                                this.label = 1;
                                Object object4 = EventHandler.access$getTgBot$p(this.this$0).sendImageWithKeyboard(((Number)EventHandler.access$getConfig$p(this.this$0).getAllowedChats().get(0)).longValue(), 1, bookDirectory, caption, this);
                                if (object4 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                ResultKt.throwOnFailure($result);
                                Object object4 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        String string = item.getType().name().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                        if (Intrinsics.areEqual(string, "shulker_box")) {
                            Inventory shulkerBoxContents = this.this$0.getShulkerBoxContents(item);
                            Pair bookDirectory = EventHandler.access$userMessageBeforeAfter(this.this$0, this.$message, "[item]");
                            String userMessageBefore = (String)bookDirectory.component1();
                            String userMessageAfter = (String)bookDirectory.component2();
                            byte[] image = new EnderChestRenderer().renderEnderChestToFile(shulkerBoxContents);
                            this.label = 2;
                            object3 = EventHandler.access$getTgBot$p(this.this$0).sendPhotoToTelegram(image, EventHandler.access$getLogInventory$formatCaption(this.$playerName, "Shulker Box", userMessageBefore, userMessageAfter, false), this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        break block8;
                        {
                            case 2: {
                                ResultKt.throwOnFailure($result);
                                object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                    }
                    Pair<byte[], String> pair = new ItemRenderer().renderItemToFile(item);
                    byte[] image = pair.component1();
                    String itemName = pair.component2();
                    String formattedName = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default(itemName, '(', null, 2, null))).toString();
                    String amountSuffix = item.getAmount() > 1 ? " x " + item.getAmount() : "";
                    Pair pair2 = EventHandler.access$userMessageBeforeAfter(this.this$0, this.$message, "[item]");
                    String userMessageBefore = (String)pair2.component1();
                    String userMessageAfter = (String)pair2.component2();
                    this.label = 3;
                    Object object5 = EventHandler.access$getTgBot$p(this.this$0).sendPhotoToTelegram(image, this.$playerName + ": " + userMessageBefore + "[" + formattedName + amountSuffix + "]" + userMessageAfter, this);
                    if (object5 != object2) return Unit.INSTANCE;
                    return object2;
                    {
                        case 3: {
                            ResultKt.throwOnFailure($result);
                            object5 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            });
        } else {
            boolean bl;
            block9: {
                String[] otherCommands;
                String[] stringArray = new String[]{"[ping]", "[pos]", "[gametime]", "[time]", "[vault]"};
                String[] $this$any$iv = otherCommands = stringArray;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)lowerMessage, it, false, 2, null)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
            if (!bl) {
                this.sendMessage(message, playerName);
            }
            v1 = Unit.INSTANCE;
        }
    }

    @NotNull
    public final Inventory getShulkerBoxContents(@NotNull ItemStack item) {
        ShulkerBox shulkerBox;
        BlockStateMeta meta;
        Intrinsics.checkNotNullParameter(item, "item");
        ItemMeta itemMeta = item.getItemMeta();
        BlockStateMeta blockStateMeta = meta = itemMeta instanceof BlockStateMeta ? (BlockStateMeta)itemMeta : null;
        Intrinsics.checkNotNull(blockStateMeta);
        BlockState blockState = blockStateMeta.getBlockState();
        ShulkerBox shulkerBox2 = shulkerBox = blockState instanceof ShulkerBox ? (ShulkerBox)blockState : null;
        Intrinsics.checkNotNull(shulkerBox2);
        Inventory inventory = shulkerBox2.getInventory();
        Intrinsics.checkNotNullExpressionValue(inventory, "getInventory(...)");
        return inventory;
    }

    private final Pair<String, String> userMessageBeforeAfter(String message, String tag) {
        String userMessageBefore = StringsKt.substringBefore$default(message, tag, null, 2, null);
        String userMessageAfter = StringsKt.substringAfter$default(message, tag, null, 2, null);
        if (StringsKt.contains$default((CharSequence)message, "<", false, 2, null) && StringsKt.contains$default((CharSequence)message, ">", false, 2, null)) {
            String newTag = StringsKt.substringBefore$default(StringsKt.substringAfter$default(message, "<", null, 2, null), ">", null, 2, null);
            userMessageBefore = StringsKt.substringBefore$default(message, "<" + newTag + ">", null, 2, null);
            userMessageAfter = StringsKt.substringAfter$default(message, "<" + newTag + ">", null, 2, null);
        }
        return new Pair<String, String>(userMessageBefore, userMessageAfter);
    }

    private static final String getLogInventory$formatCaption(String playerName, String label, String msgBefore, String msgAfter, boolean showPlayerName) {
        Object playerNameLabel = showPlayerName ? playerName + "\u2019s " : "";
        return playerName + ": " + msgBefore + "[" + (String)playerNameLabel + label + "]" + msgAfter;
    }

    static /* synthetic */ String getLogInventory$formatCaption$default(String string, String string2, String string3, String string4, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return EventHandler.getLogInventory$formatCaption(string, string2, string3, string4, bl);
    }

    public static final /* synthetic */ TgBot access$getTgBot$p(EventHandler $this) {
        return $this.tgBot;
    }

    public static final /* synthetic */ Pair access$userMessageBeforeAfter(EventHandler $this, String message, String tag) {
        return $this.userMessageBeforeAfter(message, tag);
    }

    public static final /* synthetic */ Plugin access$getPlugin$p(EventHandler $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ Configuration access$getConfig$p(EventHandler $this) {
        return $this.config;
    }

    public static final /* synthetic */ String access$getLogInventory$formatCaption(String playerName, String label, String msgBefore, String msgAfter, boolean showPlayerName) {
        return EventHandler.getLogInventory$formatCaption(playerName, label, msgBefore, msgAfter, showPlayerName);
    }
}

