/*
 * Decompiled with CFR 0.152.
 */
package eu.pablob.paper_telegram_bridge;

import eu.pablob.paper_telegram_bridge.MinecraftFontLoader;
import eu.pablob.paper_telegram_bridge.TextureUtilsKt;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Leu/pablob/paper_telegram_bridge/InventoryRenderer;", "", "<init>", "()V", "slotSize", "", "padding", "borderSize", "bottomPadding", "background", "Ljava/awt/image/BufferedImage;", "logger", "Ljava/util/logging/Logger;", "renderInventoryToFile", "", "inventory", "Lorg/bukkit/inventory/Inventory;", "drawItem", "", "g", "Ljava/awt/Graphics2D;", "item", "Lorg/bukkit/inventory/ItemStack;", "x", "y", "paper-telegram-bridge"})
@SourceDebugExtension(value={"SMAP\nInventoryRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InventoryRenderer.kt\neu/pablob/paper_telegram_bridge/InventoryRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class InventoryRenderer {
    private final int slotSize;
    private final int padding;
    private final int borderSize;
    private final int bottomPadding;
    @Nullable
    private final BufferedImage background = TextureUtilsKt.loadImage("/inventoryBackground.png", this.getClass());
    @NotNull
    private final Logger logger;

    public InventoryRenderer() {
        this.slotSize = 32;
        this.padding = 4;
        this.borderSize = 16;
        this.bottomPadding = 8;
        Logger logger = Logger.getLogger("InventoryRenderer");
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public final byte[] renderInventoryToFile(@NotNull Inventory inventory) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        int columns = 9;
        int rows = 5;
        BufferedImage bufferedImage = this.background;
        Integer n = bufferedImage != null ? Integer.valueOf(bufferedImage.getWidth()) : null;
        Intrinsics.checkNotNull(n);
        BufferedImage image = new BufferedImage(n, this.background.getHeight(), 2);
        Graphics2D g = image.createGraphics();
        BufferedImage it = this.background;
        boolean bl = false;
        g.drawImage((Image)it, 0, 0, null);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                if (row == 0 && col >= 5) continue;
                int index = switch (row) {
                    case 0 -> 36 + col;
                    case 1 -> 9 + col;
                    case 2 -> 18 + col;
                    case 3 -> 27 + col;
                    case 4 -> col;
                    default -> col;
                };
                int y = row * (this.slotSize + this.padding) + this.borderSize;
                if (row == 4) {
                    y += this.bottomPadding;
                }
                int x = col * (this.slotSize + this.padding) + this.borderSize + 2;
                ItemStack item = inventory.getItem(index);
                if (item == null || item.getType() == Material.AIR) continue;
                Intrinsics.checkNotNull(g);
                this.drawItem(g, item, x, y);
                Map map2 = item.getEnchantments();
                Intrinsics.checkNotNullExpressionValue(map2, "getEnchantments(...)");
                if (!(!map2.isEmpty())) continue;
                g.setColor(new Color(128, 0, 128, 48));
                g.fillRect(x, y, this.slotSize, this.slotSize);
            }
        }
        g.dispose();
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", outputStream2);
        byte[] it2 = byArray = outputStream2.toByteArray();
        boolean bl2 = false;
        outputStream2.close();
        Intrinsics.checkNotNullExpressionValue(byArray, "also(...)");
        return byArray;
    }

    private final void drawItem(Graphics2D g, ItemStack item, int x, int y) {
        BufferedImage texture;
        BufferedImage bufferedImage;
        String string = item.getType().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String itemName = string;
        if (Intrinsics.areEqual(itemName, "potion")) {
            bufferedImage = TextureUtilsKt.loadPotionTexture(item, this.getClass());
            if (bufferedImage == null) {
                bufferedImage = TextureUtilsKt.loadAwkwardPotionTexture(this.getClass());
            }
        } else {
            bufferedImage = StringsKt.contains$default((CharSequence)itemName, "map", false, 2, null) ? TextureUtilsKt.loadMapTexture(this.getClass()) : TextureUtilsKt.loadItemTexture(itemName, this.getClass());
        }
        if ((texture = bufferedImage) == null) {
            this.logger.warning("Missing texture for item: " + item.getType());
        }
        BufferedImage bufferedImage2 = texture;
        if (bufferedImage2 != null) {
            BufferedImage it = bufferedImage2;
            boolean bl = false;
            g.drawImage(it, x, y, this.slotSize, this.slotSize, null);
        }
        if (item.getAmount() > 1) {
            g.setColor(Color.WHITE);
            g.setFont(MinecraftFontLoader.INSTANCE.getFont(16.0f));
            String countText = String.valueOf(item.getAmount());
            int textWidth = g.getFontMetrics().stringWidth(countText);
            g.drawString(countText, x + this.slotSize - textWidth + 2, y + this.slotSize + 10);
        }
    }
}

