/*
 * Decompiled with CFR 0.152.
 */
package eu.pablob.paper_telegram_bridge;

import eu.pablob.paper_telegram_bridge.MinecraftFontLoader;
import eu.pablob.paper_telegram_bridge.TextureUtilsKt;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u001a\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u001c\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010 \u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0005H\u0002J \u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Leu/pablob/paper_telegram_bridge/ItemRenderer;", "", "<init>", "()V", "width", "", "imageScale", "margin", "backgroundColor", "", "borderColor", "enchantmentColor", "renderItemToFile", "Lkotlin/Pair;", "", "item", "Lorg/bukkit/inventory/ItemStack;", "loadTexture", "Ljava/awt/image/BufferedImage;", "calculateDynamicHeight", "drawBackground", "", "g", "Ljava/awt/Graphics2D;", "height", "drawTexture", "texture", "drawItemName", "getItemName", "displayName", "determineNameColor", "Ljava/awt/Color;", "drawEnchantments", "textYOffset", "drawDurability", "drawStackSize", "paper-telegram-bridge"})
@SourceDebugExtension(value={"SMAP\nItemRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemRenderer.kt\neu/pablob/paper_telegram_bridge/ItemRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,175:1\n1#2:176\n216#3,2:177\n*S KotlinDebug\n*F\n+ 1 ItemRenderer.kt\neu/pablob/paper_telegram_bridge/ItemRenderer\n*L\n140#1:177,2\n*E\n"})
public final class ItemRenderer {
    private final int width;
    private final int imageScale;
    private final int margin;
    @NotNull
    private final String backgroundColor;
    @NotNull
    private final String borderColor;
    @NotNull
    private final String enchantmentColor;

    public ItemRenderer() {
        this.width = 250;
        this.imageScale = 48;
        this.margin = 12;
        this.backgroundColor = "#210939";
        this.borderColor = "#1A0B1A";
        this.enchantmentColor = "#A7A7A7";
    }

    @NotNull
    public final Pair<byte[], String> renderItemToFile(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(item, "item");
        BufferedImage texture = this.loadTexture(item);
        int height = this.calculateDynamicHeight(item);
        BufferedImage image = new BufferedImage(this.width, height, 2);
        Graphics2D g = image.createGraphics();
        Intrinsics.checkNotNull(g);
        this.drawBackground(g, height);
        this.drawTexture(g, texture);
        String itemName = this.drawItemName(g, item);
        int textYOffset = this.imageScale + this.margin + 50;
        textYOffset = this.drawEnchantments(g, item, textYOffset);
        this.drawDurability(g, item, textYOffset);
        this.drawStackSize(g, item);
        g.dispose();
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", outputStream2);
        byte[] imageBytes = outputStream2.toByteArray();
        outputStream2.close();
        return new Pair<byte[], String>(imageBytes, itemName);
    }

    /*
     * Unable to fully structure code
     */
    private final BufferedImage loadTexture(ItemStack item) {
        block9: {
            v0 = item.getType().name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(v0, "toLowerCase(...)");
            itemName = v0;
            switch (itemName.hashCode()) {
                case -982431341: {
                    if (!itemName.equals("potion")) {
                        ** break;
                    }
                    ** GOTO lbl18
                }
                case -75759361: {
                    if (itemName.equals("filled_map")) break;
                    ** break;
                }
                case 402451051: {
                    if (!itemName.equals("splash_potion")) {
                        ** break;
                    }
                    ** GOTO lbl18
                }
                case 2038150131: {
                    if (!itemName.equals("lingering_potion")) ** break;
lbl18:
                    // 3 sources

                    if ((v1 = TextureUtilsKt.loadPotionTexture(item, this.getClass())) == null) {
                        v1 = TextureUtilsKt.loadAwkwardPotionTexture(this.getClass());
                    }
                    break block9;
                }
            }
            v1 = TextureUtilsKt.loadMapTexture(this.getClass());
            break block9;
lbl23:
            // 5 sources

            v1 = TextureUtilsKt.loadItemTexture(itemName, this.getClass());
        }
        return v1;
    }

    private final int calculateDynamicHeight(ItemStack item) {
        Map map2;
        int height = this.imageScale + this.margin * 2 + 30;
        if (item.getItemMeta() instanceof EnchantmentStorageMeta) {
            ItemMeta itemMeta = item.getItemMeta();
            Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.EnchantmentStorageMeta");
            map2 = ((EnchantmentStorageMeta)itemMeta).getStoredEnchants();
        } else {
            map2 = item.getEnchantments();
        }
        Map map3 = map2;
        Intrinsics.checkNotNull(map3);
        Map enchantments = map3;
        if (!enchantments.isEmpty()) {
            height += 20 * enchantments.size();
        }
        if (item.getItemMeta() instanceof Damageable && item.getType().getMaxDurability() > 0) {
            height += 20;
        }
        return height + this.margin;
    }

    private final void drawBackground(Graphics2D g, int height) {
        g.setColor(Color.decode(this.backgroundColor));
        g.fillRect(0, 0, this.width, height);
        g.setColor(Color.decode(this.borderColor));
        g.fillRect(4, 4, this.width - 8, height - 8);
    }

    private final void drawTexture(Graphics2D g, BufferedImage texture) {
        if (texture == null) {
            g.setColor(Color.GRAY);
            g.fillRect(this.margin, this.margin, this.imageScale, this.imageScale);
        } else {
            g.drawImage(texture, this.margin, this.margin, this.imageScale, this.imageScale, null);
        }
    }

    private final String drawItemName(Graphics2D g, ItemStack item) {
        String string = PlainTextComponentSerializer.plainText().serialize(item.displayName());
        Intrinsics.checkNotNullExpressionValue(string, "serialize(...)");
        String displayName = StringsKt.replace$default(StringsKt.replace$default(string, "[", "", false, 4, null), "]", "", false, 4, null);
        String fullName = this.getItemName(item, displayName);
        Color nameColor = this.determineNameColor(item);
        g.setFont(MinecraftFontLoader.INSTANCE.getFont(16.0f));
        g.setColor(nameColor);
        g.drawString(fullName, this.margin, this.imageScale + this.margin + 30);
        return fullName;
    }

    /*
     * WARNING - void declaration
     */
    private final String getItemName(ItemStack item, String displayName) {
        String string;
        String string2 = StringsKt.replace$default(item.getType().name(), '_', ' ', false, 4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        CharSequence charSequence = string2;
        if (((CharSequence)charSequence).length() > 0) {
            void it;
            char c = ((String)charSequence).charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string3 = String.valueOf((char)it);
            Intrinsics.checkNotNull(string3, "null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            CharSequence charSequence2 = charSequence;
            int n = 1;
            String string5 = ((String)charSequence2).substring(n);
            Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = charSequence;
        }
        String itemTypeName = string;
        charSequence = displayName;
        return !(charSequence == null || charSequence.length() == 0) ? String.valueOf(displayName) : itemTypeName;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Color determineNameColor(ItemStack item) {
        Color color;
        block5: {
            block4: {
                ItemMeta itemMeta = item.getItemMeta();
                if (itemMeta != null ? itemMeta.hasEnchants() : false) break block4;
                if (!(item.getItemMeta() instanceof EnchantmentStorageMeta)) break block5;
                ItemMeta itemMeta2 = item.getItemMeta();
                Intrinsics.checkNotNull(itemMeta2, "null cannot be cast to non-null type org.bukkit.inventory.meta.EnchantmentStorageMeta");
                Map map2 = ((EnchantmentStorageMeta)itemMeta2).getStoredEnchants();
                Intrinsics.checkNotNullExpressionValue(map2, "getStoredEnchants(...)");
                if (!(!map2.isEmpty())) break block5;
            }
            Color color2 = Color.CYAN;
            color = color2;
            Intrinsics.checkNotNullExpressionValue(color2, "CYAN");
            return color;
        }
        if (!StringsKt.contains((CharSequence)item.getType().name(), "totem", true) && !StringsKt.contains((CharSequence)item.getType().name(), "book", true)) {
            Color color3 = Color.WHITE;
            color = color3;
            Intrinsics.checkNotNullExpressionValue(color3, "WHITE");
            return color;
        }
        Color color4 = Color.YELLOW;
        color = color4;
        Intrinsics.checkNotNullExpressionValue(color4, "YELLOW");
        return color;
    }

    /*
     * WARNING - void declaration
     */
    private final int drawEnchantments(Graphics2D g, ItemStack item, int textYOffset) {
        Map map2;
        if (item.getItemMeta() instanceof EnchantmentStorageMeta) {
            ItemMeta itemMeta = item.getItemMeta();
            Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.EnchantmentStorageMeta");
            map2 = ((EnchantmentStorageMeta)itemMeta).getStoredEnchants();
        } else {
            map2 = item.getEnchantments();
        }
        Map map3 = map2;
        Intrinsics.checkNotNull(map3);
        Map enchantments = map3;
        if (!enchantments.isEmpty()) {
            g.setFont(MinecraftFontLoader.INSTANCE.getFont(14.0f));
            g.setColor(Color.decode(this.enchantmentColor));
            int currentYOffset = 0;
            currentYOffset = textYOffset;
            Map $this$forEach$iv = enchantments;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                String string;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer level = (Integer)entry.getValue();
                Graphics2D graphics2D = g;
                String string2 = enchantment.getKey().getKey();
                Intrinsics.checkNotNullExpressionValue(string2, "getKey(...)");
                String string3 = StringsKt.replace$default(string2, '_', ' ', false, 4, null);
                if (((CharSequence)string3).length() > 0) {
                    String string4;
                    void it;
                    char c = string3.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    Graphics2D graphics2D2 = graphics2D;
                    boolean bl2 = false;
                    if (Character.isLowerCase((char)it)) {
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                        string4 = CharsKt.titlecase((char)it, locale);
                    } else {
                        string4 = String.valueOf((char)it);
                    }
                    CharSequence charSequence = string4;
                    graphics2D = graphics2D2;
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
                    String string5 = string3;
                    int n = 1;
                    String string6 = string5.substring(n);
                    Intrinsics.checkNotNullExpressionValue(string6, "substring(...)");
                    string = stringBuilder2.append(string6).toString();
                } else {
                    string = string3;
                }
                graphics2D.drawString(string + " " + level, this.margin, currentYOffset);
                currentYOffset += 20;
            }
            return currentYOffset;
        }
        return textYOffset;
    }

    private final void drawDurability(Graphics2D g, ItemStack item, int textYOffset) {
        if (item.getItemMeta() instanceof Damageable && item.getType().getMaxDurability() > 0) {
            g.setFont(MinecraftFontLoader.INSTANCE.getFont(14.0f));
            g.setColor(Color.WHITE);
            short s = item.getType().getMaxDurability();
            ItemMeta itemMeta = item.getItemMeta();
            Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.Damageable");
            int currentDurability = s - ((Damageable)itemMeta).getDamage();
            g.drawString("Durability: " + currentDurability + "/" + item.getType().getMaxDurability(), this.margin, textYOffset);
        }
    }

    private final void drawStackSize(Graphics2D g, ItemStack item) {
        if (item.getAmount() > 1) {
            g.setFont(MinecraftFontLoader.INSTANCE.getFont(20.0f));
            g.setColor(Color.WHITE);
            String stackSize = "x " + item.getAmount();
            int x = this.margin + this.imageScale + 10;
            int y = this.margin + this.imageScale - 5;
            g.drawString(stackSize, x, y);
        }
    }
}

