/*
 * Decompiled with CFR 0.152.
 */
package eu.pablob.paper_telegram_bridge;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Leu/pablob/paper_telegram_bridge/MinecraftFontLoader;", "", "<init>", "()V", "minecraftFont", "Ljava/awt/Font;", "loadMinecraftFont", "", "getFont", "size", "", "paper-telegram-bridge"})
public final class MinecraftFontLoader {
    @NotNull
    public static final MinecraftFontLoader INSTANCE = new MinecraftFontLoader();
    @Nullable
    private static Font minecraftFont;

    private MinecraftFontLoader() {
    }

    private final void loadMinecraftFont() {
        try {
            InputStream fontStream = this.getClass().getResourceAsStream("/Minecraftia-Regular.ttf");
            if (fontStream != null) {
                Font font = Font.createFont(0, fontStream);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                minecraftFont = font;
            } else {
                System.out.println((Object)"Minecraft font file not found. Falling back to default font.");
            }
        }
        catch (Exception e) {
            System.out.println((Object)("Failed to load Minecraft font: " + e.getMessage() + ". Falling back to default font."));
        }
    }

    @NotNull
    public final Font getFont(float size) {
        Font font = minecraftFont;
        if (font == null || (font = font.deriveFont(size)) == null) {
            font = new Font("SansSerif", 1, (int)size);
        }
        return font;
    }

    static {
        INSTANCE.loadMinecraftFont();
    }
}

