/*
 * Decompiled with CFR 0.152.
 */
package eu.pablob.paper_telegram_bridge;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Locale;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u001a \u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u001a \u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a8\u0006\u000e"}, d2={"loadItemTexture", "Ljava/awt/image/BufferedImage;", "itemName", "", "javaClass", "Ljava/lang/Class;", "", "loadAwkwardPotionTexture", "loadPotionTexture", "item", "Lorg/bukkit/inventory/ItemStack;", "loadMapTexture", "loadImage", "path", "paper-telegram-bridge"})
public final class TextureUtilsKt {
    @Nullable
    public static final BufferedImage loadItemTexture(@NotNull String itemName, @NotNull Class<? extends Object> javaClass) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter(itemName, "itemName");
        Intrinsics.checkNotNullParameter(javaClass, "javaClass");
        String texturePath = "/textures/minecraft__" + itemName + ".png";
        InputStream inputStream2 = javaClass.getResourceAsStream(texturePath);
        try {
            BufferedImage bufferedImage2;
            InputStream inputStream3 = inputStream2;
            if (inputStream3 != null) {
                InputStream it = inputStream3;
                boolean bl = false;
                bufferedImage2 = ImageIO.read(it);
            } else {
                bufferedImage2 = null;
            }
            bufferedImage = bufferedImage2;
        }
        catch (Exception e) {
            bufferedImage = null;
        }
        return bufferedImage;
    }

    @Nullable
    public static final BufferedImage loadAwkwardPotionTexture(@NotNull Class<? extends Object> javaClass) {
        Intrinsics.checkNotNullParameter(javaClass, "javaClass");
        String awkwardPotionPath = "potion__awkward";
        return TextureUtilsKt.loadItemTexture(awkwardPotionPath, javaClass);
    }

    @Nullable
    public static final BufferedImage loadPotionTexture(@NotNull ItemStack item, @NotNull Class<? extends Object> javaClass) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(javaClass, "javaClass");
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof PotionMeta) {
            String string;
            Object object = ((PotionMeta)meta).getBasePotionType();
            if (object != null && (object = object.name()) != null) {
                String string2 = ((String)object).toLowerCase(Locale.ROOT);
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            } else {
                string = null;
            }
            String potionType = string;
            String potionTexturePath = "potion__" + potionType;
            return TextureUtilsKt.loadItemTexture(potionTexturePath, javaClass);
        }
        return null;
    }

    @Nullable
    public static final BufferedImage loadMapTexture(@NotNull Class<? extends Object> javaClass) {
        Intrinsics.checkNotNullParameter(javaClass, "javaClass");
        return TextureUtilsKt.loadItemTexture("map", javaClass);
    }

    @Nullable
    public static final BufferedImage loadImage(@NotNull String path, @NotNull Class<? extends Object> javaClass) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(javaClass, "javaClass");
        InputStream inputStream2 = javaClass.getResourceAsStream(path);
        try {
            BufferedImage bufferedImage2;
            InputStream inputStream3 = inputStream2;
            if (inputStream3 != null) {
                InputStream it = inputStream3;
                boolean bl = false;
                bufferedImage2 = ImageIO.read(it);
            } else {
                bufferedImage2 = null;
            }
            bufferedImage = bufferedImage2;
        }
        catch (Exception e) {
            bufferedImage = null;
        }
        return bufferedImage;
    }
}

