/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 \u008e\u00012\u00020\u0001:\b\u008d\u0001\u008e\u0001\u008f\u0001\u0090\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010H\u001a\u00020IJ\b\u0010J\u001a\u00020IH\u0016J'\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020L2\b\u0010N\u001a\u0004\u0018\u00010OH\u0000\u00a2\u0006\u0002\bPJ\u0012\u0010Q\u001a\u00020I2\b\u0010R\u001a\u0004\u0018\u00010OH\u0002J\u0006\u0010S\u001a\u00020IJ\u0010\u0010T\u001a\u0004\u0018\u00010;2\u0006\u0010U\u001a\u00020\u0010J\u0006\u0010V\u001a\u00020\u0010J&\u0010W\u001a\u00020;2\u0006\u0010X\u001a\u00020\u00102\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0Z2\u0006\u0010\\\u001a\u00020\u0006H\u0002J\u001c\u0010W\u001a\u00020;2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0Z2\u0006\u0010\\\u001a\u00020\u0006J\u0006\u0010]\u001a\u00020\u0010J-\u0010^\u001a\u00020I2\u0006\u0010_\u001a\u00020\u00102\u0006\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020\u00102\u0006\u0010c\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\bdJ+\u0010e\u001a\u00020I2\u0006\u0010_\u001a\u00020\u00102\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0Z2\u0006\u0010c\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\bfJ#\u0010g\u001a\u00020I2\u0006\u0010_\u001a\u00020\u00102\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0ZH\u0000\u00a2\u0006\u0002\bhJ\u001d\u0010i\u001a\u00020I2\u0006\u0010_\u001a\u00020\u00102\u0006\u0010j\u001a\u00020LH\u0000\u00a2\u0006\u0002\bkJ$\u0010l\u001a\u00020;2\u0006\u0010X\u001a\u00020\u00102\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0Z2\u0006\u0010\\\u001a\u00020\u0006J\u0015\u0010m\u001a\u00020\u00062\u0006\u0010_\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\bnJ\u0017\u0010o\u001a\u0004\u0018\u00010;2\u0006\u0010_\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\bpJ\u000e\u0010q\u001a\u00020I2\u0006\u0010r\u001a\u00020\"J\u000e\u0010s\u001a\u00020I2\u0006\u0010t\u001a\u00020LJ\u0012\u0010u\u001a\u00020I2\b\b\u0002\u0010v\u001a\u00020\u0006H\u0007J\u0015\u0010w\u001a\u00020I2\u0006\u0010x\u001a\u00020+H\u0000\u00a2\u0006\u0002\byJ(\u0010z\u001a\u00020I2\u0006\u0010_\u001a\u00020\u00102\u0006\u0010{\u001a\u00020\u00062\b\u0010|\u001a\u0004\u0018\u00010}2\u0006\u0010b\u001a\u00020+J,\u0010~\u001a\u00020I2\u0006\u0010_\u001a\u00020\u00102\u0006\u0010{\u001a\u00020\u00062\f\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020[0ZH\u0000\u00a2\u0006\u0003\b\u0080\u0001J\"\u0010\u0081\u0001\u001a\u00020I2\u0007\u0010\u0082\u0001\u001a\u00020\u00062\u0007\u0010\u0083\u0001\u001a\u00020\u00102\u0007\u0010\u0084\u0001\u001a\u00020\u0010J\u0007\u0010\u0085\u0001\u001a\u00020IJ\u001f\u0010\u0086\u0001\u001a\u00020I2\u0006\u0010_\u001a\u00020\u00102\u0006\u0010t\u001a\u00020LH\u0000\u00a2\u0006\u0003\b\u0087\u0001J\u001f\u0010\u0088\u0001\u001a\u00020I2\u0006\u0010_\u001a\u00020\u00102\u0006\u0010j\u001a\u00020LH\u0000\u00a2\u0006\u0003\b\u0089\u0001J \u0010\u008a\u0001\u001a\u00020I2\u0006\u0010_\u001a\u00020\u00102\u0007\u0010\u008b\u0001\u001a\u00020+H\u0000\u00a2\u0006\u0003\b\u008c\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00068F@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\t\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0017\"\u0004\b \u0010\u0019R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010,\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020+@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001e\u0010/\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020+@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.R\u0015\u00101\u001a\u000602R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u000206X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R \u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020;0:X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u001e\u0010>\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020+@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010.R\u001e\u0010@\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020+@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010.R\u0011\u0010B\u001a\u00020C\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0091\u0001"}, d2={"Lokhttp3/internal/http2/Http2Connection;", "Ljava/io/Closeable;", "builder", "Lokhttp3/internal/http2/Http2Connection$Builder;", "(Lokhttp3/internal/http2/Http2Connection$Builder;)V", "awaitingPong", "", "client", "getClient$okhttp", "()Z", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "currentPushRequests", "", "", "<set-?>", "isShutdown", "setShutdown$okhttp", "(Z)V", "lastGoodStreamId", "getLastGoodStreamId$okhttp", "()I", "setLastGoodStreamId$okhttp", "(I)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "nextStreamId", "getNextStreamId$okhttp", "setNextStreamId$okhttp", "okHttpSettings", "Lokhttp3/internal/http2/Settings;", "getOkHttpSettings", "()Lokhttp3/internal/http2/Settings;", "peerSettings", "getPeerSettings", "pushExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "", "readBytesAcknowledged", "getReadBytesAcknowledged", "()J", "readBytesTotal", "getReadBytesTotal", "readerRunnable", "Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "getReaderRunnable", "()Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "streams", "", "Lokhttp3/internal/http2/Http2Stream;", "getStreams$okhttp", "()Ljava/util/Map;", "writeBytesMaximum", "getWriteBytesMaximum", "writeBytesTotal", "getWriteBytesTotal", "writer", "Lokhttp3/internal/http2/Http2Writer;", "getWriter", "()Lokhttp3/internal/http2/Http2Writer;", "writerExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "awaitPong", "", "close", "connectionCode", "Lokhttp3/internal/http2/ErrorCode;", "streamCode", "cause", "Ljava/io/IOException;", "close$okhttp", "failConnection", "e", "flush", "getStream", "id", "maxConcurrentStreams", "newStream", "associatedStreamId", "requestHeaders", "", "Lokhttp3/internal/http2/Header;", "out", "openStreamCount", "pushDataLater", "streamId", "source", "Lokio/BufferedSource;", "byteCount", "inFinished", "pushDataLater$okhttp", "pushHeadersLater", "pushHeadersLater$okhttp", "pushRequestLater", "pushRequestLater$okhttp", "pushResetLater", "errorCode", "pushResetLater$okhttp", "pushStream", "pushedStream", "pushedStream$okhttp", "removeStream", "removeStream$okhttp", "setSettings", "settings", "shutdown", "statusCode", "start", "sendConnectionPreface", "updateConnectionFlowControl", "read", "updateConnectionFlowControl$okhttp", "writeData", "outFinished", "buffer", "Lokio/Buffer;", "writeHeaders", "alternating", "writeHeaders$okhttp", "writePing", "reply", "payload1", "payload2", "writePingAndAwaitPong", "writeSynReset", "writeSynReset$okhttp", "writeSynResetLater", "writeSynResetLater$okhttp", "writeWindowUpdateLater", "unacknowledgedBytesRead", "writeWindowUpdateLater$okhttp", "Builder", "Companion", "Listener", "ReaderRunnable", "okhttp"})
public final class Http2Connection
implements Closeable {
    private final boolean client;
    @NotNull
    private final Listener listener;
    @NotNull
    private final Map<Integer, Http2Stream> streams;
    @NotNull
    private final String connectionName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean isShutdown;
    private final ScheduledThreadPoolExecutor writerExecutor;
    private final ThreadPoolExecutor pushExecutor;
    private final PushObserver pushObserver;
    private boolean awaitingPong;
    @NotNull
    private final Settings okHttpSettings;
    @NotNull
    private final Settings peerSettings;
    private long readBytesTotal;
    private long readBytesAcknowledged;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    @NotNull
    private final Socket socket;
    @NotNull
    private final Http2Writer writer;
    @NotNull
    private final ReaderRunnable readerRunnable;
    private final Set<Integer> currentPushRequests;
    public static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    private static final ThreadPoolExecutor listenerExecutor;
    public static final Companion Companion;

    public final boolean getClient$okhttp() {
        return this.client;
    }

    @NotNull
    public final Listener getListener$okhttp() {
        return this.listener;
    }

    @NotNull
    public final Map<Integer, Http2Stream> getStreams$okhttp() {
        return this.streams;
    }

    @NotNull
    public final String getConnectionName$okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$okhttp() {
        return this.lastGoodStreamId;
    }

    public final void setLastGoodStreamId$okhttp(int n) {
        this.lastGoodStreamId = n;
    }

    public final int getNextStreamId$okhttp() {
        return this.nextStreamId;
    }

    public final void setNextStreamId$okhttp(int n) {
        this.nextStreamId = n;
    }

    public final synchronized boolean isShutdown() {
        return this.isShutdown;
    }

    public final void setShutdown$okhttp(boolean bl) {
        this.isShutdown = bl;
    }

    @NotNull
    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    @NotNull
    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    public final long getReadBytesTotal() {
        return this.readBytesTotal;
    }

    public final long getReadBytesAcknowledged() {
        return this.readBytesAcknowledged;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    @NotNull
    public final Socket getSocket$okhttp() {
        return this.socket;
    }

    @NotNull
    public final Http2Writer getWriter() {
        return this.writer;
    }

    @NotNull
    public final ReaderRunnable getReaderRunnable() {
        return this.readerRunnable;
    }

    public final synchronized int openStreamCount() {
        return this.streams.size();
    }

    @Nullable
    public final synchronized Http2Stream getStream(int id) {
        return this.streams.get(id);
    }

    @Nullable
    public final synchronized Http2Stream removeStream$okhttp(int streamId) {
        Http2Stream stream = this.streams.remove(streamId);
        Http2Connection $this$notifyAll$iv = this;
        boolean $i$f$notifyAll = false;
        Http2Connection http2Connection = $this$notifyAll$iv;
        if (http2Connection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
        }
        ((Object)http2Connection).notifyAll();
        return stream;
    }

    public final synchronized int maxConcurrentStreams() {
        return this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
    }

    public final synchronized void updateConnectionFlowControl$okhttp(long read) {
        this.readBytesTotal += read;
        long readBytesToAcknowledge = this.readBytesTotal - this.readBytesAcknowledged;
        if (readBytesToAcknowledge >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            this.writeWindowUpdateLater$okhttp(0, readBytesToAcknowledge);
            this.readBytesAcknowledged += readBytesToAcknowledge;
        }
    }

    @NotNull
    public final Http2Stream pushStream(int associatedStreamId, @NotNull List<Header> requestHeaders, boolean out) throws IOException {
        Intrinsics.checkParameterIsNotNull(requestHeaders, "requestHeaders");
        boolean bl = !this.client;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Client cannot push requests.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.newStream(associatedStreamId, requestHeaders, out);
    }

    @NotNull
    public final Http2Stream newStream(@NotNull List<Header> requestHeaders, boolean out) throws IOException {
        Intrinsics.checkParameterIsNotNull(requestHeaders, "requestHeaders");
        return this.newStream(0, requestHeaders, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Http2Stream newStream(int associatedStreamId, List<Header> requestHeaders, boolean out) throws IOException {
        boolean outFinished = !out;
        boolean inFinished = false;
        boolean flushHeaders = false;
        Http2Stream stream = null;
        int streamId = 0;
        Http2Writer http2Writer = this.writer;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (http2Writer) {
            boolean bl3 = false;
            Http2Connection http2Connection = this;
            boolean bl4 = false;
            boolean bl5 = false;
            synchronized (http2Connection) {
                boolean bl6 = false;
                if (this.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.isShutdown) {
                    throw (Throwable)new ConnectionShutdownException();
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new Http2Stream(streamId, this, outFinished, inFinished, null);
                boolean bl7 = flushHeaders = !out || this.writeBytesTotal >= this.writeBytesMaximum || stream.getWriteBytesTotal() >= stream.getWriteBytesMaximum();
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                }
                Unit unit = Unit.INSTANCE;
            }
            if (associatedStreamId == 0) {
                this.writer.headers(outFinished, streamId, requestHeaders);
            } else {
                boolean bl8 = !this.client;
                bl4 = false;
                boolean bl9 = false;
                if (!bl8) {
                    boolean bl10 = false;
                    String string = "client streams shouldn't have associated stream IDs";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                this.writer.pushPromise(associatedStreamId, streamId, requestHeaders);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (flushHeaders) {
            this.writer.flush();
        }
        return stream;
    }

    public final void writeHeaders$okhttp(int streamId, boolean outFinished, @NotNull List<Header> alternating) throws IOException {
        Intrinsics.checkParameterIsNotNull(alternating, "alternating");
        this.writer.headers(outFinished, streamId, alternating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(int streamId, boolean outFinished, @Nullable Buffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.writer.data(outFinished, streamId, buffer, 0);
            return;
        }
        long byteCount2 = byteCount;
        while (byteCount2 > 0L) {
            Ref.IntRef toWrite = new Ref.IntRef();
            Http2Connection http2Connection = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (http2Connection) {
                int n;
                boolean bl3 = false;
                try {
                    while (this.writeBytesTotal >= this.writeBytesMaximum) {
                        if (!this.streams.containsKey(streamId)) {
                            throw (Throwable)new IOException("stream closed");
                        }
                        Http2Connection $this$wait$iv = this;
                        boolean $i$f$wait = false;
                        Http2Connection http2Connection2 = $this$wait$iv;
                        if (http2Connection2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
                        }
                        ((Object)http2Connection2).wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw (Throwable)new InterruptedIOException();
                }
                long l = byteCount2;
                long l2 = this.writeBytesMaximum - this.writeBytesTotal;
                Ref.IntRef intRef = toWrite;
                boolean bl4 = false;
                long l3 = Math.min(l, l2);
                intRef.element = (int)l3;
                int n2 = toWrite.element;
                int n3 = this.writer.maxDataLength();
                intRef = toWrite;
                boolean bl5 = false;
                intRef.element = n = Math.min(n2, n3);
                this.writeBytesTotal += (long)toWrite.element;
                Unit unit = Unit.INSTANCE;
            }
            this.writer.data(outFinished && (byteCount2 -= (long)toWrite.element) == 0L, streamId, buffer, toWrite.element);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynResetLater$okhttp(int streamId, @NotNull ErrorCode errorCode) {
        Intrinsics.checkParameterIsNotNull((Object)errorCode, "errorCode");
        Executor executor = this.writerExecutor;
        String name$iv = "OkHttp " + this.connectionName + " stream " + streamId;
        boolean $i$f$tryExecute = false;
        try {
            void $this$tryExecute$iv;
            void $this$execute$iv$iv = $this$tryExecute$iv;
            boolean $i$f$execute = false;
            $this$execute$iv$iv.execute(new Runnable(name$iv, this, streamId, errorCode){
                final /* synthetic */ String $name;
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ int $streamId$inlined;
                final /* synthetic */ ErrorCode $errorCode$inlined;
                {
                    this.$name = string;
                    this.this$0 = http2Connection;
                    this.$streamId$inlined = n;
                    this.$errorCode$inlined = errorCode;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    Thread currentThread$iv;
                    String name$iv = this.$name;
                    boolean $i$f$threadName = false;
                    Thread thread2 = currentThread$iv = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull(thread2, "currentThread");
                    String oldName$iv = thread2.getName();
                    currentThread$iv.setName(name$iv);
                    try {
                        boolean bl = false;
                        boolean bl2 = false;
                        try {
                            this.this$0.writeSynReset$okhttp(this.$streamId$inlined, this.$errorCode$inlined);
                        }
                        catch (IOException e) {
                            Http2Connection.access$failConnection(this.this$0, e);
                        }
                    }
                    finally {
                        currentThread$iv.setName(oldName$iv);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
    }

    public final void writeSynReset$okhttp(int streamId, @NotNull ErrorCode statusCode) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)statusCode, "statusCode");
        this.writer.rstStream(streamId, statusCode);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeWindowUpdateLater$okhttp(int streamId, long unacknowledgedBytesRead) {
        Executor executor = this.writerExecutor;
        String name$iv = "OkHttp Window Update " + this.connectionName + " stream " + streamId;
        boolean $i$f$tryExecute = false;
        try {
            void $this$tryExecute$iv;
            void $this$execute$iv$iv = $this$tryExecute$iv;
            boolean $i$f$execute = false;
            $this$execute$iv$iv.execute(new Runnable(name$iv, this, streamId, unacknowledgedBytesRead){
                final /* synthetic */ String $name;
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ int $streamId$inlined;
                final /* synthetic */ long $unacknowledgedBytesRead$inlined;
                {
                    this.$name = string;
                    this.this$0 = http2Connection;
                    this.$streamId$inlined = n;
                    this.$unacknowledgedBytesRead$inlined = l;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    Thread currentThread$iv;
                    String name$iv = this.$name;
                    boolean $i$f$threadName = false;
                    Thread thread2 = currentThread$iv = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull(thread2, "currentThread");
                    String oldName$iv = thread2.getName();
                    currentThread$iv.setName(name$iv);
                    try {
                        boolean bl = false;
                        boolean bl2 = false;
                        try {
                            this.this$0.getWriter().windowUpdate(this.$streamId$inlined, this.$unacknowledgedBytesRead$inlined);
                        }
                        catch (IOException e) {
                            Http2Connection.access$failConnection(this.this$0, e);
                        }
                    }
                    finally {
                        currentThread$iv.setName(oldName$iv);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writePing(boolean reply, int payload1, int payload2) {
        if (!reply) {
            boolean failedDueToMissingPong = false;
            Http2Connection http2Connection = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (http2Connection) {
                boolean bl3 = false;
                failedDueToMissingPong = this.awaitingPong;
                this.awaitingPong = true;
                Unit unit = Unit.INSTANCE;
            }
            if (failedDueToMissingPong) {
                this.failConnection(null);
                return;
            }
        }
        try {
            this.writer.ping(reply, payload1, payload2);
        }
        catch (IOException e) {
            this.failConnection(e);
        }
    }

    public final void writePingAndAwaitPong() throws InterruptedException {
        this.writePing(false, 1330343787, -257978967);
        this.awaitPong();
    }

    public final synchronized void awaitPong() throws InterruptedException {
        while (this.awaitingPong) {
            Http2Connection $this$wait$iv = this;
            boolean $i$f$wait = false;
            Http2Connection http2Connection = $this$wait$iv;
            if (http2Connection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
            }
            ((Object)http2Connection).wait();
        }
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(@NotNull ErrorCode statusCode) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)statusCode, "statusCode");
        Http2Writer http2Writer = this.writer;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (http2Writer) {
            boolean bl3 = false;
            int lastGoodStreamId = 0;
            Http2Connection http2Connection = this;
            boolean bl4 = false;
            boolean bl5 = false;
            synchronized (http2Connection) {
                boolean bl6 = false;
                if (this.isShutdown) {
                    return;
                }
                this.isShutdown = true;
                lastGoodStreamId = this.lastGoodStreamId;
                Unit unit = Unit.INSTANCE;
            }
            this.writer.goAway(lastGoodStreamId, statusCode, Util.EMPTY_BYTE_ARRAY);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void close() {
        this.close$okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close$okhttp(@NotNull ErrorCode connectionCode, @NotNull ErrorCode streamCode, @Nullable IOException cause) {
        Http2Stream[] http2StreamArray;
        Intrinsics.checkParameterIsNotNull((Object)connectionCode, "connectionCode");
        Intrinsics.checkParameterIsNotNull((Object)streamCode, "streamCode");
        boolean bl = !Thread.holdsLock(this);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean $i$f$ignoreIoExceptions = false;
        try {
            boolean bl5 = false;
            this.shutdown(connectionCode);
        }
        catch (IOException iOException) {
        }
        Http2Stream[] streamsToClose = null;
        Http2Connection bl5 = this;
        boolean bl6 = false;
        boolean bl7 = false;
        synchronized (bl5) {
            boolean bl8 = false;
            Map<Integer, Http2Stream> map2 = this.streams;
            boolean bl9 = false;
            if (!map2.isEmpty()) {
                Collection<Http2Stream> $this$toTypedArray$iv = this.streams.values();
                boolean $i$f$toTypedArray = false;
                Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                Http2Stream[] http2StreamArray2 = thisCollection$iv.toArray(new Http2Stream[0]);
                if (http2StreamArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Http2Stream[] http2StreamArray3 = http2StreamArray2;
                streamsToClose = http2StreamArray3;
                this.streams.clear();
            }
            http2StreamArray = Unit.INSTANCE;
        }
        if (streamsToClose != null) {
            Http2Stream[] $this$forEach$iv = streamsToClose;
            boolean $i$f$forEach = false;
            http2StreamArray = $this$forEach$iv;
            int n = http2StreamArray.length;
            for (int i = 0; i < n; ++i) {
                Http2Stream element$iv;
                Http2Stream stream = element$iv = http2StreamArray[i];
                boolean bl10 = false;
                boolean $i$f$ignoreIoExceptions2 = false;
                try {
                    boolean bl11 = false;
                    stream.close(streamCode, cause);
                    continue;
                }
                catch (IOException iOException) {
                }
            }
        }
        boolean $i$f$ignoreIoExceptions3 = false;
        try {
            boolean bl12 = false;
            this.writer.close();
        }
        catch (IOException iOException) {
        }
        $i$f$ignoreIoExceptions3 = false;
        try {
            boolean bl13 = false;
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        this.writerExecutor.shutdown();
        this.pushExecutor.shutdown();
    }

    private final void failConnection(IOException e) {
        this.close$okhttp(ErrorCode.PROTOCOL_ERROR, ErrorCode.PROTOCOL_ERROR, e);
    }

    @JvmOverloads
    public final void start(boolean sendConnectionPreface) throws IOException {
        if (sendConnectionPreface) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int windowSize = this.okHttpSettings.getInitialWindowSize();
            if (windowSize != 65535) {
                this.writer.windowUpdate(0, windowSize - 65535);
            }
        }
        new Thread((Runnable)this.readerRunnable, "OkHttp " + this.connectionName).start();
    }

    public static /* synthetic */ void start$default(Http2Connection http2Connection, boolean bl, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = true;
        }
        http2Connection.start(bl);
    }

    @JvmOverloads
    public final void start() throws IOException {
        Http2Connection.start$default(this, false, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSettings(@NotNull Settings settings) throws IOException {
        Intrinsics.checkParameterIsNotNull(settings, "settings");
        Http2Writer http2Writer = this.writer;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (http2Writer) {
            boolean bl3 = false;
            Http2Connection http2Connection = this;
            boolean bl4 = false;
            boolean bl5 = false;
            synchronized (http2Connection) {
                boolean bl6 = false;
                if (this.isShutdown) {
                    throw (Throwable)new ConnectionShutdownException();
                }
                this.okHttpSettings.merge(settings);
                Unit unit = Unit.INSTANCE;
            }
            this.writer.settings(settings);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean pushedStream$okhttp(int streamId) {
        return streamId != 0 && (streamId & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void pushRequestLater$okhttp(int streamId, @NotNull List<Header> requestHeaders) {
        Intrinsics.checkParameterIsNotNull(requestHeaders, "requestHeaders");
        Object object = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            bl2 = this.currentPushRequests.add(streamId);
        }
        if (!this.isShutdown) {
            object = this.pushExecutor;
            String name$iv = "OkHttp " + this.connectionName + " Push Request[" + streamId + ']';
            boolean $i$f$tryExecute = false;
            try {
                void $this$tryExecute$iv;
                void $this$execute$iv$iv = $this$tryExecute$iv;
                boolean $i$f$execute = false;
                $this$execute$iv$iv.execute(new Runnable(name$iv, this, streamId, requestHeaders){
                    final /* synthetic */ String $name;
                    final /* synthetic */ Http2Connection this$0;
                    final /* synthetic */ int $streamId$inlined;
                    final /* synthetic */ List $requestHeaders$inlined;
                    {
                        this.$name = string;
                        this.this$0 = http2Connection;
                        this.$streamId$inlined = n;
                        this.$requestHeaders$inlined = list;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        block8: {
                            Thread currentThread$iv;
                            String name$iv = this.$name;
                            boolean $i$f$threadName = false;
                            Thread thread2 = currentThread$iv = Thread.currentThread();
                            Intrinsics.checkExpressionValueIsNotNull(thread2, "currentThread");
                            String oldName$iv = thread2.getName();
                            currentThread$iv.setName(name$iv);
                            try {
                                boolean bl = false;
                                boolean bl2 = false;
                                boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onRequest(this.$streamId$inlined, this.$requestHeaders$inlined);
                                boolean $i$f$ignoreIoExceptions = false;
                                try {
                                    boolean bl3 = false;
                                    if (!cancel) break block8;
                                    this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                                    Http2Connection http2Connection = this.this$0;
                                    boolean bl4 = false;
                                    boolean bl5 = false;
                                    synchronized (http2Connection) {
                                        boolean bl6 = false;
                                        bl5 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                                    }
                                }
                                catch (IOException iOException) {
                                }
                            }
                            finally {
                                currentThread$iv.setName(oldName$iv);
                            }
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void pushHeadersLater$okhttp(int streamId, @NotNull List<Header> requestHeaders, boolean inFinished) {
        Intrinsics.checkParameterIsNotNull(requestHeaders, "requestHeaders");
        if (!this.isShutdown) {
            Executor executor = this.pushExecutor;
            String name$iv = "OkHttp " + this.connectionName + " Push Headers[" + streamId + ']';
            boolean $i$f$tryExecute = false;
            try {
                void $this$tryExecute$iv;
                void $this$execute$iv$iv = $this$tryExecute$iv;
                boolean $i$f$execute = false;
                $this$execute$iv$iv.execute(new Runnable(name$iv, this, streamId, requestHeaders, inFinished){
                    final /* synthetic */ String $name;
                    final /* synthetic */ Http2Connection this$0;
                    final /* synthetic */ int $streamId$inlined;
                    final /* synthetic */ List $requestHeaders$inlined;
                    final /* synthetic */ boolean $inFinished$inlined;
                    {
                        this.$name = string;
                        this.this$0 = http2Connection;
                        this.$streamId$inlined = n;
                        this.$requestHeaders$inlined = list;
                        this.$inFinished$inlined = bl;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        block9: {
                            Thread currentThread$iv;
                            String name$iv = this.$name;
                            boolean $i$f$threadName = false;
                            Thread thread2 = currentThread$iv = Thread.currentThread();
                            Intrinsics.checkExpressionValueIsNotNull(thread2, "currentThread");
                            String oldName$iv = thread2.getName();
                            currentThread$iv.setName(name$iv);
                            try {
                                boolean bl = false;
                                boolean bl2 = false;
                                boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onHeaders(this.$streamId$inlined, this.$requestHeaders$inlined, this.$inFinished$inlined);
                                boolean $i$f$ignoreIoExceptions = false;
                                try {
                                    boolean bl3 = false;
                                    if (cancel) {
                                        this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                                    }
                                    if (!cancel && !this.$inFinished$inlined) break block9;
                                    Http2Connection http2Connection = this.this$0;
                                    boolean bl4 = false;
                                    boolean bl5 = false;
                                    synchronized (http2Connection) {
                                        boolean bl6 = false;
                                        bl5 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                                    }
                                }
                                catch (IOException iOException) {
                                }
                            }
                            finally {
                                currentThread$iv.setName(oldName$iv);
                            }
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void pushDataLater$okhttp(int streamId, @NotNull BufferedSource source2, int byteCount, boolean inFinished) throws IOException {
        Intrinsics.checkParameterIsNotNull(source2, "source");
        Buffer buffer = new Buffer();
        source2.require(byteCount);
        source2.read(buffer, byteCount);
        if (!this.isShutdown) {
            void $this$execute$iv;
            Executor executor = this.pushExecutor;
            String name$iv = "OkHttp " + this.connectionName + " Push Data[" + streamId + ']';
            boolean $i$f$execute = false;
            $this$execute$iv.execute(new Runnable(name$iv, this, streamId, buffer, byteCount, inFinished){
                final /* synthetic */ String $name;
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ int $streamId$inlined;
                final /* synthetic */ Buffer $buffer$inlined;
                final /* synthetic */ int $byteCount$inlined;
                final /* synthetic */ boolean $inFinished$inlined;
                {
                    this.$name = string;
                    this.this$0 = http2Connection;
                    this.$streamId$inlined = n;
                    this.$buffer$inlined = buffer;
                    this.$byteCount$inlined = n2;
                    this.$inFinished$inlined = bl;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    block9: {
                        Thread currentThread$iv;
                        String name$iv = this.$name;
                        boolean $i$f$threadName = false;
                        Thread thread2 = currentThread$iv = Thread.currentThread();
                        Intrinsics.checkExpressionValueIsNotNull(thread2, "currentThread");
                        String oldName$iv = thread2.getName();
                        currentThread$iv.setName(name$iv);
                        try {
                            boolean bl = false;
                            boolean bl2 = false;
                            boolean $i$f$ignoreIoExceptions = false;
                            try {
                                boolean bl3 = false;
                                boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onData(this.$streamId$inlined, this.$buffer$inlined, this.$byteCount$inlined, this.$inFinished$inlined);
                                if (cancel) {
                                    this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                                }
                                if (!cancel && !this.$inFinished$inlined) break block9;
                                Http2Connection http2Connection = this.this$0;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                synchronized (http2Connection) {
                                    boolean bl6 = false;
                                    bl5 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                                }
                            }
                            catch (IOException iOException) {
                            }
                        }
                        finally {
                            currentThread$iv.setName(oldName$iv);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void pushResetLater$okhttp(int streamId, @NotNull ErrorCode errorCode) {
        Intrinsics.checkParameterIsNotNull((Object)errorCode, "errorCode");
        if (!this.isShutdown) {
            void $this$execute$iv;
            Executor executor = this.pushExecutor;
            String name$iv = "OkHttp " + this.connectionName + " Push Reset[" + streamId + ']';
            boolean $i$f$execute = false;
            $this$execute$iv.execute(new Runnable(name$iv, this, streamId, errorCode){
                final /* synthetic */ String $name;
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ int $streamId$inlined;
                final /* synthetic */ ErrorCode $errorCode$inlined;
                {
                    this.$name = string;
                    this.this$0 = http2Connection;
                    this.$streamId$inlined = n;
                    this.$errorCode$inlined = errorCode;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    Thread currentThread$iv;
                    String name$iv = this.$name;
                    boolean $i$f$threadName = false;
                    Thread thread2 = currentThread$iv = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull(thread2, "currentThread");
                    String oldName$iv = thread2.getName();
                    currentThread$iv.setName(name$iv);
                    try {
                        boolean bl = false;
                        boolean bl2 = false;
                        Http2Connection.access$getPushObserver$p(this.this$0).onReset(this.$streamId$inlined, this.$errorCode$inlined);
                        Http2Connection http2Connection = this.this$0;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        synchronized (http2Connection) {
                            boolean bl5 = false;
                            bl4 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    finally {
                        currentThread$iv.setName(oldName$iv);
                    }
                }
            });
        }
    }

    public Http2Connection(@NotNull Builder builder) {
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        this.client = builder.getClient$okhttp();
        this.listener = builder.getListener$okhttp();
        Http2Connection http2Connection = this;
        boolean bl = false;
        Object object = new LinkedHashMap();
        http2Connection.streams = object;
        this.connectionName = builder.getConnectionName$okhttp();
        this.nextStreamId = builder.getClient$okhttp() ? 3 : 2;
        this.writerExecutor = new ScheduledThreadPoolExecutor(1, Util.threadFactory(Util.format("OkHttp %s Writer", this.connectionName), false));
        this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), Util.threadFactory(Util.format("OkHttp %s Push Observer", this.connectionName), true));
        this.pushObserver = builder.getPushObserver$okhttp();
        Settings settings = new Settings();
        http2Connection = this;
        boolean bl2 = false;
        boolean bl3 = false;
        Settings $this$apply = settings;
        boolean bl4 = false;
        if (builder.getClient$okhttp()) {
            $this$apply.set(7, 0x1000000);
        }
        http2Connection.okHttpSettings = object = settings;
        settings = new Settings();
        http2Connection = this;
        bl2 = false;
        bl3 = false;
        $this$apply = settings;
        boolean bl5 = false;
        $this$apply.set(7, 65535);
        $this$apply.set(5, 16384);
        http2Connection.peerSettings = object = settings;
        this.writeBytesMaximum = this.peerSettings.getInitialWindowSize();
        this.socket = builder.getSocket$okhttp();
        this.writer = new Http2Writer(builder.getSink$okhttp(), this.client);
        this.readerRunnable = new ReaderRunnable(new Http2Reader(builder.getSource$okhttp(), this.client));
        http2Connection = this;
        boolean bl6 = false;
        http2Connection.currentPushRequests = object = (Set)new LinkedHashSet();
        if (builder.getPingIntervalMillis$okhttp() != 0) {
            this.writerExecutor.scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public final void run() {
                    Thread currentThread$iv;
                    String name$iv = "OkHttp " + this.getConnectionName$okhttp() + " ping";
                    boolean $i$f$threadName = false;
                    Thread thread2 = currentThread$iv = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull(thread2, "currentThread");
                    String oldName$iv = thread2.getName();
                    currentThread$iv.setName(name$iv);
                    try {
                        boolean bl = false;
                        this.writePing(false, 0, 0);
                    }
                    finally {
                        currentThread$iv.setName(oldName$iv);
                    }
                }
            }, builder.getPingIntervalMillis$okhttp(), builder.getPingIntervalMillis$okhttp(), TimeUnit.MILLISECONDS);
        }
    }

    static {
        Companion = new Companion(null);
        listenerExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new SynchronousQueue(), Util.threadFactory("OkHttp Http2Connection", true));
    }

    public static final /* synthetic */ boolean access$getAwaitingPong$p(Http2Connection $this) {
        return $this.awaitingPong;
    }

    public static final /* synthetic */ long access$getWriteBytesMaximum$p(Http2Connection $this) {
        return $this.writeBytesMaximum;
    }

    public static final /* synthetic */ PushObserver access$getPushObserver$p(Http2Connection $this) {
        return $this.pushObserver;
    }

    public static final /* synthetic */ Set access$getCurrentPushRequests$p(Http2Connection $this) {
        return $this.currentPushRequests;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u00102\u001a\u000203J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ.\u0010&\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010 \u001a\u00020!H\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u001a\u0010\b\u001a\u00020\tX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00064"}, d2={"Lokhttp3/internal/http2/Http2Connection$Builder;", "", "client", "", "(Z)V", "getClient$okhttp", "()Z", "setClient$okhttp", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "setConnectionName$okhttp", "(Ljava/lang/String;)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "setListener$okhttp", "(Lokhttp3/internal/http2/Http2Connection$Listener;)V", "pingIntervalMillis", "", "getPingIntervalMillis$okhttp", "()I", "setPingIntervalMillis$okhttp", "(I)V", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "getPushObserver$okhttp", "()Lokhttp3/internal/http2/PushObserver;", "setPushObserver$okhttp", "(Lokhttp3/internal/http2/PushObserver;)V", "sink", "Lokio/BufferedSink;", "getSink$okhttp", "()Lokio/BufferedSink;", "setSink$okhttp", "(Lokio/BufferedSink;)V", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "setSocket$okhttp", "(Ljava/net/Socket;)V", "source", "Lokio/BufferedSource;", "getSource$okhttp", "()Lokio/BufferedSource;", "setSource$okhttp", "(Lokio/BufferedSource;)V", "build", "Lokhttp3/internal/http2/Http2Connection;", "okhttp"})
    public static final class Builder {
        @NotNull
        public Socket socket;
        @NotNull
        public String connectionName;
        @NotNull
        public BufferedSource source;
        @NotNull
        public BufferedSink sink;
        @NotNull
        private Listener listener;
        @NotNull
        private PushObserver pushObserver;
        private int pingIntervalMillis;
        private boolean client;

        @NotNull
        public final Socket getSocket$okhttp() {
            Socket socket = this.socket;
            if (socket == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
            }
            return socket;
        }

        public final void setSocket$okhttp(@NotNull Socket socket) {
            Intrinsics.checkParameterIsNotNull(socket, "<set-?>");
            this.socket = socket;
        }

        @NotNull
        public final String getConnectionName$okhttp() {
            String string = this.connectionName;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException("connectionName");
            }
            return string;
        }

        public final void setConnectionName$okhttp(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull(string, "<set-?>");
            this.connectionName = string;
        }

        @NotNull
        public final BufferedSource getSource$okhttp() {
            BufferedSource bufferedSource = this.source;
            if (bufferedSource == null) {
                Intrinsics.throwUninitializedPropertyAccessException("source");
            }
            return bufferedSource;
        }

        public final void setSource$okhttp(@NotNull BufferedSource bufferedSource) {
            Intrinsics.checkParameterIsNotNull(bufferedSource, "<set-?>");
            this.source = bufferedSource;
        }

        @NotNull
        public final BufferedSink getSink$okhttp() {
            BufferedSink bufferedSink = this.sink;
            if (bufferedSink == null) {
                Intrinsics.throwUninitializedPropertyAccessException("sink");
            }
            return bufferedSink;
        }

        public final void setSink$okhttp(@NotNull BufferedSink bufferedSink) {
            Intrinsics.checkParameterIsNotNull(bufferedSink, "<set-?>");
            this.sink = bufferedSink;
        }

        @NotNull
        public final Listener getListener$okhttp() {
            return this.listener;
        }

        public final void setListener$okhttp(@NotNull Listener listener) {
            Intrinsics.checkParameterIsNotNull(listener, "<set-?>");
            this.listener = listener;
        }

        @NotNull
        public final PushObserver getPushObserver$okhttp() {
            return this.pushObserver;
        }

        public final void setPushObserver$okhttp(@NotNull PushObserver pushObserver) {
            Intrinsics.checkParameterIsNotNull(pushObserver, "<set-?>");
            this.pushObserver = pushObserver;
        }

        public final int getPingIntervalMillis$okhttp() {
            return this.pingIntervalMillis;
        }

        public final void setPingIntervalMillis$okhttp(int n) {
            this.pingIntervalMillis = n;
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String connectionName, @NotNull BufferedSource source2, @NotNull BufferedSink sink2) throws IOException {
            Intrinsics.checkParameterIsNotNull(socket, "socket");
            Intrinsics.checkParameterIsNotNull(connectionName, "connectionName");
            Intrinsics.checkParameterIsNotNull(source2, "source");
            Intrinsics.checkParameterIsNotNull(sink2, "sink");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.socket = socket;
            $this$apply.connectionName = connectionName;
            $this$apply.source = source2;
            $this$apply.sink = sink2;
            return builder;
        }

        public static /* synthetic */ Builder socket$default(Builder builder, Socket socket, String string, BufferedSource bufferedSource, BufferedSink bufferedSink, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = Util.connectionName(socket);
            }
            if ((n & 4) != 0) {
                bufferedSource = Okio.buffer(Okio.source(socket));
            }
            if ((n & 8) != 0) {
                bufferedSink = Okio.buffer(Okio.sink(socket));
            }
            return builder.socket(socket, string, bufferedSource, bufferedSink);
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String connectionName, @NotNull BufferedSource source2) throws IOException {
            return Builder.socket$default(this, socket, connectionName, source2, null, 8, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String connectionName) throws IOException {
            return Builder.socket$default(this, socket, connectionName, null, null, 12, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket) throws IOException {
            return Builder.socket$default(this, socket, null, null, null, 14, null);
        }

        @NotNull
        public final Builder listener(@NotNull Listener listener) {
            Intrinsics.checkParameterIsNotNull(listener, "listener");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.listener = listener;
            return builder;
        }

        @NotNull
        public final Builder pushObserver(@NotNull PushObserver pushObserver) {
            Intrinsics.checkParameterIsNotNull(pushObserver, "pushObserver");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.pushObserver = pushObserver;
            return builder;
        }

        @NotNull
        public final Builder pingIntervalMillis(int pingIntervalMillis) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.pingIntervalMillis = pingIntervalMillis;
            return builder;
        }

        @NotNull
        public final Http2Connection build() {
            return new Http2Connection(this);
        }

        public final boolean getClient$okhttp() {
            return this.client;
        }

        public final void setClient$okhttp(boolean bl) {
            this.client = bl;
        }

        public Builder(boolean client) {
            this.client = client;
            this.listener = Listener.REFUSE_INCOMING_STREAMS;
            this.pushObserver = PushObserver.CANCEL;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J8\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0016J \u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0010H\u0016J.\u0010$\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J \u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\fH\u0016J(\u0010-\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\u0017H\u0016J&\u00101\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00102\u001a\u00020\f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u0018\u00104\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u00105\u001a\u00020\tH\u0016J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u00106\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00107\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00068"}, d2={"Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "Ljava/lang/Runnable;", "Lokhttp3/internal/http2/Http2Reader$Handler;", "reader", "Lokhttp3/internal/http2/Http2Reader;", "(Lokhttp3/internal/http2/Http2Connection;Lokhttp3/internal/http2/Http2Reader;)V", "getReader$okhttp", "()Lokhttp3/internal/http2/Http2Reader;", "ackSettings", "", "alternateService", "streamId", "", "origin", "", "protocol", "Lokio/ByteString;", "host", "port", "maxAge", "", "applyAndAckSettings", "clearPrevious", "", "settings", "Lokhttp3/internal/http2/Settings;", "data", "inFinished", "source", "Lokio/BufferedSource;", "length", "goAway", "lastGoodStreamId", "errorCode", "Lokhttp3/internal/http2/ErrorCode;", "debugData", "headers", "associatedStreamId", "headerBlock", "", "Lokhttp3/internal/http2/Header;", "ping", "ack", "payload1", "payload2", "priority", "streamDependency", "weight", "exclusive", "pushPromise", "promisedStreamId", "requestHeaders", "rstStream", "run", "windowUpdate", "windowSizeIncrement", "okhttp"})
    public final class ReaderRunnable
    implements Runnable,
    Http2Reader.Handler {
        @NotNull
        private final Http2Reader reader;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            IOException errorException = null;
            try {
                this.reader.readConnectionPreface(this);
                while (this.reader.nextFrame(false, this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
            }
            catch (IOException e) {
                errorException = e;
                connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                streamErrorCode = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                Http2Connection.this.close$okhttp(connectionErrorCode, streamErrorCode, errorException);
                Util.closeQuietly(this.reader);
            }
        }

        @Override
        public void data(boolean inFinished, int streamId, @NotNull BufferedSource source2, int length) throws IOException {
            Intrinsics.checkParameterIsNotNull(source2, "source");
            if (Http2Connection.this.pushedStream$okhttp(streamId)) {
                Http2Connection.this.pushDataLater$okhttp(streamId, source2, length, inFinished);
                return;
            }
            Http2Stream dataStream = Http2Connection.this.getStream(streamId);
            if (dataStream == null) {
                Http2Connection.this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                Http2Connection.this.updateConnectionFlowControl$okhttp(length);
                source2.skip(length);
                return;
            }
            dataStream.receiveData(source2, length);
            if (inFinished) {
                dataStream.receiveHeaders(Util.EMPTY_HEADERS, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void headers(boolean inFinished, int streamId, int associatedStreamId, @NotNull List<Header> headerBlock) {
            Intrinsics.checkParameterIsNotNull(headerBlock, "headerBlock");
            if (Http2Connection.this.pushedStream$okhttp(streamId)) {
                Http2Connection.this.pushHeadersLater$okhttp(streamId, headerBlock, inFinished);
                return;
            }
            Http2Stream stream = null;
            Http2Connection http2Connection = Http2Connection.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (http2Connection) {
                boolean bl3 = false;
                stream = Http2Connection.this.getStream(streamId);
                if (stream == null) {
                    void $this$execute$iv;
                    if (Http2Connection.this.isShutdown()) {
                        return;
                    }
                    if (streamId <= Http2Connection.this.getLastGoodStreamId$okhttp()) {
                        return;
                    }
                    if (streamId % 2 == Http2Connection.this.getNextStreamId$okhttp() % 2) {
                        return;
                    }
                    Headers headers = Util.toHeaders(headerBlock);
                    Http2Stream newStream = new Http2Stream(streamId, Http2Connection.this, false, inFinished, headers);
                    Http2Connection.this.setLastGoodStreamId$okhttp(streamId);
                    Http2Connection.this.getStreams$okhttp().put(streamId, newStream);
                    Executor executor = listenerExecutor;
                    String name$iv = "OkHttp " + Http2Connection.this.getConnectionName$okhttp() + " stream " + streamId;
                    boolean $i$f$execute = false;
                    $this$execute$iv.execute(new Runnable(name$iv, newStream, this, stream, streamId, headerBlock, inFinished){
                        final /* synthetic */ String $name;
                        final /* synthetic */ Http2Stream $newStream$inlined;
                        final /* synthetic */ ReaderRunnable this$0;
                        final /* synthetic */ Http2Stream $stream$inlined;
                        final /* synthetic */ int $streamId$inlined;
                        final /* synthetic */ List $headerBlock$inlined;
                        final /* synthetic */ boolean $inFinished$inlined;
                        {
                            this.$name = string;
                            this.$newStream$inlined = http2Stream;
                            this.this$0 = readerRunnable;
                            this.$stream$inlined = http2Stream2;
                            this.$streamId$inlined = n;
                            this.$headerBlock$inlined = list;
                            this.$inFinished$inlined = bl;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            Thread currentThread$iv;
                            String name$iv = this.$name;
                            boolean $i$f$threadName = false;
                            Thread thread2 = currentThread$iv = Thread.currentThread();
                            Intrinsics.checkExpressionValueIsNotNull(thread2, "currentThread");
                            String oldName$iv = thread2.getName();
                            currentThread$iv.setName(name$iv);
                            try {
                                boolean bl = false;
                                boolean bl2 = false;
                                try {
                                    this.this$0.Http2Connection.this.getListener$okhttp().onStream(this.$newStream$inlined);
                                }
                                catch (IOException e) {
                                    Platform.Companion.get().log(4, "Http2Connection.Listener failure for " + this.this$0.Http2Connection.this.getConnectionName$okhttp(), e);
                                    boolean $i$f$ignoreIoExceptions = false;
                                    try {
                                        boolean bl3 = false;
                                        this.$newStream$inlined.close(ErrorCode.PROTOCOL_ERROR, e);
                                    }
                                    catch (IOException iOException) {
                                    }
                                }
                            }
                            finally {
                                currentThread$iv.setName(oldName$iv);
                            }
                        }
                    });
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            stream.receiveHeaders(Util.toHeaders(headerBlock), inFinished);
        }

        @Override
        public void rstStream(int streamId, @NotNull ErrorCode errorCode) {
            block1: {
                Http2Stream rstStream;
                Intrinsics.checkParameterIsNotNull((Object)errorCode, "errorCode");
                if (Http2Connection.this.pushedStream$okhttp(streamId)) {
                    Http2Connection.this.pushResetLater$okhttp(streamId, errorCode);
                    return;
                }
                Http2Stream http2Stream = rstStream = Http2Connection.this.removeStream$okhttp(streamId);
                if (http2Stream == null) break block1;
                http2Stream.receiveRstStream(errorCode);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void settings(boolean clearPrevious, @NotNull Settings settings) {
            Intrinsics.checkParameterIsNotNull(settings, "settings");
            Executor executor = Http2Connection.this.writerExecutor;
            String name$iv = "OkHttp " + Http2Connection.this.getConnectionName$okhttp() + " ACK Settings";
            boolean $i$f$tryExecute = false;
            try {
                void $this$tryExecute$iv;
                void $this$execute$iv$iv = $this$tryExecute$iv;
                boolean $i$f$execute = false;
                $this$execute$iv$iv.execute(new Runnable(name$iv, this, clearPrevious, settings){
                    final /* synthetic */ String $name;
                    final /* synthetic */ ReaderRunnable this$0;
                    final /* synthetic */ boolean $clearPrevious$inlined;
                    final /* synthetic */ Settings $settings$inlined;
                    {
                        this.$name = string;
                        this.this$0 = readerRunnable;
                        this.$clearPrevious$inlined = bl;
                        this.$settings$inlined = settings;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        Thread currentThread$iv;
                        String name$iv = this.$name;
                        boolean $i$f$threadName = false;
                        Thread thread2 = currentThread$iv = Thread.currentThread();
                        Intrinsics.checkExpressionValueIsNotNull(thread2, "currentThread");
                        String oldName$iv = thread2.getName();
                        currentThread$iv.setName(name$iv);
                        try {
                            boolean bl = false;
                            boolean bl2 = false;
                            this.this$0.applyAndAckSettings(this.$clearPrevious$inlined, this.$settings$inlined);
                        }
                        finally {
                            currentThread$iv.setName(oldName$iv);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void applyAndAckSettings(boolean clearPrevious, @NotNull Settings settings) {
            Intrinsics.checkParameterIsNotNull(settings, "settings");
            long delta = 0L;
            Http2Stream[] streamsToNotify = null;
            Http2Writer http2Writer = Http2Connection.this.getWriter();
            int n = 0;
            boolean bl = false;
            synchronized (http2Writer) {
                boolean bl2 = false;
                Http2Connection http2Connection = Http2Connection.this;
                boolean bl3 = false;
                boolean bl4 = false;
                synchronized (http2Connection) {
                    boolean bl5 = false;
                    int priorWriteWindowSize = Http2Connection.this.getPeerSettings().getInitialWindowSize();
                    if (clearPrevious) {
                        Http2Connection.this.getPeerSettings().clear();
                    }
                    Http2Connection.this.getPeerSettings().merge(settings);
                    int peerInitialWindowSize = Http2Connection.this.getPeerSettings().getInitialWindowSize();
                    if (peerInitialWindowSize != -1 && peerInitialWindowSize != priorWriteWindowSize) {
                        Http2Stream[] http2StreamArray;
                        boolean bl6;
                        delta = peerInitialWindowSize - priorWriteWindowSize;
                        Map<Integer, Http2Stream> map2 = Http2Connection.this.getStreams$okhttp();
                        boolean bl7 = false;
                        boolean bl8 = bl6 = !map2.isEmpty();
                        if (bl6) {
                            Http2Stream[] http2StreamArray2;
                            Collection<Http2Stream> $this$toTypedArray$iv = Http2Connection.this.getStreams$okhttp().values();
                            boolean $i$f$toTypedArray = false;
                            Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                            Http2Stream[] http2StreamArray3 = thisCollection$iv.toArray(new Http2Stream[0]);
                            if (http2StreamArray3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                            }
                            http2StreamArray = http2StreamArray2 = http2StreamArray3;
                        } else {
                            http2StreamArray = null;
                        }
                        streamsToNotify = http2StreamArray;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    Http2Connection.this.getWriter().applyAndAckSettings(Http2Connection.this.getPeerSettings());
                }
                catch (IOException e) {
                    Http2Connection.this.failConnection(e);
                }
                Http2Stream[] http2StreamArray = Unit.INSTANCE;
            }
            if (streamsToNotify != null) {
                if (streamsToNotify == null) {
                    Intrinsics.throwNpe();
                }
                for (Http2Stream http2Stream : streamsToNotify) {
                    boolean bl9 = false;
                    boolean bl10 = false;
                    synchronized (http2Stream) {
                        boolean bl11 = false;
                        http2Stream.addBytesToWriteWindow(delta);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
            Executor executor = listenerExecutor;
            String name$iv = "OkHttp " + Http2Connection.this.getConnectionName$okhttp() + " settings";
            boolean $i$f$execute = false;
            executor.execute(new Runnable(name$iv, this){
                final /* synthetic */ String $name;
                final /* synthetic */ ReaderRunnable this$0;
                {
                    this.$name = string;
                    this.this$0 = readerRunnable;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    Thread currentThread$iv;
                    String name$iv = this.$name;
                    boolean $i$f$threadName = false;
                    Thread thread2 = currentThread$iv = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull(thread2, "currentThread");
                    String oldName$iv = thread2.getName();
                    currentThread$iv.setName(name$iv);
                    try {
                        boolean bl = false;
                        boolean bl2 = false;
                        this.this$0.Http2Connection.this.getListener$okhttp().onSettings(this.this$0.Http2Connection.this);
                    }
                    finally {
                        currentThread$iv.setName(oldName$iv);
                    }
                }
            });
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void ping(boolean ack, int payload1, int payload2) {
            if (ack) {
                Http2Connection http2Connection = Http2Connection.this;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (http2Connection) {
                    boolean bl3 = false;
                    Http2Connection.this.awaitingPong = false;
                    Http2Connection $this$notifyAll$iv = Http2Connection.this;
                    boolean $i$f$notifyAll = false;
                    Http2Connection http2Connection2 = $this$notifyAll$iv;
                    if (http2Connection2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
                    }
                    ((Object)http2Connection2).notifyAll();
                    Unit unit = Unit.INSTANCE;
                }
            }
            Executor executor = Http2Connection.this.writerExecutor;
            String name$iv = "OkHttp " + Http2Connection.this.getConnectionName$okhttp() + " ping";
            boolean $i$f$tryExecute = false;
            try {
                void $this$tryExecute$iv;
                void $this$execute$iv$iv = $this$tryExecute$iv;
                boolean $i$f$execute = false;
                $this$execute$iv$iv.execute(new Runnable(name$iv, this, payload1, payload2){
                    final /* synthetic */ String $name;
                    final /* synthetic */ ReaderRunnable this$0;
                    final /* synthetic */ int $payload1$inlined;
                    final /* synthetic */ int $payload2$inlined;
                    {
                        this.$name = string;
                        this.this$0 = readerRunnable;
                        this.$payload1$inlined = n;
                        this.$payload2$inlined = n2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        Thread currentThread$iv;
                        String name$iv = this.$name;
                        boolean $i$f$threadName = false;
                        Thread thread2 = currentThread$iv = Thread.currentThread();
                        Intrinsics.checkExpressionValueIsNotNull(thread2, "currentThread");
                        String oldName$iv = thread2.getName();
                        currentThread$iv.setName(name$iv);
                        try {
                            boolean bl = false;
                            boolean bl2 = false;
                            this.this$0.Http2Connection.this.writePing(true, this.$payload1$inlined, this.$payload2$inlined);
                        }
                        finally {
                            currentThread$iv.setName(oldName$iv);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int lastGoodStreamId, @NotNull ErrorCode errorCode, @NotNull ByteString debugData) {
            Intrinsics.checkParameterIsNotNull((Object)errorCode, "errorCode");
            Intrinsics.checkParameterIsNotNull(debugData, "debugData");
            if (debugData.size() > 0) {
                // empty if block
            }
            Http2Stream[] streamsCopy = null;
            Http2Connection http2Connection = Http2Connection.this;
            int n = 0;
            boolean bl = false;
            synchronized (http2Connection) {
                Http2Stream[] http2StreamArray;
                boolean bl2 = false;
                Collection<Http2Stream> $this$toTypedArray$iv = Http2Connection.this.getStreams$okhttp().values();
                boolean $i$f$toTypedArray = false;
                Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                Http2Stream[] http2StreamArray2 = thisCollection$iv.toArray(new Http2Stream[0]);
                if (http2StreamArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                streamsCopy = http2StreamArray = http2StreamArray2;
                Http2Connection.this.setShutdown$okhttp(true);
                Http2Stream[] http2StreamArray3 = Unit.INSTANCE;
            }
            for (Http2Stream http2Stream : streamsCopy) {
                if (http2Stream.getId() <= lastGoodStreamId || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                Http2Connection.this.removeStream$okhttp(http2Stream.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int streamId, long windowSizeIncrement) {
            if (streamId == 0) {
                Http2Connection http2Connection = Http2Connection.this;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (http2Connection) {
                    boolean bl3 = false;
                    Http2Connection http2Connection2 = Http2Connection.this;
                    http2Connection2.writeBytesMaximum = http2Connection2.getWriteBytesMaximum() + windowSizeIncrement;
                    Http2Connection $this$notifyAll$iv = Http2Connection.this;
                    boolean $i$f$notifyAll = false;
                    Http2Connection http2Connection3 = $this$notifyAll$iv;
                    if (http2Connection3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
                    }
                    ((Object)http2Connection3).notifyAll();
                    Unit unit = Unit.INSTANCE;
                }
            }
            Http2Stream stream = Http2Connection.this.getStream(streamId);
            if (stream != null) {
                boolean bl = false;
                boolean bl4 = false;
                synchronized (stream) {
                    boolean bl5 = false;
                    stream.addBytesToWriteWindow(windowSizeIncrement);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        @Override
        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        @Override
        public void pushPromise(int streamId, int promisedStreamId, @NotNull List<Header> requestHeaders) {
            Intrinsics.checkParameterIsNotNull(requestHeaders, "requestHeaders");
            Http2Connection.this.pushRequestLater$okhttp(promisedStreamId, requestHeaders);
        }

        @Override
        public void alternateService(int streamId, @NotNull String origin, @NotNull ByteString protocol, @NotNull String host, int port, long maxAge) {
            Intrinsics.checkParameterIsNotNull(origin, "origin");
            Intrinsics.checkParameterIsNotNull(protocol, "protocol");
            Intrinsics.checkParameterIsNotNull(host, "host");
        }

        @NotNull
        public final Http2Reader getReader$okhttp() {
            return this.reader;
        }

        public ReaderRunnable(Http2Reader reader) {
            Intrinsics.checkParameterIsNotNull(reader, "reader");
            this.reader = reader;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\u000b"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener;", "", "()V", "onSettings", "", "connection", "Lokhttp3/internal/http2/Http2Connection;", "onStream", "stream", "Lokhttp3/internal/http2/Http2Stream;", "Companion", "okhttp"})
    public static abstract class Listener {
        @JvmField
        @NotNull
        public static final Listener REFUSE_INCOMING_STREAMS;
        public static final Companion Companion;

        public abstract void onStream(@NotNull Http2Stream var1) throws IOException;

        public void onSettings(@NotNull Http2Connection connection) {
            Intrinsics.checkParameterIsNotNull(connection, "connection");
        }

        static {
            Companion = new Companion(null);
            REFUSE_INCOMING_STREAMS = new Listener(){

                public void onStream(@NotNull Http2Stream stream) throws IOException {
                    Intrinsics.checkParameterIsNotNull(stream, "stream");
                    stream.close(ErrorCode.REFUSED_STREAM, null);
                }
            };
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener$Companion;", "", "()V", "REFUSE_INCOMING_STREAMS", "Lokhttp3/internal/http2/Http2Connection$Listener;", "okhttp"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lokhttp3/internal/http2/Http2Connection$Companion;", "", "()V", "OKHTTP_CLIENT_WINDOW_SIZE", "", "listenerExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

