/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.adaptivebrightness.config;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class Config {
    public static double max_gamma = 1.0;
    public static double min_gamma = 0.0;
    public static boolean disabled = false;
    public static boolean debug_disabled = false;
    public static boolean print_settings = true;

    public static class_437 init(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43471((String)"title.adaptivebrightness.config"));
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.adaptivebrightness.general"));
        int max_gamma_percent = (int)(max_gamma * 100.0);
        int min_gamma_percent = (int)(min_gamma * 100.0);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43471((String)"option.adaptivebrightness.max_gamma"), max_gamma_percent, 0, 100).setDefaultValue(100).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.adaptivebrightness.max_gamma.tooltip")}).setSaveConsumer(newValue -> {
            max_gamma = (double)newValue.intValue() / 100.0;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43471((String)"option.adaptivebrightness.min_gamma"), min_gamma_percent, 0, 100).setDefaultValue(0).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.adaptivebrightness.min_gamma.tooltip")}).setSaveConsumer(newValue -> {
            min_gamma = (double)newValue.intValue() / 100.0;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.adaptivebrightness.disabled"), disabled).setDefaultValue(disabled).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.adaptivebrightness.disabled.tooltip")}).setSaveConsumer(newValue -> {
            disabled = newValue;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.adaptivebrightness.debug_disabled"), debug_disabled).setDefaultValue(debug_disabled).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.adaptivebrightness.debug_disabled.tooltip")}).setSaveConsumer(newValue -> {
            debug_disabled = newValue;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.adaptivebrightness.print_settings"), print_settings).setDefaultValue(print_settings).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.adaptivebrightness.print_settings.tooltip")}).setSaveConsumer(newValue -> {
            print_settings = newValue;
        }).build());
        builder.setSavingRunnable(() -> {
            FileWriter fileWriter;
            try {
                fileWriter = new FileWriter("config/adaptivebrightness.conf");
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.printf("max %f\n", max_gamma);
            printWriter.printf("min %f\n", min_gamma);
            printWriter.printf("disabled %b\n", disabled);
            printWriter.printf("debug_disabled %b\n", debug_disabled);
            printWriter.printf("print_settings %b\n", print_settings);
            printWriter.close();
        });
        return builder.build();
    }

    public static void load() throws IOException {
        String line;
        FileReader configFile;
        try {
            configFile = new FileReader("config/adaptivebrightness.conf");
        }
        catch (FileNotFoundException ignored) {
            return;
        }
        BufferedReader reader = new BufferedReader(configFile);
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("max ")) {
                max_gamma = Double.parseDouble(line.split("max ")[1]);
                continue;
            }
            if (line.startsWith("min ")) {
                min_gamma = Double.parseDouble(line.split("min ")[1]);
                continue;
            }
            if (line.startsWith("disabled ")) {
                disabled = Boolean.parseBoolean(line.split("disabled ")[1]);
                continue;
            }
            if (line.startsWith("debug_disabled ")) {
                debug_disabled = Boolean.parseBoolean(line.split("debug_disabled ")[1]);
                continue;
            }
            if (!line.startsWith("print_settings ")) continue;
            print_settings = Boolean.parseBoolean(line.split("print_settings ")[1]);
        }
        if (print_settings) {
            System.out.println(max_gamma);
            System.out.println(min_gamma);
            System.out.println(disabled);
            System.out.println(debug_disabled);
            System.out.println(print_settings);
        }
    }
}

