/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.api.settings.SettingsManager;
import carpet.utils.Translations;
import com.jsorrell.carpetskyadditions.SkyAdditionsDataPacks;
import com.jsorrell.carpetskyadditions.advancements.criterion.SkyAdditionsCriteriaTriggers;
import com.jsorrell.carpetskyadditions.advancements.predicates.SkyAdditionsLootItemConditions;
import com.jsorrell.carpetskyadditions.commands.SkyIslandCommand;
import com.jsorrell.carpetskyadditions.config.SkyAdditionsConfig;
import com.jsorrell.carpetskyadditions.events.UseBreezeRodOnTrialSpawner;
import com.jsorrell.carpetskyadditions.gen.SkyBlockChunkGenerator;
import com.jsorrell.carpetskyadditions.gen.feature.SkyAdditionsFeatures;
import com.jsorrell.carpetskyadditions.helpers.PiglinBruteSpawnPredicate;
import com.jsorrell.carpetskyadditions.helpers.SkyAdditionsMinecartComparatorLogic;
import com.jsorrell.carpetskyadditions.settings.SkyAdditionsSettings;
import com.jsorrell.carpetskyadditions.util.SkyAdditionsResourceLocation;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.MinecartComparatorLogic;
import net.fabricmc.fabric.api.object.builder.v1.entity.MinecartComparatorLogicRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_9168;
import net.minecraft.class_9169;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class SkyAdditionsExtension
implements CarpetExtension,
ModInitializer {
    public static MinecraftServer minecraftServer;
    public static final String MOD_ID = "carpetskyadditions";
    public static final ModContainer MOD_CONTAINER;
    public static final String MOD_VERSION;
    public static final String MOD_NAME;
    private static SettingsManager settingsManager;

    public SkyAdditionsExtension() {
        CarpetServer.manageExtension((CarpetExtension)this);
    }

    public void onInitialize() {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
        settingsManager = new SettingsManager(MOD_VERSION, MOD_ID, MOD_NAME);
        settingsManager.parseSettingsClass(SkyAdditionsSettings.class);
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarted);
        AutoConfig.register(SkyAdditionsConfig.class, Toml4jConfigSerializer::new);
        AutoConfig.getConfigHolder(SkyAdditionsConfig.class).save();
        class_1317.method_20637((class_1299)class_1299.field_25751, (class_9168)class_9169.field_48742, (class_2902.class_2903)class_2902.class_2903.field_13203, (class_1317.class_4306)new PiglinBruteSpawnPredicate());
        class_2378.method_10230((class_2378)class_7923.field_41157, (class_2960)new SkyAdditionsResourceLocation("skyblock").getResourceLocation(), SkyBlockChunkGenerator.CODEC);
        SkyAdditionsFeatures.registerAll();
        SkyAdditionsCriteriaTriggers.registerAll();
        SkyAdditionsLootItemConditions.bootstrap();
        MinecartComparatorLogicRegistry.register((class_1299)class_1299.field_6096, (MinecartComparatorLogic)new SkyAdditionsMinecartComparatorLogic());
        SkyAdditionsDataPacks.register();
        UseBreezeRodOnTrialSpawner.register();
    }

    private void onServerStarted(MinecraftServer server) {
        minecraftServer = server;
    }

    public void onGameStarted() {
        settingsManager.parseSettingsClass(SkyAdditionsSettings.class);
    }

    public SettingsManager extensionSettingsManager() {
        return settingsManager;
    }

    public Map<String, String> canHasTranslations(String lang) {
        return Translations.getTranslationFromResourcePath((String)String.format("assets/%s/carpet/lang/%s.json", MOD_ID, lang));
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        SkyIslandCommand.register(dispatcher);
    }

    public String version() {
        return "carpetskyadditions " + MOD_VERSION;
    }

    static {
        MOD_CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow();
        MOD_VERSION = MOD_CONTAINER.getMetadata().getVersion().toString();
        MOD_NAME = MOD_CONTAINER.getMetadata().getName();
    }
}

