/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.advancements.criterion;

import com.jsorrell.carpetskyadditions.helpers.CoralSpreader;
import com.jsorrell.carpetskyadditions.helpers.SmallDripleafSpreader;
import com.jsorrell.carpetskyadditions.util.SkyAdditionsResourceLocation;
import com.jsorrell.carpetskyadditions.util.SkyAdditionsText;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2096;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5250;

public record SkyAdditionsLocationPredicate(Optional<Boolean> desertPyramidCheck, Optional<Boolean> coralConvertible, Optional<class_2096.class_2099> coralSuitability, Optional<Boolean> smallDripleafCanSpread) {
    public static final Codec<SkyAdditionsLocationPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("is_desert_pyramid_blue_terracotta").forGetter(SkyAdditionsLocationPredicate::desertPyramidCheck), (App)Codec.BOOL.optionalFieldOf("coral_convertible").forGetter(SkyAdditionsLocationPredicate::coralConvertible), (App)class_2096.class_2099.field_45762.optionalFieldOf("coral_suitability").forGetter(SkyAdditionsLocationPredicate::coralSuitability), (App)Codec.BOOL.optionalFieldOf("small_dripleaf_spreadable").forGetter(SkyAdditionsLocationPredicate::smallDripleafCanSpread)).apply((Applicative)instance, SkyAdditionsLocationPredicate::new));

    private boolean doDesertPyramidCheck(class_3218 level, class_2338 blueTerracottaPos, boolean sendDebugMessage) {
        class_3499 template = (class_3499)level.method_8503().method_27727().method_15094(new SkyAdditionsResourceLocation("desert_pyramid").getResourceLocation()).orElseThrow();
        class_2338 centerOffset = new class_2338(template.method_15160().method_10263() / 2, 0, template.method_15160().method_10260() / 2);
        class_2338 structureOrigin = blueTerracottaPos.method_10059((class_2382)centerOffset);
        class_3492 placeSettings = new class_3492().method_15119(centerOffset);
        return Arrays.stream(class_2470.values()).anyMatch(r -> {
            placeSettings.method_15123(r);
            for (class_2248 block : new class_2248[]{class_2246.field_10409, class_2246.field_10184, class_2246.field_9979, class_2246.field_10361, class_2246.field_10292, class_2246.field_10142, class_2246.field_10007}) {
                List requiredBlocks = template.method_16445(structureOrigin, placeSettings, block);
                for (class_3499.class_3501 requiredBlock : requiredBlocks) {
                    class_2680 requiredState = requiredBlock.comp_1342();
                    class_2680 currentState = level.method_8320(requiredBlock.comp_1341());
                    if (currentState == requiredState) continue;
                    if (sendDebugMessage && !requiredState.method_26164(class_3481.field_36265)) {
                        class_5250 message;
                        class_238 buildersBox = class_238.method_19316((class_3341)template.method_16187(placeSettings, structureOrigin).method_35410(10));
                        List playersToNotify = level.method_18766(serverPlayer -> buildersBox.method_1006(serverPlayer.method_73189()));
                        if (currentState.method_26204() == requiredState.method_26204()) {
                            Map.Entry incorrectProperty = requiredState.method_11656().entrySet().stream().filter(e -> currentState.method_11654((class_2769)e.getKey()) != e.getValue()).findAny().orElseThrow();
                            message = SkyAdditionsText.translatable("message.desert_pyramid_incorrect_state", requiredBlock.comp_1341().method_10263(), requiredBlock.comp_1341().method_10264(), requiredBlock.comp_1341().method_10260(), ((class_2769)incorrectProperty.getKey()).method_11899(), incorrectProperty.getValue());
                        } else {
                            message = SkyAdditionsText.translatable("message.desert_pyramid_incorrect_block", requiredBlock.comp_1341().method_10263(), requiredBlock.comp_1341().method_10264(), requiredBlock.comp_1341().method_10260(), requiredState.method_26204().method_9518());
                        }
                        playersToNotify.forEach(player -> player.method_64398((class_2561)message.method_27692(class_124.field_1079)));
                    }
                    return false;
                }
            }
            return true;
        });
    }

    public boolean matches(class_3218 level, double x, double y, double z) {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        if (this.desertPyramidCheck.isPresent() && this.doDesertPyramidCheck(level, blockPos, this.desertPyramidCheck.get()) != this.desertPyramidCheck.get().booleanValue()) {
            return false;
        }
        if (this.coralConvertible.isPresent() && CoralSpreader.isConvertible(level, blockPos) != this.coralConvertible.get()) {
            return false;
        }
        if (this.coralSuitability.isPresent() && !this.coralSuitability.get().method_9047(CoralSpreader.calculateCoralSuitability(level, blockPos))) {
            return false;
        }
        return !this.smallDripleafCanSpread.isPresent() || SmallDripleafSpreader.canSpreadFrom(level.method_8320(blockPos), level, blockPos) == this.smallDripleafCanSpread.get();
    }
}

