/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.commands;

import carpet.utils.CommandHelper;
import com.jsorrell.carpetskyadditions.gen.feature.SkyAdditionsConfiguredFeatures;
import com.jsorrell.carpetskyadditions.settings.SkyAdditionsSettings;
import com.jsorrell.carpetskyadditions.util.SkyAdditionsText;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2975;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_5217;
import net.minecraft.class_5250;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class SkyIslandCommand {
    private static final SimpleCommandExceptionType ISLAND_NOT_CREATED = new SimpleCommandExceptionType((Message)SkyAdditionsText.translatable("commands.skyisland.not_created"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        int maxIslandNum = SkyIslandPositionContainer.getNumIslands();
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"skyisland").requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)SkyAdditionsSettings.commandSkyIsland))).then(class_2170.method_9247((String)"new").executes(c -> SkyIslandCommand.newIsland((class_2168)c.getSource())))).then(class_2170.method_9247((String)"join").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"num", (ArgumentType)IntegerArgumentType.integer((int)1, (int)maxIslandNum)).executes(c -> SkyIslandCommand.joinIsland((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207(), IntegerArgumentType.getInteger((CommandContext)c, (String)"num")))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> SkyIslandCommand.joinIsland((class_2168)c.getSource(), class_2186.method_9315((CommandContext)c, (String)"player"), IntegerArgumentType.getInteger((CommandContext)c, (String)"num"))))))).then(class_2170.method_9247((String)"locate").then(class_2170.method_9244((String)"num", (ArgumentType)IntegerArgumentType.integer((int)1, (int)maxIslandNum)).executes(c -> SkyIslandCommand.locateIsland((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"num")))));
        dispatcher.register(command);
    }

    private static int locateIsland(class_2168 source, int islandNum) throws CommandSyntaxException {
        class_1923 chunkPos = SkyIslandPositionContainer.getChunk(islandNum);
        int x = chunkPos.method_33940();
        int z = chunkPos.method_33942();
        class_2791 chunk = source.method_9225().method_22342(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12798);
        if (chunk.method_12009() != class_2806.field_12803) {
            throw ISLAND_NOT_CREATED.create();
        }
        class_5250 text = class_2564.method_10885((class_2561)SkyAdditionsText.translatable("commands.skyisland.locate.coordinates", x, z)).method_27694(style -> style.method_10977(class_124.field_1060).method_10958((class_2558)new class_2558.class_10610("/tp @s " + x + " ~ " + z)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"chat.coordinates.tooltip"))));
        source.method_9226(() -> SkyAdditionsText.translatable("commands.skyisland.locate.success", islandNum, text), false);
        class_2338 sourcePos = class_2338.method_49638((class_2374)source.method_9222());
        int xOff = sourcePos.method_10263() - x;
        int zOff = sourcePos.method_10260() - z;
        return class_3532.method_15375((float)class_3532.method_15355((float)(xOff * xOff + zOff * zOff)));
    }

    private static int newIsland(class_2168 source) {
        int max = SkyIslandPositionContainer.getNumIslands();
        Optional<ImmutablePair> islandOpt = IntStream.range(1, max).mapToObj(i -> ImmutablePair.of((Object)i, (Object)SkyIslandPositionContainer.getChunk(i))).filter(i -> {
            class_2791 chunk = source.method_9225().method_22342(((class_1923)i.right).field_9181, ((class_1923)i.right).field_9180, class_2806.field_12798);
            return chunk.method_12009() == class_2806.field_12798;
        }).findFirst();
        if (islandOpt.isEmpty()) {
            source.method_9226(() -> SkyAdditionsText.translatable("commands.skyisland.new.no_valid_positions"), true);
            return 0;
        }
        ImmutablePair island = islandOpt.get();
        class_1923 chunkPos = (class_1923)island.right;
        int x = chunkPos.method_33940();
        int z = chunkPos.method_33942();
        source.method_9225().method_14178().method_66009(class_3230.field_14032, chunkPos, 2);
        class_2378 configuredFeatureRegistry = source.method_9211().method_30611().method_30530(class_7924.field_41239);
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(source.method_9225().method_8412(), chunkPos.field_9181, chunkPos.field_9180);
        class_6880.class_6883 skyIslandFeature = (class_6880.class_6883)source.method_9211().method_30002().method_30349().method_30530(class_7924.field_41239).method_46746(SkyAdditionsConfiguredFeatures.SPAWN_PLATFORM).get();
        if (!((class_2975)skyIslandFeature.comp_349()).method_12862((class_5281)source.method_9211().method_30002(), source.method_9211().method_30002().method_14178().method_12129(), (class_5819)random, new class_2338(x, 0, z))) {
            SkyAdditionsSettings.LOG.error("Couldn't generate new island");
        }
        Supplier<class_2561> feedback = () -> SkyAdditionsText.translatable("commands.skyisland.new.success", island.getLeft(), x, z);
        source.method_9226(feedback, true);
        return (Integer)island.getLeft();
    }

    private static int joinIsland(class_2168 source, class_3222 player, int islandNum) throws CommandSyntaxException {
        class_1923 chunkPos = SkyIslandPositionContainer.getChunk(islandNum);
        int x = chunkPos.method_33940();
        int z = chunkPos.method_33942();
        SkyIslandCommand.joinIsland(source, player, x, z);
        return 1;
    }

    private static void joinIsland(class_2168 source, class_3222 player, int x, int z) throws CommandSyntaxException {
        int y;
        class_2338 pos = new class_2338(x, 0, z);
        class_1923 chunkPos = new class_1923(pos);
        class_2791 chunk = source.method_9225().method_22342(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12798);
        Supplier<Integer> spawnHeight = () -> chunk.method_12005(class_2902.class_2903.field_13197, x, z) + 1;
        if (chunk.method_12009() != class_2806.field_12803 || (y = spawnHeight.get().intValue()) <= chunk.method_31607()) {
            throw ISLAND_NOT_CREATED.create();
        }
        player.method_5859((double)x + 0.5, (double)y, (double)z + 0.5);
        if (!player.method_6128()) {
            player.method_18799(player.method_18798().method_18805(1.0, 0.0, 1.0));
            player.method_24830(true);
        }
        player.method_26284(new class_3222.class_10766(new class_5217.class_12064(new class_4208(player.method_51469().method_27983(), new class_2338(x, y, z)), 0.0f, 0.0f), false), false);
    }

    public static abstract class SkyIslandPositionContainer {
        private static final ArrayList<class_1923> ISLAND_CHUNKS = new ArrayList();
        private static final int[] ORDERING = new int[]{46, 59, 41, 54, 50, 63, 24, 13, 8, 16, 57, 48, 61, 39, 52, 19, 11, 31, 36, 20, 33, 44, 27, 22, 29, 1, 4, 3, 6, 2, 5, 38, 30, 34, 26, 35, 25, 21, 28, 37, 23, 32, 51, 0, 43, 56, 40, 53, 49, 62, 45, 58, 47, 60, 42, 55, 10, 7, 17, 12, 15, 14, 9, 18};

        public static int getNumIslands() {
            return ORDERING.length;
        }

        public static class_1923 getChunk(int i) {
            return ISLAND_CHUNKS.get(ORDERING[i - 1]);
        }

        private static ArrayList<class_1923> getIslandsInRing(int radius, int num, double offetAngle) {
            ArrayList<class_1923> islands = new ArrayList<class_1923>();
            for (int i = 0; i < num; ++i) {
                double angle = offetAngle + (double)i * (Math.PI * 2) / (double)num;
                double x = Math.sin(angle) * (double)radius;
                double z = Math.cos(angle) * (double)radius;
                islands.add(new class_1923((int)x, (int)z));
            }
            return islands;
        }

        static {
            ISLAND_CHUNKS.addAll(SkyIslandPositionContainer.getIslandsInRing(384, 6, 0.25));
            ISLAND_CHUNKS.addAll(SkyIslandPositionContainer.getIslandsInRing(768, 13, 0.5));
            ISLAND_CHUNKS.addAll(SkyIslandPositionContainer.getIslandsInRing(1152, 19, 0.75));
            ISLAND_CHUNKS.addAll(SkyIslandPositionContainer.getIslandsInRing(1536, 26, 1.0));
        }
    }
}

