/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;

@Config(name="carpetskyadditions")
public class SkyAdditionsConfig
implements ConfigData {
    public boolean defaultToSkyBlockWorld = false;
    public boolean enableDatapackByDefault = false;
    public String initialTreeType = InitialTreeType.OAK.toString();
    public boolean autoEnableDefaultSettings = true;

    private InitialTreeType parseInitialTreeType() throws ConfigData.ValidationException {
        switch (this.initialTreeType.toLowerCase()) {
            case "oak": {
                return InitialTreeType.OAK;
            }
            case "acacia": {
                return InitialTreeType.ACACIA;
            }
        }
        throw new ConfigData.ValidationException("Couldn't parse initialTreeType: " + this.initialTreeType);
    }

    public InitialTreeType getInitialTreeType() {
        try {
            return this.parseInitialTreeType();
        }
        catch (ConfigData.ValidationException e) {
            throw new AssertionError((Object)"Invalid tree type");
        }
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        this.parseInitialTreeType();
    }

    public static enum InitialTreeType {
        OAK,
        ACACIA;


        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "Oak";
                }
                case 1: {
                    return "Acacia";
                }
            }
            return null;
        }
    }
}

