/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.datafix;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import net.minecraft.class_1208;

public class SkyBlockGeneratorNameFix2
extends DataFix {
    private static final String NAME = "SkyBlockGeneratorNameFix2";

    public SkyBlockGeneratorNameFix2(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type inputType = this.getInputSchema().getType(class_1208.field_23067);
        OpticFinder inputDimensionsField = inputType.findField("dimensions");
        Type outputType = this.getOutputSchema().getType(class_1208.field_23067);
        Type outputDimensionsFieldType = outputType.findFieldType("dimensions");
        return this.fixTypeEverywhereTyped(NAME, inputType, outputType, inputWorldGenSettings -> inputWorldGenSettings.updateTyped(inputDimensionsField, outputDimensionsFieldType, inputDimensions -> {
            Dynamic dynamicDimensions = (Dynamic)inputDimensions.write().result().orElseThrow(() -> new IllegalStateException("Malformed WorldGenSettings.dimensions"));
            dynamicDimensions = dynamicDimensions.updateMapValues(pair -> pair.mapSecond(dimensionDynamic -> dimensionDynamic.update("generator", dimensionGeneratorDynamic -> {
                String generatorType = dimensionGeneratorDynamic.get("type").asString("");
                if ("skyblock:skyblock".equals(generatorType)) {
                    return dimensionGeneratorDynamic.update("type", generatorTypeDynamic -> generatorTypeDynamic.createString("carpetskyadditions:skyblock"));
                }
                return dimensionGeneratorDynamic;
            })));
            return (Typed)((Pair)outputDimensionsFieldType.readTyped(dynamicDimensions).result().orElseThrow(() -> new IllegalStateException("SkyBlockGeneratorNameFix2 failed."))).getFirst();
        }));
    }
}

