/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.gen;

import com.jsorrell.carpetskyadditions.gen.SkyBlockStructures;
import com.jsorrell.carpetskyadditions.mixin.ChunkGeneratorAccessor;
import com.jsorrell.carpetskyadditions.mixin.JigsawStructureAccessor;
import com.jsorrell.carpetskyadditions.mixin.SinglePoolElementAccessor;
import com.jsorrell.carpetskyadditions.settings.SkyAdditionsSettings;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3188;
import net.minecraft.class_3195;
import net.minecraft.class_3233;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3754;
import net.minecraft.class_3773;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_4076;
import net.minecraft.class_4543;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5425;
import net.minecraft.class_5434;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6673;
import net.minecraft.class_6677;
import net.minecraft.class_6748;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7138;
import net.minecraft.class_7510;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class SkyBlockChunkGenerator
extends class_3754 {
    public static final MapCodec<SkyBlockChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(class_2794::method_12098), (App)class_5284.field_24781.fieldOf("settings").forGetter(class_3754::method_41541)).apply((Applicative)instance, instance.stable(SkyBlockChunkGenerator::new)));

    public SkyBlockChunkGenerator(class_1966 biomeSource, class_6880<class_5284> settings) {
        super(biomeSource, settings);
    }

    @NotNull
    protected MapCodec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12110(class_3233 level, class_5138 structureManager, class_7138 random, class_2791 chunk) {
    }

    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 random, class_5138 structureManager, class_2791 chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public void method_12108(class_3233 worldGenRegion, long l, class_7138 randomState, class_4543 biomeManager, class_5138 structureManager, class_2791 chunkAccess) {
    }

    public void method_12102(class_5281 level, class_2791 chunk, class_5138 structureManager) {
        class_1923 chunkPos = chunk.method_12004();
        class_4076 sectionPos = class_4076.method_18681((class_1923)chunkPos, (int)level.method_32891());
        class_2338 minChunkPos = sectionPos.method_19767();
        class_2378 structureRegistry = level.method_30349().method_30530(class_7924.field_41246);
        Map<Integer, List<class_3195>> structuresPerStep = structureRegistry.method_10220().collect(Collectors.groupingBy(structureType -> structureType.method_41616().ordinal()));
        List<class_7510.class_6827> featuresPerStep = ((ChunkGeneratorAccessor)((Object)this)).getFeaturesPerStep().get();
        class_2919 random = new class_2919((class_5819)new class_6677(class_6673.method_39001()));
        long decorationSeed = random.method_12661(level.method_8412(), minChunkPos.method_10263(), minChunkPos.method_10260());
        ObjectArraySet biomeSet = new ObjectArraySet();
        class_1923.method_19280((class_1923)sectionPos.method_18692(), (int)1).forEach(arg_0 -> SkyBlockChunkGenerator.lambda$applyBiomeDecoration$2(level, (Set)biomeSet, arg_0));
        biomeSet.retainAll(this.field_12761.method_28443());
        int numFeatures = featuresPerStep.size();
        try {
            class_2378 placedFeatures = level.method_30349().method_30530(class_7924.field_41245);
            int numSteps = Math.max(class_2893.class_2895.values().length, numFeatures);
            for (int genStep = 0; genStep < numSteps; ++genStep) {
                int structureInStep = 0;
                if (structureManager.method_27834()) {
                    List structuresForStep = structuresPerStep.getOrDefault(genStep, Collections.emptyList());
                    for (class_3195 structure : structuresForStep) {
                        random.method_12664(decorationSeed, structureInStep, genStep);
                        Supplier<String> structureNameSupplier = () -> structureRegistry.method_29113((Object)structure).map(Object::toString).orElseGet(structure::toString);
                        try {
                            if (structure instanceof class_3188 && (SkyAdditionsSettings.generateEndPortals || SkyAdditionsSettings.generateSilverfishSpawners)) {
                                level.method_36972(structureNameSupplier);
                                structureManager.method_38853(sectionPos, structure).forEach(structureStart -> {
                                    for (class_3443 piece : structureStart.method_14963()) {
                                        if (!piece.method_16654(chunkPos, 0) || piece.method_16653() != class_3773.field_16939) continue;
                                        class_3341 chunkBox = ChunkGeneratorAccessor.getWritableArea(chunk);
                                        if (SkyAdditionsSettings.generateEndPortals) {
                                            new SkyBlockStructures.EndPortalStructure(piece).generate((class_5425)level, chunkBox, (class_5819)random);
                                        }
                                        if (!SkyAdditionsSettings.generateSilverfishSpawners) continue;
                                        new SkyBlockStructures.SilverfishSpawnerStructure(piece).generate((class_5425)level, chunkBox, (class_5819)random);
                                    }
                                });
                            } else if (structure instanceof class_5434) {
                                class_6880<class_3785> startPool = ((JigsawStructureAccessor)structure).getStartPool();
                                if (SkyAdditionsSettings.generateMagmaCubeSpawners && startPool.method_40226(class_2960.method_60656((String)"bastion/starts"))) {
                                    level.method_36972(structureNameSupplier);
                                    structureManager.method_38853(sectionPos, structure).forEach(structureStart -> {
                                        for (class_3443 piece : structureStart.method_14963()) {
                                            class_3781 singlePoolElement;
                                            class_2960 pieceId;
                                            class_3790 poolPiece;
                                            class_3784 patt0$temp;
                                            if (!piece.method_16654(chunkPos, 0) || !(piece instanceof class_3790) || !((patt0$temp = (poolPiece = (class_3790)piece).method_16644()) instanceof class_3781) || !(pieceId = (class_2960)((SinglePoolElementAccessor)(singlePoolElement = (class_3781)patt0$temp)).getTemplate().left().orElseThrow(AssertionError::new)).equals((Object)class_2960.method_60656((String)"bastion/treasure/bases/lava_basin"))) continue;
                                            new SkyBlockStructures.MagmaCubeSpawner(piece).generate((class_5425)level, ChunkGeneratorAccessor.getWritableArea(chunk), (class_5819)random);
                                        }
                                    });
                                } else if (SkyAdditionsSettings.generateAncientCityPortals && startPool.method_40226(class_2960.method_60656((String)"ancient_city/city_center"))) {
                                    level.method_36972(structureNameSupplier);
                                    structureManager.method_38853(sectionPos, structure).forEach(structureStart -> {
                                        for (class_3443 piece : structureStart.method_14963()) {
                                            class_3781 singlePoolElement;
                                            class_2960 pieceId;
                                            class_3790 poolPiece;
                                            class_3784 patt0$temp;
                                            if (!piece.method_16654(chunkPos, 0) || !(piece instanceof class_3790) || !((patt0$temp = (poolPiece = (class_3790)piece).method_16644()) instanceof class_3781) || !(pieceId = (class_2960)((SinglePoolElementAccessor)(singlePoolElement = (class_3781)patt0$temp)).getTemplate().left().orElseThrow(AssertionError::new)).method_12836().equals("minecraft") || !pieceId.method_12832().startsWith("ancient_city/city_center/city_center")) continue;
                                            new SkyBlockStructures.AncientCityPortalStructure(piece).generate((class_5425)level, ChunkGeneratorAccessor.getWritableArea(chunk), (class_5819)random);
                                        }
                                    });
                                } else if (SkyAdditionsSettings.generateTrialChambers && startPool.method_40226(class_2960.method_60656((String)"trial_chambers/chamber/end"))) {
                                    level.method_36972(structureNameSupplier);
                                    structureManager.method_38853(sectionPos, structure).forEach(structureStart -> {
                                        for (class_3443 piece : structureStart.method_14963()) {
                                            class_3781 singlePoolElement;
                                            class_2960 pieceId;
                                            class_3790 poolPiece;
                                            class_3784 patt0$temp;
                                            if (!piece.method_16654(chunkPos, 0) || !(piece instanceof class_3790) || !((patt0$temp = (poolPiece = (class_3790)piece).method_16644()) instanceof class_3781) || !(pieceId = (class_2960)((SinglePoolElementAccessor)(singlePoolElement = (class_3781)patt0$temp)).getTemplate().left().orElseThrow(AssertionError::new)).method_12836().equals("minecraft") || !pieceId.method_12832().startsWith("trial_chambers/corridor/entrance")) continue;
                                            new SkyBlockStructures.TrialChamberEntrance(piece).generate((class_5425)level, ChunkGeneratorAccessor.getWritableArea(chunk), (class_5819)random);
                                        }
                                    });
                                }
                            }
                        }
                        catch (Exception e) {
                            class_128 crashReport = class_128.method_560((Throwable)e, (String)"Feature placement");
                            crashReport.method_562("Feature").method_577("Description", structureNameSupplier::get);
                            throw new class_148(crashReport);
                        }
                        ++structureInStep;
                    }
                }
                if (genStep >= numFeatures) continue;
                IntArraySet intSet = new IntArraySet();
                for (class_6880 biome : biomeSet) {
                    List biomeFeatureStepList = ((ChunkGeneratorAccessor)((Object)this)).getGenerationSettingsGetter().apply((class_6880<class_1959>)biome).method_30983();
                    if (genStep >= biomeFeatureStepList.size()) continue;
                    class_6885 biomeFeaturesForStep = (class_6885)biomeFeatureStepList.get(genStep);
                    class_7510.class_6827 indexedFeature = featuresPerStep.get(genStep);
                    biomeFeaturesForStep.method_40239().map(class_6880::comp_349).forEach(placedFeature -> intSet.add(indexedFeature.comp_304().applyAsInt(placedFeature)));
                }
                int n = intSet.size();
                int[] is = intSet.toIntArray();
                Arrays.sort(is);
                class_7510.class_6827 indexedFeature = featuresPerStep.get(genStep);
                for (int o = 0; o < n; ++o) {
                    int p = is[o];
                    class_6796 placedFeature2 = (class_6796)indexedFeature.comp_303().get(p);
                    Supplier<String> placedFeatureNameSupplier = () -> placedFeatures.method_29113((Object)placedFeature2).map(Object::toString).orElseGet(() -> ((class_6796)placedFeature2).toString());
                    random.method_12664(decorationSeed, p, genStep);
                    try {
                        if (!SkyAdditionsSettings.generateRandomEndGateways || !placedFeature2.comp_334().method_40226(class_2960.method_60656((String)"end_gateway_return"))) continue;
                        level.method_36972(placedFeatureNameSupplier);
                        placedFeature2.method_39650(level, (class_2794)this, (class_5819)random, minChunkPos);
                        continue;
                    }
                    catch (Exception e) {
                        class_128 crashReport = class_128.method_560((Throwable)e, (String)"Feature placement");
                        crashReport.method_562("Feature").method_577("Description", placedFeatureNameSupplier::get);
                        throw new class_148(crashReport);
                    }
                }
            }
            level.method_36972(null);
        }
        catch (Exception e) {
            class_128 crashReport = class_128.method_560((Throwable)e, (String)"Biome decoration");
            crashReport.method_562("Generation").method_578("CenterX", (Object)chunkPos.field_9181).method_578("CenterZ", (Object)chunkPos.field_9180).method_578("Seed", (Object)decorationSeed);
            throw new class_148(crashReport);
        }
    }

    public void method_12107(class_3233 level) {
    }

    public int getBaseHeightInEquivalentNoiseWorld(int x, int z, class_2902.class_2903 heightmap, class_5281 level) {
        class_7138 randomState = class_7138.method_41556((class_5284)((class_5284)this.method_41541().comp_349()), (class_7871)level.method_30349().method_30530(class_7924.field_41244), (long)level.method_8412());
        return super.method_16397(x, z, heightmap, (class_5539)level, randomState);
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$2(class_5281 level, Set biomeSet, class_1923 curChunkPos) {
        class_2791 curChunk = level.method_8392(curChunkPos.field_9181, curChunkPos.field_9180);
        for (class_2826 chunkSection : curChunk.method_12006()) {
            chunkSection.method_38294().method_39793(biomeSet::add);
        }
    }
}

