/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.gen;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_39;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7268;
import net.minecraft.class_8961;
import net.minecraft.class_8962;
import net.minecraft.class_9197;
import net.minecraft.class_9199;
import net.minecraft.class_9203;

public class SkyBlockStructures {

    public static class MagmaCubeSpawner
    extends SpawnerStructure {
        public MagmaCubeSpawner(class_3443 piece) {
            super(piece, new class_2338(11, 7, 19), class_1299.field_6102);
        }
    }

    public static class SilverfishSpawnerStructure
    extends SpawnerStructure {
        public SilverfishSpawnerStructure(class_3443 piece) {
            super(piece, new class_2338(5, 3, 9), class_1299.field_6125);
        }
    }

    public static class SpawnerStructure
    extends SkyBlockStructure {
        private final class_2338 spawnerPos;
        private final class_1299<?> spawnerType;

        public SpawnerStructure(class_3443 piece, class_2338 spawnerPos, class_1299<?> spawnerType) {
            super(piece);
            this.spawnerPos = spawnerPos;
            this.spawnerType = spawnerType;
        }

        @Override
        public void generate(class_5425 level, class_3341 bounds, class_5819 random) {
            class_2338.class_2339 spawnerAbsolutePos = this.offsetPos(this.spawnerPos.method_10263(), this.spawnerPos.method_10264(), this.spawnerPos.method_10260());
            if (bounds.method_14662((class_2382)spawnerAbsolutePos)) {
                level.method_22350((class_2338)spawnerAbsolutePos).method_12028(6000L);
                level.method_8652((class_2338)spawnerAbsolutePos, class_2246.field_10260.method_9564(), 2);
                class_2586 blockEntity = level.method_8321((class_2338)spawnerAbsolutePos);
                if (blockEntity instanceof class_2636) {
                    class_2636 spawnerEntity = (class_2636)blockEntity;
                    spawnerEntity.method_46408(this.spawnerType, random);
                }
            }
        }
    }

    public static class TrialChamberEntrance
    extends SkyBlockStructure {
        public TrialChamberEntrance(class_3443 piece) {
            super(piece);
        }

        @Override
        public void generate(class_5425 level, class_3341 bounds, class_5819 random) {
            class_2338.class_2339 vaultPos = this.addBlock(level, class_2246.field_48851.method_9564(), 0, 0, 0, bounds);
            class_2338.class_2339 ominousVaultPos = this.addBlock(level, (class_2680)class_2246.field_48851.method_9564().method_11657((class_2769)class_9197.field_50171, (Comparable)Boolean.valueOf(true)), 1, 0, 0, bounds);
            class_2338.class_2339 trialSpawnerPos = this.addBlock(level, class_2246.field_47336.method_9564(), 10, 0, 0, bounds);
            level.method_8503().method_20493(() -> {
                class_2586 ominousVaultEntity;
                class_2586 vaultEntity;
                class_2586 trialSpawnerEntity = level.method_8321((class_2338)trialSpawnerPos);
                if (trialSpawnerEntity instanceof class_8961) {
                    class_8961 spawner = (class_8961)trialSpawnerEntity;
                    class_2487 configNbt = new class_2487();
                    configNbt.method_10582("normal_config", "minecraft:trial_chamber/breeze/normal");
                    configNbt.method_10582("ominous_config", "minecraft:trial_chamber/breeze/ominous");
                    class_11368 valueInput = class_11352.method_71417(null, (class_7225.class_7874)level.method_30349(), (class_2487)configNbt);
                    spawner.method_55150().method_71404(valueInput);
                    spawner.method_5431();
                }
                if ((vaultEntity = level.method_8321((class_2338)vaultPos)) instanceof class_9199) {
                    class_9199 vault = (class_9199)vaultEntity;
                    class_9203 vaultConfig = vault.method_56737();
                    class_1799 trialKey = new class_1799((class_1935)class_1802.field_47315);
                    class_9203 config = new class_9203(class_39.field_47415, vaultConfig.comp_2306(), vaultConfig.comp_2307(), trialKey, Optional.empty(), class_8962.field_48861, class_8962.class_9198.field_48862);
                    vault.method_56730(config);
                    vault.method_5431();
                }
                if ((ominousVaultEntity = level.method_8321((class_2338)ominousVaultPos)) instanceof class_9199) {
                    class_9199 ominousVault = (class_9199)ominousVaultEntity;
                    class_9203 vaultConfig = ominousVault.method_56737();
                    class_1799 ominousTrialKey = new class_1799((class_1935)class_1802.field_50139);
                    class_9203 ominousConfig = new class_9203(class_39.field_50194, vaultConfig.comp_2306(), vaultConfig.comp_2307(), ominousTrialKey, Optional.empty(), class_8962.field_48861, class_8962.class_9198.field_48862);
                    ominousVault.method_56730(ominousConfig);
                    ominousVault.method_5431();
                }
            });
        }
    }

    public static class AncientCityPortalStructure
    extends SkyBlockStructure {
        public AncientCityPortalStructure(class_3443 piece) {
            super(piece);
        }

        @Override
        public void generate(class_5425 level, class_3341 bounds, class_5819 random) {
            this.fillBlocks(level, class_2246.field_38420.method_9564(), 13, 17, 10, 13, 17, 31, bounds);
            this.fillBlocks(level, class_2246.field_38420.method_9564(), 13, 24, 10, 13, 24, 31, bounds);
            this.fillBlocks(level, class_2246.field_38420.method_9564(), 13, 18, 10, 13, 23, 10, bounds);
            this.fillBlocks(level, class_2246.field_38420.method_9564(), 13, 18, 31, 13, 23, 31, bounds);
            this.addBlock(level, (class_2680)class_2246.field_37571.method_9564().method_11657((class_2769)class_7268.field_38422, (Comparable)Boolean.valueOf(true)), 9, 8, 20, bounds);
        }
    }

    public static class EndPortalStructure
    extends SkyBlockStructure {
        public EndPortalStructure(class_3443 piece) {
            super(piece);
        }

        @Override
        public void generate(class_5425 level, class_3341 bounds, class_5819 random) {
            class_2680 northFrame = class_2246.field_10398.method_9564();
            class_2680 southFrame = (class_2680)northFrame.method_11657((class_2769)class_2333.field_10954, (Comparable)class_2350.field_11035);
            class_2680 eastFrame = (class_2680)northFrame.method_11657((class_2769)class_2333.field_10954, (Comparable)class_2350.field_11034);
            class_2680 westFrame = (class_2680)northFrame.method_11657((class_2769)class_2333.field_10954, (Comparable)class_2350.field_11039);
            boolean complete = true;
            boolean[] hasEye = new boolean[12];
            for (int l = 0; l < hasEye.length; ++l) {
                hasEye[l] = random.method_43057() > 0.9f;
                complete &= hasEye[l];
            }
            this.addBlock(level, (class_2680)southFrame.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(hasEye[0])), 4, 3, 3, bounds);
            this.addBlock(level, (class_2680)southFrame.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(hasEye[1])), 5, 3, 3, bounds);
            this.addBlock(level, (class_2680)southFrame.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(hasEye[2])), 6, 3, 3, bounds);
            this.addBlock(level, (class_2680)northFrame.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(hasEye[3])), 4, 3, 7, bounds);
            this.addBlock(level, (class_2680)northFrame.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(hasEye[4])), 5, 3, 7, bounds);
            this.addBlock(level, (class_2680)northFrame.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(hasEye[5])), 6, 3, 7, bounds);
            this.addBlock(level, (class_2680)eastFrame.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(hasEye[6])), 3, 3, 4, bounds);
            this.addBlock(level, (class_2680)eastFrame.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(hasEye[7])), 3, 3, 5, bounds);
            this.addBlock(level, (class_2680)eastFrame.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(hasEye[8])), 3, 3, 6, bounds);
            this.addBlock(level, (class_2680)westFrame.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(hasEye[9])), 7, 3, 4, bounds);
            this.addBlock(level, (class_2680)westFrame.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(hasEye[10])), 7, 3, 5, bounds);
            this.addBlock(level, (class_2680)westFrame.method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(hasEye[11])), 7, 3, 6, bounds);
            if (complete) {
                this.fillBlocks(level, class_2246.field_10027.method_9564(), 4, 3, 4, 6, 3, 6, bounds);
            }
        }
    }

    protected static abstract class SkyBlockStructure {
        protected class_3341 boundingBox;
        protected StructureOrientation orientation;
        protected class_2470 rotation;
        protected class_2415 mirror;

        public SkyBlockStructure(class_3443 piece) {
            this.boundingBox = piece.method_14935();
            this.rotation = Objects.requireNonNullElse(piece.method_16888(), class_2470.field_11467);
            this.mirror = Objects.requireNonNullElse(piece.method_35460(), class_2415.field_11302);
            this.orientation = new StructureOrientation(this.rotation, this.mirror);
        }

        protected int applyXTransform(int x, int z) {
            return this.orientation.applyXTransform(x, z, this.boundingBox);
        }

        protected int applyYTransform(int y) {
            return y + this.boundingBox.method_35416();
        }

        protected int applyZTransform(int x, int z) {
            return this.orientation.applyZTransform(x, z, this.boundingBox);
        }

        protected class_2338.class_2339 offsetPos(int x, int y, int z) {
            return new class_2338.class_2339(this.applyXTransform(x, z), this.applyYTransform(y), this.applyZTransform(x, z));
        }

        protected class_2338.class_2339 addBlock(class_5425 level, class_2680 block, int x, int y, int z, class_3341 bounds) {
            class_2338.class_2339 blockPos = this.offsetPos(x, y, z);
            if (!bounds.method_14662((class_2382)blockPos)) {
                return blockPos;
            }
            if (this.mirror != class_2415.field_11302) {
                block = block.method_26185(this.mirror);
            }
            if (this.rotation != class_2470.field_11467) {
                block = block.method_26186(this.rotation);
            }
            level.method_22350((class_2338)blockPos).method_12028(6000L);
            level.method_8652((class_2338)blockPos, block, 2);
            return blockPos;
        }

        protected void fillBlocks(class_5425 level, class_2680 block, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_3341 bounds) {
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        this.addBlock(level, block, x, y, z, bounds);
                    }
                }
            }
        }

        public abstract void generate(class_5425 var1, class_3341 var2, class_5819 var3);
    }

    protected record StructureOrientation(class_2470 rotation, class_2415 mirror) {
        private int applyXTransform(int x, int z, class_3341 boundingBox) {
            if (this.rotation == class_2470.field_11467 && this.mirror != class_2415.field_11301 || this.rotation == class_2470.field_11464 && this.mirror == class_2415.field_11301) {
                return boundingBox.method_35415() + x;
            }
            if (this.rotation == class_2470.field_11467 || this.rotation == class_2470.field_11464) {
                return boundingBox.method_35418() - x;
            }
            if (this.rotation == class_2470.field_11465 && this.mirror != class_2415.field_11300 || this.rotation == class_2470.field_11463 && this.mirror == class_2415.field_11300) {
                return boundingBox.method_35415() + z;
            }
            return boundingBox.method_35418() - z;
        }

        private int applyZTransform(int x, int z, class_3341 boundingBox) {
            if (this.rotation == class_2470.field_11467 && this.mirror != class_2415.field_11300 || this.rotation == class_2470.field_11464 && this.mirror == class_2415.field_11300) {
                return boundingBox.method_35417() + z;
            }
            if (this.rotation == class_2470.field_11467 || this.rotation == class_2470.field_11464) {
                return boundingBox.method_35420() - z;
            }
            if (this.rotation == class_2470.field_11463 && this.mirror != class_2415.field_11301 || this.rotation == class_2470.field_11465 && this.mirror == class_2415.field_11300) {
                return boundingBox.method_35417() + x;
            }
            return boundingBox.method_35420() - x;
        }
    }
}

