/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.helpers;

import com.jsorrell.carpetskyadditions.mixin.DolphinAccessorMixin;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1352;
import net.minecraft.class_1433;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_6908;

public class DolphinFindHeartGoal
extends class_1352 {
    private static final float CHANCE_TO_FIND_HEART_OF_THE_SEA = 0.05f;
    private static final float NUM_DIGS = 10.0f;
    private static final Set<class_2248> VALID_OCEAN_FLOORS = Set.of(class_2246.field_10102, class_2246.field_10255);
    private final class_1433 dolphin;
    private int digCounter = 0;
    private boolean diggingPhase = false;

    public DolphinFindHeartGoal(class_1433 dolphin) {
        this.dolphin = dolphin;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    protected Optional<class_2338> determineTreasureLocation() {
        class_2338 potentialTarget = new class_2338(this.dolphin.method_31477() + this.dolphin.method_73183().field_9229.method_43048(16) - 8, -64, this.dolphin.method_31479() + this.dolphin.method_73183().field_9229.method_43048(16) - 8);
        if (this.dolphin.method_73183().method_23753(potentialTarget.method_33096(this.dolphin.method_31478())).method_40220(class_6908.field_36509)) {
            return Optional.of(potentialTarget);
        }
        return Optional.empty();
    }

    public boolean method_6267() {
        return false;
    }

    public boolean method_6264() {
        return this.dolphin.method_6487() && 100 <= this.dolphin.method_5669();
    }

    public void method_6269() {
        class_1937 class_19372 = this.dolphin.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        Optional<class_2338> treasurePosOpt = this.determineTreasureLocation();
        if (treasurePosOpt.isEmpty()) {
            this.dolphin.method_6486(false);
            DolphinFindHeartGoal.displayFailureParticles(level, this.dolphin);
            return;
        }
        class_2338 treasurePos = treasurePosOpt.get();
        ((DolphinAccessorMixin)this.dolphin).setTreasurePos(treasurePos);
        this.dolphin.method_5942().method_6337((double)treasurePos.method_10263(), (double)treasurePos.method_10264(), (double)treasurePos.method_10260(), 0.7);
        DolphinFindHeartGoal.displaySuccessParticles(level, this.dolphin);
    }

    private static void displaySuccessParticles(class_3218 level, class_1433 dolphin) {
        level.method_8421((class_1297)dolphin, (byte)38);
    }

    private static void displayFailureParticles(class_3218 level, class_1433 dolphin) {
        level.method_65096((class_2394)class_2398.field_11249, dolphin.method_23322(1.0), dolphin.method_23319() + 1.6, dolphin.method_23325(1.0), 5, level.field_9229.method_43059() * 0.02, level.field_9229.method_43059() * 0.02, level.field_9229.method_43059() * 0.02, 0.2);
    }

    public void method_6268() {
        class_1937 class_19372 = this.dolphin.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        if (!this.diggingPhase && this.dolphin.method_5942().method_6357()) {
            class_2338 treasurePos = ((DolphinAccessorMixin)this.dolphin).getTreasurePos();
            if (treasurePos == null) {
                DolphinFindHeartGoal.displayFailureParticles(level, this.dolphin);
                this.dolphin.method_6486(false);
                return;
            }
            class_2338 heartPos = new class_2338(treasurePos.method_10263(), this.dolphin.method_31478() - 1, treasurePos.method_10260());
            if (this.dolphin.method_73189().method_24802((class_2374)class_243.method_24955((class_2382)heartPos).method_1031(0.0, 1.0, 0.0), 8.0) && VALID_OCEAN_FLOORS.contains(level.method_8320(heartPos).method_26204())) {
                this.diggingPhase = true;
                this.digCounter = 0;
            } else {
                DolphinFindHeartGoal.displayFailureParticles(level, this.dolphin);
                this.dolphin.method_6486(false);
            }
        } else if (this.diggingPhase) {
            if ((float)this.digCounter < 10.0f) {
                level.method_20290(2001, this.dolphin.method_24515(), class_2248.method_9507((class_2680)this.dolphin.method_73183().method_8320(this.dolphin.method_24515().method_10074())));
                ++this.digCounter;
            } else {
                if (level.field_9229.method_43057() < 0.05f) {
                    class_1799 heartOfTheSea = new class_1799((class_1935)class_1802.field_8207);
                    if (this.dolphin.method_6118(class_1304.field_6173).method_7960() && this.dolphin.method_5939(heartOfTheSea)) {
                        this.dolphin.method_5673(class_1304.field_6173, heartOfTheSea);
                    }
                    DolphinFindHeartGoal.displaySuccessParticles(level, this.dolphin);
                } else {
                    DolphinFindHeartGoal.displayFailureParticles(level, this.dolphin);
                }
                this.dolphin.method_6486(false);
                this.diggingPhase = false;
            }
        }
    }
}

