/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.helpers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.jsorrell.carpetskyadditions.mixin.WanderingTraderAccessor;
import com.jsorrell.carpetskyadditions.settings.SkyAdditionsSettings;
import com.jsorrell.carpetskyadditions.tags.SkyAdditionsBiomeTags;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1390;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3988;
import net.minecraft.class_3989;
import net.minecraft.class_4095;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4125;
import net.minecraft.class_4168;
import net.minecraft.class_7689;
import net.minecraft.class_7691;

public class TraderCamelHelper {
    public static boolean tradersRideCamelsAt(class_1937 level, class_2338 pos) {
        return SkyAdditionsSettings.traderCamels && level.method_23753(pos).method_40220(SkyAdditionsBiomeTags.WANDERING_TRADER_SPAWNS_ON_CAMEL);
    }

    public static boolean isMountedTrader(class_3989 trader) {
        return TraderCamelHelper.getTraderCamel(trader) != null;
    }

    public static class_7689 getTraderCamel(class_3989 trader) {
        class_1297 class_12972 = trader.method_49694();
        if (class_12972 instanceof class_7689) {
            class_7689 camel = (class_7689)class_12972;
            if (SkyAdditionsSettings.traderCamels) {
                return camel;
            }
        }
        return null;
    }

    public static boolean isTraderCamel(class_7689 camel) {
        return camel.method_5642() instanceof class_3989 && SkyAdditionsSettings.traderCamels;
    }

    public static class TraderCamelAI {
        public static class_4095<?> makeBrain(class_4095<class_7689> brain) {
            TraderCamelAI.initCoreActivity(brain);
            brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
            brain.method_24536();
            return brain;
        }

        private static void initCoreActivity(class_4095<class_7689> brain) {
            brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)new class_7691.class_7692(4.0f), (Object)new class_4110(45, 90), (Object)new class_4112()));
        }
    }

    public static class TradeWithPlayerWhileMountedGoal
    extends class_1390 {
        protected class_3988 villager;

        public TradeWithPlayerWhileMountedGoal(class_3988 villager) {
            super(villager);
            this.villager = villager;
        }

        public boolean method_6264() {
            if (!this.villager.method_5805()) {
                return false;
            }
            if (this.villager.method_5799()) {
                return false;
            }
            class_1297 vehicle = this.villager.method_5854();
            if (vehicle == null ? !this.villager.method_24828() : !vehicle.method_24828()) {
                return false;
            }
            if (this.villager.field_6037) {
                return false;
            }
            class_1657 player = this.villager.method_8257();
            if (player == null) {
                return false;
            }
            if (this.villager.method_5858((class_1297)player) > 16.0) {
                return false;
            }
            return player.field_7512 != null;
        }
    }

    public static class MountedTraderWanderToPositionGoal
    extends class_1352 {
        final class_3989 trader;
        final double stopDistance;
        final double speedModifier;

        public MountedTraderWanderToPositionGoal(class_3989 trader, double stopDistance, double speedModifier) {
            this.trader = trader;
            this.stopDistance = stopDistance;
            this.speedModifier = speedModifier;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public void method_6270() {
            this.trader.method_18069(null);
            this.trader.method_5942().method_6340();
        }

        public boolean method_6264() {
            class_2338 target = ((WanderingTraderAccessor)this.trader).getWanderTarget();
            return target != null && this.isTooFarAway(target, this.stopDistance);
        }

        public void method_6268() {
            class_2338 target = ((WanderingTraderAccessor)this.trader).getWanderTarget();
            if (target != null && this.trader.method_5942().method_6357()) {
                if (this.isTooFarAway(target, 10.0)) {
                    class_243 directionTowardTarget = class_243.method_24954((class_2382)target).method_1020(this.trader.method_73189()).method_1029();
                    class_243 partialTarget = directionTowardTarget.method_1021(10.0).method_1019(this.trader.method_73189());
                    this.trader.method_5942().method_6337(partialTarget.field_1352, partialTarget.field_1351, partialTarget.field_1350, this.speedModifier);
                } else {
                    this.trader.method_5942().method_6337((double)target.method_10263(), (double)target.method_10264(), (double)target.method_10260(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(class_2338 pos, double distance) {
            return !pos.method_19769((class_2374)this.trader.method_73189(), distance);
        }
    }
}

