/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.mixin;

import com.jsorrell.carpetskyadditions.config.SkyAdditionsConfig;
import com.jsorrell.carpetskyadditions.gen.SkyBlockChunkGenerator;
import com.jsorrell.carpetskyadditions.gen.feature.SkyAdditionsConfiguredFeatures;
import com.jsorrell.carpetskyadditions.settings.Fixers;
import com.jsorrell.carpetskyadditions.settings.SkyAdditionsSettings;
import com.jsorrell.carpetskyadditions.settings.SkyBlockDefaults;
import java.io.IOException;
import java.nio.file.Path;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_11545;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_2975;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_5217;
import net.minecraft.class_5218;
import net.minecraft.class_5268;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6880;
import net.minecraft.class_7659;
import net.minecraft.class_7780;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class}, priority=999)
public abstract class MinecraftServerMixin {
    @Shadow
    public abstract Path method_27050(class_5218 var1);

    @Shadow
    public abstract class_7780<class_7659> method_46221();

    @Inject(method={"loadLevel"}, at={@At(value="HEAD")})
    private void fixSettingsFile(CallbackInfo ci) throws IOException {
        Path worldSavePath = this.method_27050(class_5218.field_24188);
        try {
            Fixers.fixSettings(worldSavePath);
        }
        catch (IOException e) {
            SkyAdditionsSettings.LOG.error("Failed to update config", (Throwable)e);
        }
        SkyAdditionsConfig config = (SkyAdditionsConfig)AutoConfig.getConfigHolder(SkyAdditionsConfig.class).get();
        if (config.autoEnableDefaultSettings) {
            SkyBlockDefaults.writeDefaults(worldSavePath);
        }
    }

    @Inject(method={"setInitialSpawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/ServerLevelData;setSpawn(Lnet/minecraft/world/level/storage/LevelData$RespawnData;)V", ordinal=2, shift=At.Shift.AFTER)}, cancellable=true)
    private static void generateSpawnPlatform(class_3218 level, class_5268 levelData, boolean bonusChest, boolean debugWorld, class_11545 listener, CallbackInfo ci) {
        class_3215 chunkManager = level.method_14178();
        class_2794 chunkGenerator = chunkManager.method_12129();
        if (!(chunkGenerator instanceof SkyBlockChunkGenerator)) {
            return;
        }
        class_5217.class_12064 respawnData = levelData.method_74893();
        class_2338 worldSpawn = respawnData.method_74897();
        class_1923 spawnChunk = new class_1923(worldSpawn);
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(level.method_8412(), spawnChunk.field_9181, spawnChunk.field_9180);
        class_6880.class_6883 spawnPlatformFeature = (class_6880.class_6883)level.method_30349().method_30530(class_7924.field_41239).method_46746(SkyAdditionsConfiguredFeatures.SPAWN_PLATFORM).get();
        if (!((class_2975)spawnPlatformFeature.comp_349()).method_12862((class_5281)level, chunkGenerator, (class_5819)random, worldSpawn)) {
            SkyAdditionsSettings.LOG.error("Couldn't generate spawn platform");
        }
        ci.cancel();
    }
}

