/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.mixin;

import com.jsorrell.carpetskyadditions.settings.SkyAdditionsSettings;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_39;
import net.minecraft.class_4208;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7058;
import net.minecraft.class_7924;
import net.minecraft.class_8153;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_8153.class})
public abstract class SnifferMixin
extends class_1429 {
    @Unique
    private static final Map<class_2248, Map<class_5321<class_3195>, Function<class_5819, class_5321<class_52>>>> LOOT_MAP = Map.of(class_2246.field_10102, Map.of(class_7058.field_37173, r -> (double)r.method_43057() < 0.2 ? class_39.field_43353 : class_39.field_43354, class_7058.field_37181, r -> class_39.field_43356), class_2246.field_10255, Map.of(class_7058.field_37180, r -> class_39.field_43357, class_7058.field_43326, r -> (double)r.method_43057() < 0.2 ? class_39.field_44649 : class_39.field_44648));

    protected SnifferMixin(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    protected abstract class_2338 method_51508();

    @Shadow
    protected abstract Stream<class_4208> method_49143();

    @Unique
    private Optional<Function<class_5819, class_5321<class_52>>> getLootTable(class_2338 diggedBlockPos) {
        class_2680 diggedBlockState = this.method_73183().method_8320(diggedBlockPos);
        Map<class_5321<class_3195>, Function<class_5819, class_5321<class_52>>> map = LOOT_MAP.get(diggedBlockState.method_26204());
        if (map == null) {
            return Optional.empty();
        }
        class_2378 structureRegistry = this.method_73183().method_30349().method_30530(class_7924.field_41246);
        return map.entrySet().stream().map(e -> {
            if (((class_3218)this.method_73183()).method_27056().method_38854(diggedBlockPos, (class_3195)structureRegistry.method_29107((class_5321)e.getKey())).method_16657()) {
                return (Function)e.getValue();
            }
            return null;
        }).filter(Objects::nonNull).findAny();
    }

    @Unique
    private boolean shouldDropIron(class_2680 blockState) {
        return blockState.method_26164(class_3481.field_15466) || blockState.method_27852(class_2246.field_10255) || blockState.method_27852(class_2246.field_42728) || blockState.method_27852(class_2246.field_43227);
    }

    @Inject(method={"dropSeed"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/sniffer/Sniffer;dropFromGiftLootTable(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/resources/ResourceKey;Ljava/util/function/BiConsumer;)Z")}, cancellable=true)
    private void dropIronAndSusify(CallbackInfo ci) {
        class_2338 diggedBlockPos = this.method_51508().method_10074();
        class_2680 blockState = this.method_73183().method_8320(diggedBlockPos);
        if (!SkyAdditionsSettings.doSuspiciousSniffers || !this.shouldDropIron(blockState)) {
            return;
        }
        if (SkyAdditionsSettings.ironFromSniffers) {
            class_1799 itemStack = new class_1799((class_1935)class_1802.field_8675);
            class_1542 itemEntity = new class_1542(this.method_73183(), (double)this.method_51508().method_10263(), (double)this.method_51508().method_10264(), (double)this.method_51508().method_10260(), itemStack);
            itemEntity.method_6988();
            this.method_73183().method_8649((class_1297)itemEntity);
            this.method_5783(class_3417.field_42600, 1.0f, 1.0f);
        }
        Optional<Function<class_5819, class_5321<class_52>>> archLootTable = this.getLootTable(diggedBlockPos);
        if (SkyAdditionsSettings.doSuspiciousSniffers && archLootTable.isPresent() && this.method_73183().method_8503().method_3767().method_8355(class_1928.field_19388) && (double)this.method_73183().method_8409().method_43057() < 0.1) {
            class_2248 susBlock = this.method_73183().method_8320(diggedBlockPos).method_27852(class_2246.field_10102) ? class_2246.field_42728 : class_2246.field_43227;
            this.method_73183().method_8501(diggedBlockPos, susBlock.method_9564());
            class_5321<class_52> lootTable = archLootTable.get().apply(this.method_73183().method_8409());
            this.method_73183().method_35230(diggedBlockPos, class_2591.field_42780).ifPresent(e -> e.method_49216(lootTable, this.method_73183().field_9229.method_43055()));
        }
        ci.cancel();
    }

    @Inject(method={"canDig(Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void canSusify(class_2338 digPos, CallbackInfoReturnable<Boolean> cir) {
        class_2680 blockState;
        if (!SkyAdditionsSettings.doSuspiciousSniffers) {
            return;
        }
        class_4208 globalDigPos = class_4208.method_19443((class_5321)this.method_73183().method_27983(), (class_2338)digPos);
        if (this.method_49143().noneMatch(arg_0 -> ((class_4208)globalDigPos).equals(arg_0)) && this.shouldDropIron(blockState = this.method_73183().method_8320(this.method_51508().method_10074())) && Optional.ofNullable(this.method_5942().method_6348(digPos, 1)).map(class_11::method_21655).orElse(false).booleanValue()) {
            cir.setReturnValue((Object)true);
        }
    }
}

