/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.settings;

import com.google.common.collect.Iterables;
import com.jsorrell.carpetskyadditions.settings.FieldPair;
import com.jsorrell.carpetskyadditions.settings.SettingFixer;
import com.jsorrell.carpetskyadditions.settings.SkyAdditionsSetting;
import com.jsorrell.carpetskyadditions.settings.SkyAdditionsSettings;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class Fixers {
    public static void fixSettings(Path rootSavePath) throws IOException {
        ArrayList<String> rules;
        Map<String, ArrayList<SettingFixer>> fixerMap = Fixers.getFixerMap();
        if (fixerMap.size() == 0) {
            return;
        }
        Path configPath = rootSavePath.resolve("carpetskyadditions.conf");
        try {
            rules = new ArrayList<String>(Files.readAllLines(configPath, StandardCharsets.UTF_8));
        }
        catch (NoSuchFileException e) {
            return;
        }
        boolean rulesWereChanged = false;
        for (int i = 0; i < rules.size(); ++i) {
            String ruleLine = (String)rules.get(i);
            if ("locked".equalsIgnoreCase(ruleLine = ruleLine.replaceAll("[\\r\\n]", ""))) {
                return;
            }
            FieldPair fieldPair = new FieldPair(ruleLine);
            List fixers = fixerMap.get(fieldPair.getName());
            if (fixers == null) continue;
            FieldPair oldFieldPair = new FieldPair(fieldPair);
            boolean remove = false;
            for (SettingFixer fixer : fixers) {
                Optional<FieldPair> fieldPairOpt = fixer.fix(fieldPair);
                if (fieldPairOpt.isEmpty()) {
                    remove = true;
                    break;
                }
                fieldPair = fieldPairOpt.get();
            }
            if (remove) {
                rulesWereChanged = true;
                rules.set(i, null);
                SkyAdditionsSettings.LOG.info("Removing old rule " + oldFieldPair.getName());
                continue;
            }
            if (fieldPair.equals(oldFieldPair)) continue;
            rulesWereChanged = true;
            rules.set(i, fieldPair.asConfigLine());
            SkyAdditionsSettings.LOG.info("Changing old rule \"" + String.valueOf(oldFieldPair) + "\" to \"" + String.valueOf(fieldPair) + "\"");
        }
        if (rulesWereChanged) {
            Files.write(configPath, (Iterable<? extends CharSequence>)Iterables.filter(rules, Objects::nonNull), StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    private static Map<String, ArrayList<SettingFixer>> getFixerMap() {
        HashMap<String, ArrayList<SettingFixer>> fixerMap = new HashMap<String, ArrayList<SettingFixer>>();
        for (Field field : SkyAdditionsSettings.class.getDeclaredFields()) {
            SkyAdditionsSetting settingAnnotation = field.getAnnotation(SkyAdditionsSetting.class);
            if (settingAnnotation == null || settingAnnotation.fixer().length == 0) continue;
            for (int i = 0; i < settingAnnotation.fixer().length; ++i) {
                Class<? extends SettingFixer> fixerClass = settingAnnotation.fixer()[i];
                try {
                    Constructor<? extends SettingFixer> fixerConstructor = fixerClass.getDeclaredConstructor(new Class[0]);
                    fixerConstructor.setAccessible(true);
                    SettingFixer fixer = fixerConstructor.newInstance(new Object[0]);
                    HashSet<String> fieldNames = new HashSet<String>(List.of(fixer.names()));
                    for (String name : fieldNames) {
                        ArrayList<SettingFixer> fixerList = fixerMap.getOrDefault(name, new ArrayList());
                        fixerList.add(fixerConstructor.newInstance(new Object[0]));
                        fixerMap.put(name, fixerList);
                    }
                    continue;
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return fixerMap;
    }
}

