/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.settings;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.Rule;
import carpet.api.settings.Validator;
import carpet.api.settings.Validators;
import com.jsorrell.carpetskyadditions.SkyAdditionsExtension;
import com.jsorrell.carpetskyadditions.settings.FieldPair;
import com.jsorrell.carpetskyadditions.settings.SettingFixer;
import com.jsorrell.carpetskyadditions.settings.SkyAdditionsSetting;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2168;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkyAdditionsSettings {
    public static final Logger LOG = LoggerFactory.getLogger((String)SkyAdditionsExtension.MOD_NAME);
    public static final String GENERATION = "generation";
    public static final String WANDERING_TRADER = "wandering_trader";
    @Rule(categories={"command"})
    public static String commandSkyIsland = "ops";
    @Rule(categories={"generation"})
    public static boolean generateEndPortals = true;
    @Rule(categories={"generation"})
    public static boolean generateTrialChambers = true;
    @Rule(categories={"generation"})
    public static boolean generateSilverfishSpawners = true;
    @Rule(categories={"generation"})
    public static boolean generateAncientCityPortals = true;
    @Rule(categories={"generation"})
    public static boolean generateMagmaCubeSpawners = false;
    @Rule(categories={"generation"})
    public static boolean generateRandomEndGateways = false;
    @Rule(categories={"feature", "wandering_trader"})
    @SkyAdditionsSetting(value="true", fixer={TallFlowersTradesNameFix.class})
    public static boolean tallFlowersFromWanderingTrader = false;
    @Rule(categories={"feature", "wandering_trader"})
    public static boolean lavaFromWanderingTrader = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean lightningElectrifiesVines = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean renewableBuddingAmethysts = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean gatewaysSpawnChorus = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean blazeToBreeze = true;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean paleBlossomCreakingHeart = true;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean renewableHeartsOfTheSea = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean renewableDragonHeads = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true", fixer={ShulkerSpawningNameFix.class})
    public static boolean shulkerSpawnsOnDragonKill = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean renewableDiamonds = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean rammingWart = false;
    @Rule(categories={"feature"}, options={"0", "0.2", "1"}, strict=false, validators={Validators.Probablity.class})
    @SkyAdditionsSetting(value="0.2", fixer={SweetBerriesFixer.class})
    public static double foxesSpawnWithSweetBerriesChance = 0.0;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean poisonousPotatoesConvertSpiders = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean saplingsDieOnSand = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean doDeadBushToBush = true;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean renewableEchoShards = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true", fixer={AllayableVexesFixer.class})
    public static boolean allayableVexes = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean coralErosion = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean hugeMushroomsSpreadMycelium = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean renewableNetherrack = false;
    @Rule(categories={"feature"}, options={"true", "false", "no_splash"}, validators={RenewableDeepslateSetting.class})
    @SkyAdditionsSetting(value="true")
    public static String renewableDeepslate = "false";
    public static boolean doRenewableDeepslate = false;
    public static boolean renewableDeepslateFromSplash = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean renewableSwiftSneak = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean traderCamels = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean sniffersFromDrowneds = false;
    @Rule(categories={"feature"}, options={"true", "false", "no_iron"}, validators={SuspiciousSniffersSetting.class})
    @SkyAdditionsSetting(value="true")
    public static String suspiciousSniffers = "false";
    public static boolean doSuspiciousSniffers = false;
    public static boolean ironFromSniffers = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean spreadingSmallDripleaves = false;
    @Rule(categories={"feature"})
    @SkyAdditionsSetting(value="true")
    public static boolean spreadingCoral = false;
    @Rule(categories={"wandering_trader"}, options={"0.075", "0.2", "1"}, strict=false, validators={WanderingTraderSpawnChanceValidator.class})
    public static double maxWanderingTraderSpawnChance = 0.075;
    @Rule(categories={"wandering_trader"}, options={"6000", "24000", "72000"}, strict=false, validators={POSITIVE_NUMBER.class})
    public static int wanderingTraderSpawnRate = 24000;

    public static Map<String, Object> getRules() {
        HashMap<String, Object> rules = new HashMap<String, Object>();
        rules.put("coralErosion", true);
        rules.put("allayableVexes", true);
        rules.put("renewableDragonHeads", true);
        rules.put("suspiciousSniffers", true);
        rules.put("tallFlowersFromWanderingTrader", true);
        rules.put("spreadingSmallDripleaves", true);
        rules.put("spreadingCoral", true);
        rules.put("shulkerSpawnsOnDragonKill", true);
        rules.put("renewableSwiftSneak", true);
        rules.put("traderCamels", true);
        rules.put("renewableDeepslate", true);
        rules.put("renewableNetherrack", true);
        rules.put("lightningElectrifiesVines", true);
        rules.put("renewableEchoShards", true);
        rules.put("foxesSpawnWithSweetBerriesChance", 0.2);
        rules.put("saplingsDieOnSand", true);
        rules.put("doDeadBushToBush", true);
        rules.put("renewableHeartsOfTheSea", true);
        rules.put("renewableDiamonds", true);
        rules.put("rammingWart", true);
        rules.put("hugeMushroomsSpreadMycelium", true);
        rules.put("renewableBuddingAmethysts", true);
        rules.put("poisonousPotatoesConvertSpiders", true);
        rules.put("sniffersFromDrowneds", true);
        rules.put("gatewaysSpawnChorus", true);
        rules.put("blazeToBreeze", true);
        rules.put("paleBlossomCreakingHeart", true);
        return rules;
    }

    public static class POSITIVE_NUMBER<T extends Number>
    extends Validator<T> {
        public T validate(class_2168 source, CarpetRule<T> currentRule, T newValue, String string) {
            return (T)(0.0 < ((Number)newValue).doubleValue() ? newValue : null);
        }

        public String description() {
            return "Must be a positive number";
        }
    }

    public static class WanderingTraderSpawnChanceValidator
    extends Validator<Double> {
        public Double validate(class_2168 source, CarpetRule<Double> currentRule, Double newValue, String string) {
            return 0.025 <= newValue && newValue <= 1.0 ? newValue : null;
        }

        public String description() {
            return "Must be between 0.025 and 1";
        }
    }

    private static class SuspiciousSniffersSetting
    extends Validator<String> {
        private SuspiciousSniffersSetting() {
        }

        public String validate(class_2168 source, CarpetRule<String> currentRule, String newValue, String string) {
            doSuspiciousSniffers = !"false".equalsIgnoreCase(newValue);
            ironFromSniffers = "true".equalsIgnoreCase(newValue);
            return newValue;
        }
    }

    private static class RenewableDeepslateSetting
    extends Validator<String> {
        private RenewableDeepslateSetting() {
        }

        public String validate(class_2168 source, CarpetRule<String> currentRule, String newValue, String string) {
            doRenewableDeepslate = !"false".equalsIgnoreCase(newValue);
            renewableDeepslateFromSplash = "true".equalsIgnoreCase(newValue);
            return newValue;
        }
    }

    private static class AllayableVexesFixer
    extends SettingFixer {
        private AllayableVexesFixer() {
        }

        @Override
        public String[] names() {
            return new String[]{"renewableAllays", "allayableVexes"};
        }

        @Override
        public Optional<FieldPair> fix(FieldPair fieldPair) {
            fieldPair.setName("allayableVexes");
            return Optional.of(fieldPair);
        }
    }

    private static class SweetBerriesFixer
    extends SettingFixer {
        private SweetBerriesFixer() {
        }

        @Override
        public String[] names() {
            return new String[]{"foxesSpawnWithBerries", "foxesSpawnWithSweetBerriesChance"};
        }

        @Override
        public Optional<FieldPair> fix(FieldPair fieldPair) {
            if (fieldPair.getName().equals("foxesSpawnWithBerries")) {
                fieldPair.setName("foxesSpawnWithSweetBerriesChance");
                if ("true".equalsIgnoreCase(fieldPair.getValue())) {
                    fieldPair.setValue("0.2");
                } else if ("false".equalsIgnoreCase(fieldPair.getValue())) {
                    fieldPair.setValue("0");
                }
            }
            return Optional.of(fieldPair);
        }
    }

    private static class ShulkerSpawningNameFix
    extends SettingFixer {
        private ShulkerSpawningNameFix() {
        }

        @Override
        public String[] names() {
            return new String[]{"shulkerSpawning", "shulkerSpawnsOnDragonKill"};
        }

        @Override
        public Optional<FieldPair> fix(FieldPair fieldPair) {
            fieldPair.setName("shulkerSpawnsOnDragonKill");
            return Optional.of(fieldPair);
        }
    }

    private static class TallFlowersTradesNameFix
    extends SettingFixer {
        private TallFlowersTradesNameFix() {
        }

        @Override
        public String[] names() {
            return new String[]{"wanderingTraderSkyBlockTrades", "tallFlowersFromWanderingTrader"};
        }

        @Override
        public Optional<FieldPair> fix(FieldPair fieldPair) {
            fieldPair.setName("tallFlowersFromWanderingTrader");
            return Optional.of(fieldPair);
        }
    }
}

