/*
 * Decompiled with CFR 0.152.
 */
package com.jsorrell.carpetskyadditions.settings;

import com.jsorrell.carpetskyadditions.settings.FieldPair;
import com.jsorrell.carpetskyadditions.settings.SkyAdditionsSetting;
import com.jsorrell.carpetskyadditions.settings.SkyAdditionsSettings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public final class SkyBlockDefaults {
    public static void writeDefaults(Path rootSavePath) throws IOException {
        Path defaultsPath = FabricLoader.getInstance().getConfigDir().resolve("carpet");
        SkyBlockDefaults.writeSkyBlockDefaults(rootSavePath.resolve("carpetskyadditions.conf"), defaultsPath.resolve("default_carpetskyadditions.conf"));
        SkyBlockDefaults.writeCarpetDefaults(rootSavePath.resolve("carpet.conf"), defaultsPath.resolve("default_carpet.conf"));
    }

    private static void writeSkyBlockDefaults(Path configPath, Path defaultConfigPath) throws IOException {
        ArrayList<FieldPair> fieldPairs = new ArrayList<FieldPair>();
        for (Field field : SkyAdditionsSettings.class.getDeclaredFields()) {
            SkyAdditionsSetting settingAnnotation = field.getAnnotation(SkyAdditionsSetting.class);
            if (settingAnnotation == null) continue;
            fieldPairs.add(new FieldPair(field.getName(), settingAnnotation.value()));
        }
        SkyBlockDefaults.writeConfigFile(configPath, defaultConfigPath, fieldPairs);
    }

    private static void writeCarpetDefaults(Path configPath, Path defaultConfigPath) throws IOException {
        SkyBlockDefaults.writeConfigFile(configPath, defaultConfigPath, List.of(new FieldPair("renewableSponges", "true"), new FieldPair("piglinsSpawningInBastions", "true")));
    }

    private static void writeConfigFile(Path configPath, Path defaultConfigPath, List<FieldPair> fieldPairs) throws IOException {
        OutputStream out;
        try {
            out = Files.newOutputStream(configPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
        }
        catch (FileAlreadyExistsException e) {
            return;
        }
        HashMap<String, String> globalDefaultSettings = new HashMap<String, String>();
        try {
            InputStream in = Files.newInputStream(defaultConfigPath, StandardOpenOption.READ);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] defaultSettingFields = line.split("\\s+", 2);
                    if (1 >= defaultSettingFields.length) continue;
                    globalDefaultSettings.put(defaultSettingFields[0], defaultSettingFields[1]);
                }
            }
        }
        catch (IOException in) {
            // empty catch block
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));){
            for (Map.Entry defaultSetting : globalDefaultSettings.entrySet()) {
                writer.write(new FieldPair((String)defaultSetting.getKey(), (String)defaultSetting.getValue()).asConfigLine());
                writer.newLine();
            }
            for (FieldPair fieldPair : fieldPairs) {
                if (globalDefaultSettings.containsKey(fieldPair.name)) continue;
                writer.write(fieldPair.asConfigLine());
                writer.newLine();
            }
        }
    }
}

