/*
 * Decompiled with CFR 0.152.
 */
package org.orbital_strike;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.orbital_strike.NukePayload;
import org.orbital_strike.Payload;
import org.orbital_strike.StabPayload;

public class OrbitalStrikeCommand
implements CommandExecutor {
    private final JavaPlugin plugin;

    public OrbitalStrikeCommand(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Payload payload;
        double z;
        double x;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 3) {
            player.sendMessage("Usage: /orbitalstrike <payload> <x> <z>");
            return true;
        }
        String payloadType = args[0].toLowerCase();
        try {
            x = Double.parseDouble(args[1]);
            z = Double.parseDouble(args[2]);
        }
        catch (NumberFormatException e) {
            player.sendMessage("Coordinates must be numbers.");
            return true;
        }
        World world = player.getWorld();
        Location target = new Location(world, x, (double)(world.getMaxHeight() - 10), z);
        switch (payloadType) {
            case "stab": {
                payload = new StabPayload(this.plugin, target);
                break;
            }
            case "nuke": {
                payload = new NukePayload(this.plugin, target);
                break;
            }
            default: {
                return true;
            }
        }
        payload.deploy(world, target);
        return true;
    }
}

