/*
 * Decompiled with CFR 0.152.
 */
package org.orbital_strike;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class TntRings {
    private final JavaPlugin plugin;
    private final World world;
    private final Location center;
    private final int[] radii;
    private static final int TOTAL_TICKS = 100;
    private static final double VELOCITY_MULTIPLIER = 3.0;

    public TntRings(JavaPlugin plugin, World world, Location center, int[] radii, double spawnHeight) {
        this.plugin = plugin;
        this.world = world;
        this.center = center.clone();
        this.radii = radii;
        this.center.setY((double)world.getHighestBlockYAt(center) + spawnHeight);
    }

    public void spawnRings() {
        for (int radius : this.radii) {
            int tntCount = radius <= 5 ? 20 : 80;
            for (int i = 0; i < tntCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)tntCount;
                Location spawnLoc = this.center.clone().add(0.0, 1.0, 0.0);
                TNTPrimed tnt = (TNTPrimed)this.world.spawnEntity(spawnLoc, EntityType.TNT);
                tnt.setFuseTicks(100);
                if (radius <= 5) {
                    tnt.setVelocity(new Vector(0, 0, 0));
                    continue;
                }
                Vector dir = new Vector(Math.cos(angle), 0.0, Math.sin(angle)).normalize();
                double baseSpeed = (double)radius / 100.0;
                Vector velocity = dir.multiply(baseSpeed * 3.0);
                velocity.setY(0.04);
                tnt.setVelocity(velocity);
            }
        }
    }
}

