/*
 * Decompiled with CFR 0.152.
 */
package org.orbital_strike;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.orbital_strike.OrbitalStrike;

public class Utils {
    private static final Map<UUID, Integer> bountyTasks = new HashMap<UUID, Integer>();

    public static void startBountyTask(final Player target, OrbitalStrike plugin) {
        if (bountyTasks.containsKey(target.getUniqueId())) {
            Bukkit.getScheduler().cancelTask(bountyTasks.get(target.getUniqueId()).intValue());
        }
        if (target.getInventory().getChestplate() != null && target.getInventory().getChestplate().getType() == Material.ELYTRA) {
            target.getInventory().setChestplate(null);
            target.sendMessage("\u00a7cYour Elytra has shattered!");
        }
        Utils.teleportRandom(target);
        target.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 72000, 0, false, false));
        int taskId = new BukkitRunnable(){
            int runs = 0;

            public void run() {
                if (!target.isOnline()) {
                    this.cancel();
                    return;
                }
                if (this.runs >= 12) {
                    Bukkit.broadcastMessage((String)("\u00a7aThe bounty on " + target.getName() + " has expired!"));
                    target.removePotionEffect(PotionEffectType.GLOWING);
                    bountyTasks.remove(target.getUniqueId());
                    this.cancel();
                    return;
                }
                Location loc = target.getLocation();
                String coords = String.format("\u00a7e%s's coordinates: X: %.1f Y: %.1f Z: %.1f \u00a77(%s)", target.getName(), loc.getX(), loc.getY(), loc.getZ(), loc.getWorld().getName());
                Bukkit.broadcastMessage((String)coords);
                ++this.runs;
            }
        }.runTaskTimer((Plugin)plugin, 0L, 6000L).getTaskId();
        bountyTasks.put(target.getUniqueId(), taskId);
    }

    public static void handleLogout(Player player) {
        if (bountyTasks.containsKey(player.getUniqueId())) {
            Location loc = player.getLocation();
            String msg = String.format("\u00a7c%s logged out at X: %.1f Y: %.1f Z: %.1f \u00a77(%s)", player.getName(), loc.getX(), loc.getY(), loc.getZ(), loc.getWorld().getName());
            Bukkit.broadcastMessage((String)msg);
            player.removePotionEffect(PotionEffectType.GLOWING);
            Bukkit.getScheduler().cancelTask(bountyTasks.get(player.getUniqueId()).intValue());
            bountyTasks.remove(player.getUniqueId());
        }
    }

    public static boolean hasBounty(Player player) {
        return bountyTasks.containsKey(player.getUniqueId());
    }

    public static void clearBounty(Player player) {
        if (Utils.hasBounty(player)) {
            Bukkit.getScheduler().cancelTask(bountyTasks.get(player.getUniqueId()).intValue());
            bountyTasks.remove(player.getUniqueId());
            player.removePotionEffect(PotionEffectType.GLOWING);
        }
    }

    public static void teleportRandom(Player player) {
        World world = (World)Bukkit.getWorlds().get(0);
        Random rand = new Random();
        int x = rand.nextInt(10000) - 5000;
        int z = rand.nextInt(10000) - 5000;
        int y = world.getHighestBlockYAt(x, z) + 1;
        Location loc = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
        player.teleport(loc);
        player.sendMessage("\u00a7eYou have been scattered to a random location!");
    }
}

