/*
 * Decompiled with CFR 0.152.
 */
package org.orbital_strike.listeners;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.orbital_strike.StabPayload;

public class StabShotRodListener
implements Listener {
    private final JavaPlugin plugin;

    public StabShotRodListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onUse(PlayerInteractEvent event) {
        ItemMeta meta;
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.FISHING_ROD && item.hasItemMeta() && (meta = item.getItemMeta()) != null && meta.hasLore()) {
            List lore = meta.getLore();
            boolean isStabRod = false;
            for (String line : lore) {
                String stripped = ChatColor.stripColor((String)line);
                if (!stripped.equalsIgnoreCase("Launches a deadly TNT stab")) continue;
                isStabRod = true;
                break;
            }
            if (!isStabRod) {
                return;
            }
            Block targetBlock = player.getTargetBlockExact(150);
            if (targetBlock == null) {
                return;
            }
            FishHook hook = (FishHook)player.launchProjectile(FishHook.class);
            hook.setShooter((ProjectileSource)player);
            Location targetLocation = targetBlock.getLocation();
            new StabPayload(this.plugin, targetLocation).deploy(player.getWorld(), targetLocation);
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            player.spawnParticle(Particle.SMOKE, player.getLocation(), 10, 0.2, 0.5, 0.2, 0.01);
            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
        }
    }
}

