/*
 * Decompiled with CFR 0.152.
 */
package org.orbital_strike;

import java.util.Random;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class TntRings {
    private final JavaPlugin plugin;
    private final World world;
    private final Location center;
    private final int[] radii;
    private final double spawnHeight;
    private static final int TOTAL_TICKS = 110;
    private static final double VELOCITY_MULTIPLIER = 1.8;
    private static final int CORE_TNT_COUNT = 1;
    private final Random random = new Random();

    public TntRings(JavaPlugin plugin, World world, Location center, int[] radii, double spawnHeight) {
        this.plugin = plugin;
        this.world = world;
        this.center = center.clone();
        this.radii = radii;
        this.spawnHeight = spawnHeight;
        this.center.setY((double)world.getHighestBlockYAt(center) + spawnHeight);
    }

    public void spawnRings() {
        this.spawnCoreCluster();
        for (final int radius : this.radii) {
            final int tntCount = 80;
            new BukkitRunnable(this){
                final /* synthetic */ TntRings this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    for (int i = 0; i < tntCount; ++i) {
                        double angle = this.this$0.random.nextDouble() * 2.0 * Math.PI;
                        double x = this.this$0.center.getX() + Math.cos(angle) * 1.0;
                        double z = this.this$0.center.getZ() + Math.sin(angle) * 1.0;
                        Location loc = new Location(this.this$0.world, x, this.this$0.center.getY(), z);
                        TNTPrimed tnt = (TNTPrimed)this.this$0.world.spawnEntity(loc, EntityType.TNT);
                        tnt.setFuseTicks(110);
                        double distance = radius - 1;
                        double speed = distance / 110.0 * 1.8;
                        Vector velocity = new Vector(Math.cos(angle) * speed, 0.05, Math.sin(angle) * speed);
                        tnt.setVelocity(velocity);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 0L);
        }
    }

    private void spawnCoreCluster() {
        for (int i = 0; i < 1; ++i) {
            Location spawnLoc = this.center.clone();
            final TNTPrimed tnt = (TNTPrimed)this.world.spawnEntity(spawnLoc, EntityType.TNT);
            tnt.setFuseTicks(110 + this.random.nextInt(11) - 5);
            tnt.setVelocity(new Vector(0, 0, 0));
            tnt.setGravity(false);
            new BukkitRunnable(this){

                public void run() {
                    tnt.setGravity(true);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }
}

