/*
 * Decompiled with CFR 0.152.
 */
package org.orbital_strike;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Wolf;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.orbital_strike.Payload;

public class WolfPayload
implements Payload {
    private final JavaPlugin plugin;
    private final Location target;

    public WolfPayload(JavaPlugin plugin, Location target) {
        this.plugin = plugin;
        this.target = target;
    }

    @Override
    public void deploy(World world, Location loc) {
        int count = 50;
        double radius = 5.0;
        int duration = 3600;
        for (int i = 0; i < count; ++i) {
            double angle = Math.random() * Math.PI * 2.0;
            double r = Math.random() * radius;
            double x = this.target.getX() + Math.cos(angle) * r;
            double z = this.target.getZ() + Math.sin(angle) * r;
            double y = world.getHighestBlockYAt((int)x, (int)z) + 1;
            Location spawnLoc = new Location(world, x, y, z);
            Wolf wolf = (Wolf)world.spawn(spawnLoc, Wolf.class);
            wolf.setAngry(true);
            wolf.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, duration, 1));
            wolf.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, duration, 1));
            wolf.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, duration, 0));
        }
    }
}

