/*
 * Decompiled with CFR 0.152.
 */
package org.orbital_strike.commands;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class OrbitalRodCommand
implements CommandExecutor {
    private final JavaPlugin plugin;

    public OrbitalRodCommand(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        ItemStack rod;
        String perm;
        String type;
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            return true;
        }
        switch (type = args[0].toLowerCase()) {
            case "nuke": {
                String string = "orbital.use";
                break;
            }
            case "stab": {
                String string = "orbital.use";
                break;
            }
            case "wolf": {
                String string = "orbital.use";
                break;
            }
            default: {
                String string = perm = null;
            }
        }
        if (perm == null || !player.hasPermission(perm)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this rod!");
            return true;
        }
        switch (type) {
            case "nuke": {
                ItemStack itemStack = this.createRod(String.valueOf(ChatColor.WHITE) + "Nuke rod", "nuke_shot");
                break;
            }
            case "stab": {
                ItemStack itemStack = this.createRod(String.valueOf(ChatColor.WHITE) + "Stab rod", "stab_shot_rod");
                break;
            }
            case "wolf": {
                ItemStack itemStack = this.createRod(String.valueOf(ChatColor.WHITE) + "Wolf rod", "wolf_rod");
                break;
            }
            default: {
                ItemStack itemStack = rod = null;
            }
        }
        if (rod == null) {
            return true;
        }
        player.getInventory().addItem(new ItemStack[]{rod});
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You received a " + type + " rod!");
        return true;
    }

    private ItemStack createRod(String displayName, String keyName) {
        ItemStack rod = new ItemStack(Material.FISHING_ROD);
        ItemMeta meta = rod.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(displayName);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE});
            if (meta instanceof Damageable) {
                Damageable dmg = (Damageable)meta;
                dmg.setDamage(rod.getType().getMaxDurability() - 4);
            }
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, keyName);
            meta.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)1);
            rod.setItemMeta(meta);
        }
        return rod;
    }
}

