/*
 * Decompiled with CFR 0.152.
 */
package org.orbital_strike.listeners;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import org.orbital_strike.NukePayload;

public class NukeShotListener
implements Listener {
    private final JavaPlugin plugin;
    private final NamespacedKey key;

    public NukeShotListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.key = new NamespacedKey((Plugin)plugin, "nuke_shot");
    }

    @EventHandler
    public void onReelIn(PlayerFishEvent event) {
        Location targetLocation;
        if (event.getState() != PlayerFishEvent.State.REEL_IN) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack rod = player.getInventory().getItemInMainHand();
        if (rod == null || rod.getType() != Material.FISHING_ROD) {
            return;
        }
        if (!rod.hasItemMeta()) {
            return;
        }
        ItemMeta meta = rod.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        if (!pdc.has(this.key, PersistentDataType.BYTE)) {
            return;
        }
        if (!player.hasPermission(this.plugin.getConfig().getString("permission", "orbital.use"))) {
            return;
        }
        int distance = this.plugin.getConfig().getInt("rod.distance", 500);
        int nukeHeight = this.plugin.getConfig().getInt("nuke.height", 15);
        Block targetBlock = this.getTargetBlock(player, distance);
        if (targetBlock != null) {
            targetLocation = targetBlock.getLocation();
        } else {
            Location fallback = player.getEyeLocation().add(player.getEyeLocation().getDirection().multiply(distance));
            Block highest = player.getWorld().getHighestBlockAt(fallback);
            targetLocation = highest.getLocation().add(0.0, (double)nukeHeight, 0.0);
        }
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        player.getInventory().setItemInMainHand(null);
        new NukePayload(this.plugin, targetLocation).deploy(player.getWorld(), targetLocation);
    }

    private Block getTargetBlock(Player player, int maxDistance) {
        Location eye = player.getEyeLocation();
        Vector dir = eye.getDirection().normalize();
        for (int i = 0; i <= maxDistance; ++i) {
            Location check = eye.clone().add(dir.clone().multiply(i));
            Block block = check.getBlock();
            if (!block.getType().isSolid()) continue;
            return block;
        }
        return null;
    }
}

