/*
 * Decompiled with CFR 0.152.
 */
package org.orbital_strike.listeners;

import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.orbital_strike.StabPayload;

public class StabShotListener
implements Listener {
    private final JavaPlugin plugin;
    private final NamespacedKey key;

    public StabShotListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.key = new NamespacedKey((Plugin)plugin, "stab_shot_rod");
    }

    @EventHandler
    public void onReelIn(PlayerFishEvent event) {
        if (event.getState() != PlayerFishEvent.State.REEL_IN) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("orbital.use")) {
            return;
        }
        ItemStack rod = player.getInventory().getItemInMainHand();
        if (rod == null || rod.getType() != Material.FISHING_ROD) {
            return;
        }
        if (!rod.hasItemMeta()) {
            return;
        }
        ItemMeta meta = rod.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        if (pdc.get(this.key, PersistentDataType.BYTE) == null) {
            return;
        }
        Block targetBlock = player.getTargetBlockExact(500);
        if (targetBlock == null) {
            player.sendMessage("\u00a7cNo valid target found!");
            return;
        }
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        player.getInventory().setItemInMainHand(null);
        StabPayload stab = new StabPayload(this.plugin, targetBlock.getLocation());
        stab.setYield(3.1f);
        stab.setOffset(0.25);
        stab.deploy(player.getWorld(), targetBlock.getLocation());
    }
}

