/*
 * Decompiled with CFR 0.152.
 */
package org.orbital_strike.listeners;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.orbital_strike.WolfPayload;

public class WolfRodListener
implements Listener {
    private final JavaPlugin plugin;
    private final NamespacedKey key;

    public WolfRodListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.key = new NamespacedKey((Plugin)plugin, "wolf_rod");
    }

    @EventHandler
    public void onWolfRodCast(PlayerFishEvent event) {
        if (event.getState() != PlayerFishEvent.State.REEL_IN) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack rod = player.getInventory().getItemInMainHand();
        if (rod == null || rod.getType() != Material.FISHING_ROD) {
            return;
        }
        if (!rod.hasItemMeta()) {
            return;
        }
        ItemMeta meta = rod.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        Byte flag = (Byte)pdc.get(this.key, PersistentDataType.BYTE);
        if (flag == null || flag != 1) {
            return;
        }
        if (!player.hasPermission("orbital.use")) {
            return;
        }
        int distance = 500;
        Block targetBlock = player.getTargetBlockExact(distance);
        if (targetBlock == null) {
            player.sendMessage("\u00a7cNo valid target found!");
            return;
        }
        Location targetLoc = targetBlock.getLocation();
        player.getInventory().setItemInMainHand(null);
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        WolfPayload payload = new WolfPayload(this.plugin, targetLoc);
        payload.deploy(player.getWorld(), targetLoc);
    }
}

