/*
 * Decompiled with CFR 0.152.
 */
package com.kittysim.orbitalstrike;

import com.kittysim.orbitalstrike.AuthCommands;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1541;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public class OrbitalStrikeMod
implements ModInitializer {
    private static CompletableFuture<Suggestions> suggest(Iterable<String> options, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase();
        for (String option : options) {
            if (!option.toLowerCase().startsWith(remaining)) continue;
            builder.suggest(option);
        }
        return builder.buildFuture();
    }

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"orbitalstrike").then(class_2170.method_9244((String)"payload", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> OrbitalStrikeMod.suggest(Arrays.asList("nuke", "stab"), builder)).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(ctx -> {
            String payload = StringArgumentType.getString((CommandContext)ctx, (String)"payload");
            class_2338 pos = class_2262.method_48299((CommandContext)ctx, (String)"pos");
            class_2168 source = (class_2168)ctx.getSource();
            int x = pos.method_10263();
            int z = pos.method_10260();
            source.method_9211().execute(() -> {
                class_3218 world = source.method_9225();
                int groundY = pos.method_10264();
                if ("nuke".equalsIgnoreCase(payload)) {
                    OrbitalStrikeMod.summonNuke((class_1937)world, x, groundY + 72, z);
                } else if ("stab".equalsIgnoreCase(payload)) {
                    OrbitalStrikeMod.summonStab((class_1937)world, x, z, groundY, 60);
                } else {
                    source.method_9213(class_2561.method_30163((String)("Unknown payload: " + payload)));
                }
            });
            return 1;
        })))).then(class_2170.method_9247((String)"crosshair").then(class_2170.method_9244((String)"payload", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> OrbitalStrikeMod.suggest(Arrays.asList("nuke", "stab"), builder)).executes(ctx -> {
            double maxDistance;
            String payload = StringArgumentType.getString((CommandContext)ctx, (String)"payload");
            class_2168 source = (class_2168)ctx.getSource();
            class_3222 player = source.method_44023();
            class_239 hitResult = player.method_5745(maxDistance = 300.0, 0.0f, false);
            if (hitResult.method_17783() != class_239.class_240.field_1332) {
                source.method_9213(class_2561.method_30163((String)("No block in crosshair within " + maxDistance + " blocks.")));
                return 0;
            }
            class_2338 pos = ((class_3965)hitResult).method_17777();
            int x = pos.method_10263();
            int z = pos.method_10260();
            source.method_9211().execute(() -> {
                class_3218 world = source.method_9225();
                int groundY = pos.method_10264();
                if ("nuke".equalsIgnoreCase(payload)) {
                    OrbitalStrikeMod.summonNuke((class_1937)world, x, groundY + 72, z);
                } else if ("stab".equalsIgnoreCase(payload)) {
                    OrbitalStrikeMod.summonStab((class_1937)world, x, z, groundY, 60);
                } else {
                    source.method_9213(class_2561.method_30163((String)("Unknown payload: " + payload)));
                }
            });
            return 1;
        })))));
        AuthCommands.register();
    }

    public static void summonNuke(class_1937 world, int centerX, int centerY, int centerZ) {
        int baseFuse = 100;
        int delayBetweenRings = 0;
        double gravity = -0.03;
        double velocityMultiplier = 2.1;
        int[] radii = new int[]{1, 5, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140};
        for (int ringIndex = 0; ringIndex < radii.length; ++ringIndex) {
            int r = radii[ringIndex];
            int tntsPerRing = Math.min(75, Math.max(12, r * 2));
            int fuse = baseFuse + ringIndex * delayBetweenRings;
            for (int i = 0; i < tntsPerRing; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)tntsPerRing;
                double dx = Math.cos(angle);
                double dz = Math.sin(angle);
                double spawnX = (double)centerX + 0.5;
                double spawnZ = (double)centerZ + 0.5;
                double travelDist = r;
                double vx = dx * (travelDist / (double)fuse) * velocityMultiplier;
                double vz = dz * (travelDist / (double)fuse) * velocityMultiplier;
                double vy = gravity;
                class_1541 tnt = new class_1541(world, spawnX, (double)centerY, spawnZ, null);
                tnt.method_6967(fuse);
                tnt.method_18800(vx, vy, vz);
                world.method_8649((class_1297)tnt);
            }
        }
    }

    public static void summonStab(class_1937 world, int centerX, int centerZ, int startY, int depth) {
        for (int i = 0; i < depth; ++i) {
            int y = startY - i;
            class_1541 tnt = new class_1541(world, (double)centerX + 0.5, (double)y, (double)centerZ + 0.5, null);
            tnt.method_6967(0);
            world.method_8649((class_1297)tnt);
        }
    }
}

