/*
 * Decompiled with CFR 0.152.
 */
package com.lying.chairspace;

import com.google.common.collect.Lists;
import com.lying.Wheelchairs;
import com.lying.chairspace.ChairspaceCondition;
import com.lying.entity.IParentedEntity;
import com.lying.init.WHCChairspaceConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.Event;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Chairspace
extends class_18 {
    public static final String ID = "chairspace";
    public static final class_18.class_8645<Chairspace> TYPE = new class_18.class_8645(Chairspace::new, Chairspace::createFromNbt, null);
    private List<PlayerStorage> storage = Lists.newArrayList();

    public static Chairspace getChairspace(MinecraftServer server) {
        class_3218 world = server.method_3847(class_1937.field_25179);
        class_26 manager = world.method_17983();
        Chairspace chairs = (Chairspace)manager.method_17924(TYPE, ID);
        chairs.method_80();
        return chairs;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 lookup) {
        this.storage.removeIf(PlayerStorage::isEmpty);
        nbt.method_10566("Data", (class_2520)PlayerStorage.LIST_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.storage).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).get());
        return nbt;
    }

    public static Chairspace createFromNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        Chairspace chairs = new Chairspace();
        chairs.storage.clear();
        chairs.storage.addAll((Collection)PlayerStorage.LIST_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("Data")).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow());
        return chairs;
    }

    public boolean hasEntityFor(UUID ownerID) {
        return this.storage.stream().anyMatch(s -> s.playerID().equals(ownerID) && !s.isEmpty());
    }

    public void storeEntityInChairspace(class_1297 ent, UUID ownerID, ChairspaceCondition condition, Flag ... flags) {
        if (ent == null || ent.method_37908().method_8608()) {
            return;
        }
        RespawnData entry = RespawnData.of(ent, flags);
        Predicate<PlayerStorage> predicate = s -> s.playerID().equals(ownerID);
        if (this.storage.stream().anyMatch(predicate)) {
            this.storage.stream().filter(predicate).forEach(s -> s.add(condition, entry));
        } else {
            this.storage.add(new PlayerStorage(ownerID).add(condition, entry));
        }
        ent.method_31472();
        this.method_80();
        Wheelchairs.LOGGER.info(" # Stored entity {} in Chairspace with condition {} by {}", new Object[]{ent.method_5477().getString(), condition.registryName().toString(), ownerID.toString()});
    }

    public void reactToEvent(Event<?> eventIn, class_1297 owner) {
        WHCChairspaceConditions.getApplicable(eventIn).forEach(condition -> this.respawnForCondition(owner.method_5667(), owner, (ChairspaceCondition)condition));
    }

    public void respawnForCondition(UUID ownerID, class_1297 owner, ChairspaceCondition condition) {
        if (owner == null || owner.method_7325() || owner.method_37908() == null || owner.method_37908().method_8608() || !this.hasEntityFor(owner.method_5667()) || !condition.isApplicable(owner)) {
            return;
        }
        class_3218 world = (class_3218)owner.method_37908();
        List<PlayerStorage> wares = this.storage.stream().filter(s -> s.playerID().equals(ownerID)).toList();
        for (PlayerStorage w : wares) {
            if (!w.respawnFor(condition, owner, world)) continue;
            this.method_80();
        }
        this.storage.removeIf(PlayerStorage::isEmpty);
    }

    private static class PlayerStorage {
        public static final Codec<PlayerStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(p -> p.playerID().toString()), (App)ConditionEntry.CODEC.listOf().fieldOf("entries").forGetter(p -> p.entries)).apply((Applicative)instance, (id, entries) -> {
            PlayerStorage storage = new PlayerStorage(UUID.fromString(id));
            entries.forEach(storage::add);
            return storage;
        }));
        public static final Codec<List<PlayerStorage>> LIST_CODEC = CODEC.listOf();
        private final UUID playerID;
        private final List<ConditionEntry> entries = Lists.newArrayList();

        public PlayerStorage(UUID idIn) {
            this.playerID = idIn;
        }

        public boolean equals(Object obj) {
            return obj instanceof PlayerStorage && ((PlayerStorage)obj).playerID().equals(this.playerID);
        }

        public UUID playerID() {
            return this.playerID;
        }

        public boolean isEmpty() {
            return this.entries.isEmpty() || this.entries.stream().allMatch(ConditionEntry::isEmpty);
        }

        public PlayerStorage add(ConditionEntry entry) {
            if (this.entries.stream().noneMatch(e -> e.equals(entry))) {
                this.entries.add(entry);
            } else {
                this.entries.stream().filter(e -> e.equals(entry)).findFirst().ifPresent(e -> e.add(entry));
            }
            return this;
        }

        public PlayerStorage add(ChairspaceCondition condition, RespawnData data) {
            Predicate<ConditionEntry> predicate = ConditionEntry.matching(condition);
            if (this.entries.stream().noneMatch(predicate)) {
                this.entries.add(new ConditionEntry(condition).add(data));
            } else {
                this.entries.stream().filter(predicate).findFirst().ifPresent(e -> e.add(data));
            }
            return this;
        }

        public boolean respawnFor(ChairspaceCondition condition, class_1297 owner, class_3218 world) {
            Predicate<ConditionEntry> predicate = ConditionEntry.matching(condition);
            if (this.entries.stream().anyMatch(predicate)) {
                this.entries.stream().filter(predicate).forEach(entry -> entry.respawn(owner, world));
                this.entries.removeIf(e -> e.matches(condition));
                return true;
            }
            return false;
        }

        private static class ConditionEntry {
            public static final Codec<ConditionEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ChairspaceCondition.CODEC.fieldOf("condition").forGetter(ConditionEntry::condition), (App)RespawnData.CODEC.listOf().fieldOf("objects").forGetter(ConditionEntry::entries)).apply((Applicative)instance, (condition, entries) -> {
                ConditionEntry entry = new ConditionEntry((ChairspaceCondition)condition);
                entries.forEach(entry::add);
                return entry;
            }));
            private final ChairspaceCondition condition;
            private final List<RespawnData> entries = Lists.newArrayList();

            public static Predicate<ConditionEntry> matching(ChairspaceCondition c) {
                return a -> a.matches(c);
            }

            public ConditionEntry(ChairspaceCondition conditionIn) {
                this.condition = conditionIn;
            }

            public boolean equals(Object obj) {
                return obj instanceof ConditionEntry && this.matches(((ConditionEntry)obj).condition());
            }

            public boolean matches(ChairspaceCondition cond) {
                return cond.equals(this.condition);
            }

            public ChairspaceCondition condition() {
                return this.condition;
            }

            public List<RespawnData> entries() {
                return this.entries;
            }

            public boolean isEmpty() {
                return this.entries.isEmpty();
            }

            public ConditionEntry add(RespawnData data) {
                this.entries.add(data);
                return this;
            }

            public ConditionEntry add(ConditionEntry other) {
                if (other.condition().equals(this.condition)) {
                    this.entries.addAll(this.entries);
                }
                return this;
            }

            public void respawn(class_1297 owner, class_3218 world) {
                Wheelchairs.LOGGER.info(" # Respawning {} entities from Chairspace for {} under condition {}", new Object[]{this.entries.size(), owner.method_5667().toString(), this.condition.registryName().toString()});
                this.entries.forEach(entry -> this.condition.applyPostEffects(entry.respawn(owner, world)));
                this.entries.clear();
            }
        }
    }

    public record RespawnData(class_2487 entityData, EnumSet<Flag> flags) {
        public static final Codec<RespawnData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2487.field_25128.fieldOf("Entity").forGetter(r -> r.entityData()), (App)SerializedFlagSet.CODEC.fieldOf("Flags").forGetter(r -> r.flags)).apply((Applicative)instance, RespawnData::new));

        public static RespawnData of(class_1297 entity, Flag ... flagsIn) {
            class_2487 data = new class_2487();
            entity.method_5662(data);
            EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
            for (Flag flag : flagsIn) {
                flags.add(flag);
            }
            return new RespawnData(data, flags);
        }

        @Nullable
        public class_1297 respawn(class_1297 owner, class_3218 world) {
            class_1297 storedEntity = class_1299.method_17842((class_2487)this.entityData(), (class_1937)world, (class_3730)class_3730.field_52444, entity -> {
                entity.method_5808(owner.method_23317(), owner.method_23318(), owner.method_23321(), owner.method_36454(), owner.method_36455());
                return entity;
            });
            if (storedEntity != null) {
                Wheelchairs.LOGGER.info(" # - Restored entity {}", (Object)storedEntity.method_5477().getString());
                world.method_8649(storedEntity);
                this.flags().stream().forEach(f -> f.postRespawnAction.accept(owner, storedEntity));
            }
            return storedEntity;
        }

        private static class SerializedFlagSet {
            private static final Codec<EnumSet<Flag>> CODEC = Codec.of(SerializedFlagSet::encode, SerializedFlagSet::decode);

            private SerializedFlagSet() {
            }

            private static <T> DataResult<T> encode(EnumSet<Flag> set, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)ops.createList(set.stream().map(d -> ops.createString(d.method_15434()))));
            }

            private static <T> DataResult<Pair<EnumSet<Flag>, T>> decode(DynamicOps<T> ops, T input) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                set.addAll(ops.getStream(input).result().orElse(Stream.empty()).map(e -> Flag.get((String)ops.getStringValue(e).getOrThrow())).toList());
                return DataResult.success((Object)Pair.of(set, input));
            }
        }
    }

    public static enum Flag implements class_3542
    {
        MOUNT((owner, entity) -> {
            if (!owner.method_5765()) {
                owner.method_5804(entity);
            }
        }),
        PARENT((owner, entity) -> {
            class_1309 parent = (class_1309)owner;
            IParentedEntity child = (IParentedEntity)entity;
            class_243 offset = child.getParentOffset(parent, parent.method_36454(), parent.method_36455());
            entity.method_30634(parent.method_23317() + offset.method_10216(), parent.method_23318() + offset.method_10214(), parent.method_23321() + offset.method_10214());
            child.parentTo(parent);
        });

        private final BiConsumer<class_1297, class_1297> postRespawnAction;

        private Flag(BiConsumer<class_1297, class_1297> consumerIn) {
            this.postRespawnAction = consumerIn;
        }

        public String method_15434() {
            return this.name().toString();
        }

        @Nullable
        public static Flag get(String nameIn) {
            for (Flag flag : Flag.values()) {
                if (!flag.name().equals(nameIn)) continue;
                return flag;
            }
            return null;
        }
    }
}

