/*
 * Decompiled with CFR 0.152.
 */
package com.lying.chairspace;

import com.google.common.collect.Lists;
import com.lying.Wheelchairs;
import com.lying.init.WHCChairspaceConditions;
import com.lying.reference.Reference;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.event.Event;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChairspaceCondition {
    public static final Codec<ChairspaceCondition> CODEC = Codec.of(ChairspaceCondition::encodeToOps, ChairspaceCondition::decodeFromOps);
    private final class_2960 registryName;
    private final List<Event<?>> firedBy = Lists.newArrayList();
    private final Predicate<class_1297> canApplyTo;
    private final Consumer<class_1297> postEffect;

    private static <T> DataResult<T> encodeToOps(ChairspaceCondition func, DynamicOps<T> ops, T prefix) {
        return DataResult.success((Object)ops.createString(func.registryName.toString()));
    }

    private static <T> DataResult<Pair<ChairspaceCondition, T>> decodeFromOps(DynamicOps<T> ops, T input) {
        ChairspaceCondition condition = WHCChairspaceConditions.get(class_2960.method_60654((String)((String)ops.getStringValue(input).getOrThrow())));
        return condition == null ? DataResult.error(() -> "Error reading Chairspace condition from data") : DataResult.success((Object)Pair.of((Object)condition, input));
    }

    private ChairspaceCondition(class_2960 nameIn, Predicate<class_1297> qualifierIn, Consumer<class_1297> postIn, Event<?> ... events) {
        this.registryName = nameIn;
        this.canApplyTo = qualifierIn;
        this.postEffect = postIn;
        for (Event<?> event : events) {
            this.firedBy.add(event);
        }
    }

    public <T> T encode(DynamicOps<T> ops) {
        return CODEC.encodeStart(ops, (Object)this).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow();
    }

    public static <T> ChairspaceCondition decode(DynamicOps<T> ops, T input) {
        return (ChairspaceCondition)CODEC.parse(ops, input).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow();
    }

    public class_2960 registryName() {
        return this.registryName;
    }

    public boolean equals(Object obj) {
        return obj instanceof ChairspaceCondition && ((ChairspaceCondition)obj).registryName.equals((Object)this.registryName);
    }

    public boolean isListeningTo(Event<?> event) {
        return this.firedBy.contains(event);
    }

    public boolean isApplicable(@NotNull class_1297 entity) {
        return this.canApplyTo.test(entity);
    }

    public void applyPostEffects(@Nullable class_1297 entity) {
        if (entity != null) {
            this.postEffect.accept(entity);
        }
    }

    public static class Builder {
        private final class_2960 regName;
        private List<Event<?>> firedBy = Lists.newArrayList();
        private Predicate<class_1297> canApplyTo = entity -> entity.method_5805();
        private Consumer<class_1297> postEffect = Consumers.nop();

        private Builder(class_2960 regNameIn) {
            this.regName = regNameIn;
        }

        public static Builder of(String nameIn) {
            return new Builder(Reference.ModInfo.prefix(nameIn));
        }

        public static Builder of(String nameIn, Event<?> event) {
            return Builder.of(nameIn).listen(event);
        }

        public Builder condition(Predicate<class_1297> conditionIn) {
            this.canApplyTo = conditionIn.and(this.canApplyTo);
            return this;
        }

        public Builder postEffect(Consumer<class_1297> postIn) {
            this.postEffect = postIn;
            return this;
        }

        public Builder listen(Event<?> ... eventIn) {
            for (Event<?> event : eventIn) {
                this.firedBy.add(event);
            }
            return this;
        }

        public ChairspaceCondition build() {
            return new ChairspaceCondition(this.regName, this.canApplyTo, this.postEffect, this.firedBy.toArray(new Event[0]));
        }
    }
}

