/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client;

import com.lying.Wheelchairs;
import com.lying.client.config.ClientConfig;
import com.lying.client.init.WHCKeybinds;
import com.lying.client.init.WHCModelParts;
import com.lying.client.renderer.entity.feature.CatVestLayer;
import com.lying.client.renderer.entity.feature.FoxVestLayer;
import com.lying.client.renderer.entity.feature.ParrotVestLayer;
import com.lying.client.renderer.entity.feature.WolfVestLayer;
import com.lying.client.screen.AACScreen;
import com.lying.client.utility.AACLibrary;
import com.lying.client.utility.ClientBus;
import com.lying.init.WHCBlocks;
import com.lying.init.WHCSoundEvents;
import com.lying.network.AACMessagePacket;
import com.lying.network.OpenInventoryScreenPacket;
import com.lying.network.SetSeatbeltPacket;
import com.lying.reference.Reference;
import com.mojang.text2speech.Narrator;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.class_10008;
import net.minecraft.class_10027;
import net.minecraft.class_10042;
import net.minecraft.class_10051;
import net.minecraft.class_10085;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1659;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3680;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4041;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5601;
import net.minecraft.class_583;
import net.minecraft.class_584;
import net.minecraft.class_624;
import net.minecraft.class_746;
import net.minecraft.class_922;

public class WheelchairsClient {
    public static final class_310 mc = class_310.method_1551();
    public static ClientConfig config;
    public static boolean SEATBELT_ON;
    public static boolean wasSeatbeltPressed;
    public static int loginState;

    public static void clientInit() {
        Wheelchairs.openAACScreen = (player, stack) -> mc.method_1507((class_437)new AACScreen(stack.method_7964()));
        config = new ClientConfig(WheelchairsClient.mc.field_1697.getAbsolutePath() + "/config/WheelchairsClient.cfg");
        config.read();
        Wheelchairs.LOGGER.info("Reading Wheelchairs client config:");
        Wheelchairs.LOGGER.info(" * Seatbelt login setting: " + config.seatbeltAtBoot());
        Wheelchairs.LOGGER.info(" * AAC proximity narration: " + config.shouldNarrateAAC());
        AACLibrary.init();
        ClientBus.registerEventCallbacks();
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)WHCBlocks.FROSTED_LAVA.get()});
        WHCModelParts.init((layer, definition) -> EntityModelLayerRegistry.register((class_5601)layer, (Supplier)definition));
        WheelchairsClient.registerEventCallbacks();
        WheelchairsClient.registerS2CPacketReceivers();
    }

    public static void registerEventCallbacks() {
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
            loginState = -1;
        });
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> ++loginState);
        ClientTickEvent.CLIENT_PRE.register(client -> {
            class_746 player = WheelchairsClient.mc.field_1724;
            if (loginState == 0 && WheelchairsClient.mc.field_1724 != null) {
                boolean bl = SEATBELT_ON = config.seatbeltAtBoot() && player.method_5765();
                if (config.seatbeltAtBoot()) {
                    WheelchairsClient.mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)("gui.wheelchairs.seatbelt_" + (SEATBELT_ON ? "on" : "off"))));
                }
                ++loginState;
            }
        });
        ClientTickEvent.CLIENT_POST.register(client -> {
            class_746 player = WheelchairsClient.mc.field_1724;
            if (player != null) {
                while (WHCKeybinds.keyOpenChair.method_1436()) {
                    OpenInventoryScreenPacket.send(WheelchairsClient.mc.field_1692 != null ? WheelchairsClient.mc.field_1692.method_5667() : null);
                }
                if (WHCKeybinds.keySeatbelt.method_1436() && !wasSeatbeltPressed && player.method_5765()) {
                    SEATBELT_ON = !SEATBELT_ON;
                    SetSeatbeltPacket.send(SEATBELT_ON);
                    player.method_5783(SEATBELT_ON ? (class_3414)WHCSoundEvents.SEATBELT_ON.get() : (class_3414)WHCSoundEvents.SEATBELT_OFF.get(), 1.0f, 0.5f + player.method_59922().method_43057() * 0.5f);
                    wasSeatbeltPressed = true;
                } else {
                    wasSeatbeltPressed = false;
                }
            }
        });
    }

    private static void registerS2CPacketReceivers() {
        Wheelchairs.LOGGER.info(" # Registered client-side packet receivers");
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), AACMessagePacket.Payload.Receive.PACKET_TYPE, AACMessagePacket.Payload.Receive.PACKET_CODEC, (value, context) -> {
            if (WheelchairsClient.mc.field_1690.method_42539().method_41753() != class_1659.field_7538) {
                return;
            }
            class_5250 text = value.message().method_27661().method_27694(style -> style.method_10958(null));
            class_1657 sender = context.getPlayer().method_37908().method_18470(value.playerID());
            class_5250 senderName = (sender == null ? value.playerName() : sender.method_5476()).method_27661();
            class_5250 message = Reference.ModInfo.translate("aac", "message", senderName, text).method_27661();
            WheelchairsClient.mc.field_1705.method_1743().method_1812((class_2561)message);
            if (config.shouldNarrateAAC() && sender != WheelchairsClient.mc.field_1724 && sender != null && (double)WheelchairsClient.mc.field_1724.method_5739((class_1297)sender) < 16.0) {
                Narrator narrator = Narrator.getNarrator();
                narrator.clear();
                narrator.say(text.getString(), true);
            }
        });
    }

    public static <T extends class_1309, C extends class_10042, M extends class_583<C>> class_3887<C, M> getVestFeatureForType(class_1299<T> entityType, class_922<T, C, M> renderer) {
        if (entityType == class_1299.field_6055) {
            return new WolfVestLayer((class_3883<class_10085, class_624>)renderer);
        }
        if (entityType == class_1299.field_16281) {
            return new CatVestLayer((class_3883<class_10008, class_3680>)renderer);
        }
        if (entityType == class_1299.field_6104) {
            return new ParrotVestLayer((class_3883<class_10051, class_584>)renderer);
        }
        if (entityType == class_1299.field_17943) {
            return new FoxVestLayer((class_3883<class_10027, class_4041>)renderer);
        }
        return null;
    }

    static {
        SEATBELT_ON = false;
        wasSeatbeltPressed = false;
        loginState = -1;
    }
}

