/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.config;

import com.lying.config.Config;
import java.io.FileWriter;
import java.util.Properties;

public class ClientConfig
extends Config {
    private static final Properties DEFAULT_SETTINGS = new Properties();
    private boolean seatbeltDefault = false;
    private boolean narrateAAC = true;

    public ClientConfig(String fileIn) {
        super(fileIn);
    }

    @Override
    protected Properties getDefaults() {
        return DEFAULT_SETTINGS;
    }

    @Override
    protected void readValues(Properties valuesIn) {
        this.seatbeltDefault = ClientConfig.parseBoolOr(valuesIn.getProperty("Seatbelt"), false);
        this.narrateAAC = ClientConfig.parseBoolOr(valuesIn.getProperty("NarrateAAC"), true);
    }

    @Override
    protected void writeValues(FileWriter writer) {
        ClientConfig.writeBool(writer, "Seatbelt", this.seatbeltDefault);
        ClientConfig.writeBool(writer, "NarrateAAC", this.narrateAAC);
    }

    public boolean seatbeltAtBoot() {
        return this.seatbeltDefault;
    }

    public boolean shouldNarrateAAC() {
        return this.narrateAAC;
    }

    static {
        DEFAULT_SETTINGS.setProperty("Seatbelt", "0");
        DEFAULT_SETTINGS.setProperty("NarrateAAC", "1");
    }
}

